/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.entities.GUID;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.user.RB;
import com.sas.services.user.UserIdentityInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.util.ResourceBundle;

public class SimpleUserIdentity
implements UserIdentityInterface,
Serializable,
Cloneable,
ConsumedResourceInterface {
    private static final long serialVersionUID = -5209918635501350317L;
    private String _uid = GUID.newGUID();
    private boolean _authFlag;
    private String _principal;
    private String _credential;
    private String _domain;
    private boolean _isPrimary;
    private String _resolvedName;
    private boolean _isSticky;

    public SimpleUserIdentity() {
    }

    public SimpleUserIdentity(boolean isPrimary) {
        this._isPrimary = isPrimary;
    }

    public SimpleUserIdentity(String principal, String credential, String domain) {
        this();
        if (principal == null) {
            throw new RuntimeException(RB.getStringResource("SimpleUserIdentity.nonullprincipal.ex.txt"));
        }
        this._principal = principal;
        this._credential = credential;
        if (this._credential == null) {
            this._credential = "";
        }
        this._domain = domain;
        if (this._domain == null) {
            this._domain = "";
        }
    }

    public SimpleUserIdentity(String uid, String principal, String credential, String domain) {
        this(principal, credential, domain);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public SimpleUserIdentity(String principal, String credential, String domain, boolean isPrimary) {
        this(principal, credential, domain);
        this._isPrimary = isPrimary;
    }

    @Override
    public boolean isAuthenticated() {
        return this._authFlag;
    }

    @Override
    public void setAuthenticated(boolean value) {
        this._authFlag = value;
    }

    @Override
    public String getDomain() {
        return this._domain;
    }

    @Override
    public void setDomain(String domain) {
        this._domain = domain;
    }

    @Override
    public void setPrincipal(Object principal) {
        this._principal = (String)principal;
    }

    @Override
    public Object getPrincipal() {
        return this._principal;
    }

    @Override
    public void setCredential(Object credential) {
        this._credential = (String)credential;
    }

    @Override
    public Object getCredential() {
        return this._credential;
    }

    @Override
    public String getMechanism() {
        return "simple";
    }

    @Override
    public Object getUserIdentity() {
        return this._principal;
    }

    @Override
    public void setUserIdentity(Object identity) {
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SimpleUserIdentity)) {
            return false;
        }
        SimpleUserIdentity otherGuy = (SimpleUserIdentity)object;
        return Strings.equal((String)this._domain, (String)otherGuy.getDomain(), (boolean)false, (boolean)false) && this._principal.equals(otherGuy.getPrincipal()) && this._credential.equals(otherGuy.getCredential());
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = 31;
        hashCode = 31 * hashCode + (this._credential == null ? 0 : this._credential.hashCode());
        hashCode = 31 * hashCode + (this._domain == null ? 0 : this._domain.hashCode());
        hashCode = 31 * hashCode + (this._principal == null ? 0 : this._principal.hashCode());
        hashCode += this._authFlag ? 1 : 0;
        return hashCode += this._isPrimary ? 1 : 0;
    }

    @Override
    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public boolean isPrimary() {
        return this._isPrimary;
    }

    public String toString() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"SimpleUserIdentity.toString.fmt.txt", (Object)this._principal, (Object)this._domain);
    }

    public void setResolvedUserName(String resolvedUserName) {
        this._resolvedName = resolvedUserName;
    }

    @Override
    public String getResolvedUserName() {
        return this._resolvedName;
    }

    public final boolean hasConflict(SimpleUserIdentity other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else {
            String otherDomain = other.getDomain();
            String otherResolvedName = other.getResolvedUserName();
            Object otherCredential = other.getCredential();
            Object otherPrincipal = other.getPrincipal();
            isEqual = !(this._authFlag != other.isAuthenticated() || this._isPrimary != other.isPrimary() || otherCredential != null && this._credential != null && !this._credential.equals(otherCredential) || otherPrincipal != null && this._principal != null && !this._principal.equals(otherPrincipal) || otherDomain != null && !"".equals(otherDomain) && this._domain != null && !Strings.equal((String)otherDomain, (String)this._domain, (boolean)false, (boolean)false) || otherResolvedName != null && !"".equals(otherResolvedName) && this._resolvedName != null && !Strings.equal((String)otherResolvedName, (String)this._resolvedName, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(SimpleUserIdentity newObject) {
        if (newObject != null) {
            Object object;
            this.setAuthenticated(newObject.isAuthenticated());
            this._isPrimary = newObject.isPrimary();
            this.setResolvedUserName(newObject.getResolvedUserName());
            String value = newObject.getDomain();
            if (value != null) {
                this.setDomain(value);
            }
            if ((object = newObject.getCredential()) != null) {
                this.setCredential(object);
            }
            if ((object = newObject.getPrincipal()) != null) {
                this.setPrincipal(object);
            }
        }
    }

    void replace(SimpleUserIdentity newObject) {
        if (newObject != null) {
            this._isPrimary = newObject.isPrimary();
            this.setAuthenticated(newObject.isAuthenticated());
            this.setCredential(newObject.getCredential());
            this.setDomain(newObject.getDomain());
            this.setPrincipal(newObject.getPrincipal());
            this.setResolvedUserName(newObject.getResolvedUserName());
        }
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._principal;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("SimpleUserIdentity.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.user.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "User";
    }

    @Override
    public int getResourceTypeCode() {
        return 5;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    public boolean isSticky() {
        return this._isSticky;
    }

    public void setSticky(boolean sticky) {
        this._isSticky = sticky;
    }
}

