/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceFactory;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.session.RB;
import com.sas.services.session.SessionService;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.session.SessionServiceProfile;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SessionServiceFactory
extends AbstractServiceFactory {
    public SessionServiceFactory() {
        super(new SessionServiceProfile());
    }

    @Override
    public final RemoteServiceInterface getService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        SessionServiceInterface service = null;
        try {
            service = SessionService.getInstance(serviceConfiguration, discoveryService);
        }
        catch (RuntimeException e) {
            LogManager.getLogger(SessionServiceFactory.class).error(RB.getStringResource("SessionServiceFactory.unableToObtainService.ex.txt"), (Throwable)e);
            throw e;
        }
        return service;
    }

    public static final SessionServiceInterface createService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        return (SessionServiceInterface)new SessionServiceFactory().getService(serviceConfiguration, discoveryService);
    }
}

