/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.session.RB;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
class SessionContextDeferredMap {
    private static final int TIMER_PERIOD = 120000;
    private static final int TIMER_DELAY = 120000;
    private Map _sessions;
    private static Timer _timer = null;
    private static TimerTask _timerTask = null;
    private Logger logger = LogManager.getLogger(SessionContextDeferredMap.class);
    public static final String RB_KEY = "SessionContextDeferredMap.";

    SessionContextDeferredMap() {
        this._sessions = new HashMap();
    }

    public synchronized void add(SessionContextInterface sessionContext, long delay) throws ServiceException, IllegalArgumentException {
        if (sessionContext == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSession.ex.txt"));
        }
        try {
            SessionContextListEntry entry = new SessionContextListEntry(sessionContext, delay);
            this._sessions.put(sessionContext.getEntityKey(), entry);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContextDeferredMap.add.fmt.txt", (Object)sessionContext.getEntityKey(), (Object)Long.toString(delay)));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource(RB_KEY, "add.ex.txt"));
        }
        if (_timer == null) {
            this.createTimer();
        }
    }

    public void destroy() {
        if (_timerTask != null) {
            _timerTask.cancel();
            _timerTask = null;
        }
        if (_timer != null) {
            _timer.cancel();
            _timer = null;
        }
    }

    private void createTimer() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource(RB_KEY, "timerStart.txt"));
        }
        _timer = new Timer(true);
        _timerTask = new CheckDeferredDestroys(this);
        _timer.schedule(_timerTask, 120000L, 120000L);
    }

    public synchronized void remove(String uniqueId) {
        SessionContextListEntry entry = (SessionContextListEntry)this._sessions.get(uniqueId);
        if (entry == null) {
            return;
        }
        this._sessions.remove(uniqueId);
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContextDeferredMap.remove.fmt.txt", (Object)uniqueId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        boolean isDebugLogEnabled;
        Iterator it = null;
        boolean bl = isDebugLogEnabled = this.logger != null && this.logger.isDebugEnabled();
        if (isDebugLogEnabled) {
            this.logger.debug(RB.getStringResource(RB_KEY, "checkDelays.txt"));
        }
        SessionContextDeferredMap sessionContextDeferredMap = this;
        synchronized (sessionContextDeferredMap) {
            it = new ArrayList(this._sessions.values()).iterator();
        }
        while (it.hasNext()) {
            SessionContextListEntry entry;
            block15: {
                entry = (SessionContextListEntry)it.next();
                if (entry == null || !entry.isTimeToDestroy()) continue;
                SessionContextInterface sc = entry.getSessionContext();
                if (isDebugLogEnabled) {
                    this.logger.debug(RB.getStringResource(RB_KEY, "deferred.txt"));
                }
                try {
                    sc.destroy();
                }
                catch (Exception e) {
                    if (!isDebugLogEnabled) break block15;
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContextDeferredMap.deferredDestroy.fmt.txt", (Object)entry.getEntityKey()), (Throwable)e);
                }
            }
            this.remove(entry.getEntityKey());
        }
        sessionContextDeferredMap = this;
        synchronized (sessionContextDeferredMap) {
            if (this._sessions.size() == 0) {
                if (isDebugLogEnabled) {
                    this.logger.debug(RB.getStringResource(RB_KEY, "timerStop.txt"));
                }
                if (_timerTask != null) {
                    _timerTask.cancel();
                    _timerTask = null;
                }
                if (_timer != null) {
                    _timer.cancel();
                    _timer = null;
                }
            }
        }
    }

    @SASScope
    private class CheckDeferredDestroys
    extends TimerTask {
        private SessionContextDeferredMap deferredMap = null;

        CheckDeferredDestroys(SessionContextDeferredMap sessionMap) {
            this.deferredMap = sessionMap;
        }

        @Override
        public void run() {
            this.deferredMap.cleanup();
        }
    }

    @SASScope
    private class SessionContextListEntry {
        private SessionContextInterface _sessionContext;
        private long _cachedTime;
        private long _delay;
        private String _uniqueId;

        SessionContextListEntry(SessionContextInterface sessionContext, long delay) throws RemoteException, IllegalArgumentException {
            this._sessionContext = sessionContext;
            this._cachedTime = System.currentTimeMillis();
            this._delay = delay;
            this._uniqueId = sessionContext.getEntityKey();
        }

        boolean isTimeToDestroy() {
            return System.currentTimeMillis() - this._cachedTime >= this._delay;
        }

        String getEntityKey() {
            return this._uniqueId;
        }

        SessionContextInterface getSessionContext() {
            return this._sessionContext;
        }
    }
}

