/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.services.security.RB;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.net.URL;
import java.rmi.dgc.VMID;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ResourceBundle;
import java.util.Set;

public final class SecurityUtil {
    private SecurityUtil() {
    }

    public static void checkPermission(UserContextInterface user, Permission permission) throws AccessControlException {
        block10: {
            SecurityManager security = System.getSecurityManager();
            if (security == null) {
                return;
            }
            boolean is_remote = false;
            Throwable t = new Throwable();
            StackTraceElement[] elements = t.getStackTrace();
            for (int i = 2; i < elements.length; ++i) {
                if (elements[i].getClassName().equals("java.security.AccessController") && elements[i].getMethodName().equals("doPrivileged")) {
                    is_remote = false;
                    break;
                }
                if (!elements[i].getClassName().endsWith(".rmi.server.UnicastServerRef")) continue;
                is_remote = true;
                break;
            }
            if (is_remote) {
                if (user == null) {
                    throw new AccessControlException(RB.getStringResource("Util.nulluser.ex.txt"), permission);
                }
                try {
                    Set principalSet = user.getPrincipals();
                    Principal[] principalArray = new Principal[principalSet.size()];
                    Object[] objects = principalSet.toArray();
                    for (int i = 0; i < objects.length; ++i) {
                        principalArray[i] = (Principal)objects[i];
                    }
                    URL csurl = null;
                    csurl = new URL("file:/" + new VMID().toString() + ".com//");
                    CodeSource cs = new CodeSource(csurl, (Certificate[])null);
                    ProtectionDomain pd = new ProtectionDomain(cs, null, null, principalArray);
                    Policy policy = Policy.getPolicy();
                    if (!policy.implies(pd, permission)) {
                        throw new AccessControlException(Message.format((ResourceBundle)RB.getResources(), (String)"Util.accesserror.ex.fmt.txt", (Object)permission.toString()), permission);
                    }
                    break block10;
                }
                catch (Exception ex) {
                    String message = ex.getMessage();
                    if (message == null || message.length() == 0) {
                        message = ex.getClass().getName();
                    }
                    throw new AccessControlException(message, permission);
                }
            }
            security.checkPermission(permission);
        }
    }
}

