/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.security.login.ConnectionResourcesCallback;
import com.sas.services.security.login.DomainCallback;
import com.sas.services.security.login.HostCallback;
import com.sas.services.security.login.OptionsCallback;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.ServicesConnectionFactoryManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoginCallbackHandler
implements Serializable,
CallbackHandler {
    static final long serialVersionUID = 3555268107979468293L;
    private UserIdentityInterface _ident;
    private UserContextInterface _user;
    private String _domain;
    private Map _options;
    private static Class _wlmClass;
    private static Method _wlmGDOMMethod;
    private static Class _dlmcClass;
    private static Method _dlmcGDCNMethod;
    private static Method _dlmcSDMethod;
    private static Method _dlmcSLEMethod;

    public LoginCallbackHandler(UserContextInterface user, UserIdentityInterface ident, Map options) {
        this._ident = ident;
        this._user = user;
        this._options = options;
    }

    public void setIdentity(UserIdentityInterface ident) {
        this._ident = ident;
    }

    public void setContext(UserContextInterface user) {
        this._user = user;
    }

    public void setOptions(Map options) {
        this._options = options;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        block18: {
            try {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback nc = (NameCallback)callbacks[i];
                        if (this._ident == null) continue;
                        nc.setName("[@" + this._ident.getDomain() + ']' + (String)this._ident.getPrincipal());
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        PasswordCallback pc = (PasswordCallback)callbacks[i];
                        if (this._ident == null) continue;
                        pc.setPassword(((String)this._ident.getCredential()).toCharArray());
                        continue;
                    }
                    if (callbacks[i] instanceof DomainCallback) {
                        DomainCallback dc = (DomainCallback)callbacks[i];
                        if (this._ident == null && this._domain == null) {
                            throw new UnsupportedCallbackException((Callback)dc);
                        }
                        if (this._ident != null) {
                            dc.setDomain(this._ident.getDomain());
                            continue;
                        }
                        dc.setDomain(this._domain);
                        continue;
                    }
                    if (callbacks[i] instanceof HostCallback) {
                        HostCallback hc = (HostCallback)callbacks[i];
                        String hostURL = null;
                        if (hostURL == null) {
                            hc.setHostName(hc.getDefaultHost());
                            hc.setPort(hc.getDefaultPort());
                            continue;
                        }
                        int index = hostURL.indexOf(":");
                        index = hostURL.lastIndexOf("/");
                        int hostend = hostURL.indexOf(":", index);
                        if (hostend == -1) {
                            hostend = hostURL.length();
                        }
                        String host = hostURL.substring(index + 1, hostend);
                        hc.setHostName(host);
                        if (hostend == hostURL.length()) continue;
                        int portInt = Integer.valueOf(hostURL.substring(hostend + 1));
                        hc.setPort(portInt);
                        continue;
                    }
                    if (callbacks[i] instanceof OptionsCallback) {
                        OptionsCallback oc = (OptionsCallback)callbacks[i];
                        String key = oc.getKey();
                        Object value = this._options.get(key);
                        if (value == null) continue;
                        oc.setValue(value);
                        continue;
                    }
                    if (callbacks[i] instanceof ConnectionResourcesCallback) {
                        ConnectionResourcesCallback crc = (ConnectionResourcesCallback)callbacks[i];
                        ServicesConnectionFactoryManager cxfManager = new ServicesConnectionFactoryManager();
                        crc.setConnectionFactoryManager((ConnectionFactoryManager)cxfManager);
                        continue;
                    }
                    if (_dlmcClass == null || !_dlmcClass.isInstance(callbacks[i])) continue;
                    Callback dlmcObject = callbacks[i];
                    String delegateClassName = LoginCallbackHandler.dlmcGetDelegateClassName(dlmcObject);
                    LoginModule delegate = null;
                    try {
                        Class<?> delegateClass = Class.forName(delegateClassName);
                        delegate = (LoginModule)delegateClass.newInstance();
                        LoginCallbackHandler.dlmcSetDelegate(dlmcObject, delegate);
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        LoginCallbackHandler.dlmcSetLoginException(dlmcObject, cnfe);
                        continue;
                    }
                    catch (IllegalAccessException iae) {
                        LoginCallbackHandler.dlmcSetLoginException(dlmcObject, iae);
                        continue;
                    }
                    catch (InstantiationException ie) {
                        LoginCallbackHandler.dlmcSetLoginException(dlmcObject, ie);
                        continue;
                    }
                    catch (ClassCastException cce) {
                        LoginCallbackHandler.dlmcSetLoginException(dlmcObject, cce);
                    }
                }
            }
            catch (Exception ex) {
                if (this._user == null) break block18;
                Logger logger = LogManager.getLogger((String)"com.sas.services.user.UserContext");
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static Map getDelegateOptionMap(Map optionMap) {
        if (_wlmGDOMMethod != null) {
            optionMap = LoginCallbackHandler.wlmGetDelegateOptionMap(optionMap);
        }
        return optionMap;
    }

    private static void loadWrapperLoginModuleSupport() {
        try {
            String wlmClassName = "com.sas.services.ra.login.WrapperLoginModule";
            _wlmClass = Class.forName(wlmClassName);
            String dlmcClassName = "com.sas.services.ra.login.DelegateLoginModuleCallback";
            _dlmcClass = Class.forName(dlmcClassName);
        }
        catch (ClassNotFoundException cnfe) {
            _wlmClass = null;
            _dlmcClass = null;
            return;
        }
        try {
            String wlmGDOMMethodName = "getDelegateOptionMap";
            Class[] wlmGDOMMethodArgt = new Class[]{Map.class};
            _wlmGDOMMethod = _wlmClass.getMethod(wlmGDOMMethodName, wlmGDOMMethodArgt);
            String dlmcGDCNMethodName = "getDelegateClassName";
            _dlmcGDCNMethod = _dlmcClass.getMethod(dlmcGDCNMethodName, null);
            String dlmcSDMethodName = "setDelegate";
            Class[] dlmcSDMethodArgt = new Class[]{LoginModule.class};
            _dlmcSDMethod = _dlmcClass.getMethod(dlmcSDMethodName, dlmcSDMethodArgt);
            String dlmcSLEMethodName = "setLoginException";
            Class[] dlmcSLEMethodArgt = new Class[]{LoginException.class};
            _dlmcSLEMethod = _dlmcClass.getMethod(dlmcSLEMethodName, dlmcSLEMethodArgt);
        }
        catch (NoSuchMethodException nsme) {
            String msg = nsme.getMessage();
            throw LoginCallbackHandler.newIncompatibleClassChangeError(msg, nsme);
        }
    }

    private static String dlmcGetDelegateClassName(Callback dlmcObject) {
        String delegateClassName = (String)LoginCallbackHandler.invoke(_dlmcGDCNMethod, dlmcObject, null, String.class);
        return delegateClassName;
    }

    private static void dlmcSetDelegate(Callback dlmcObject, LoginModule delegate) {
        Object[] argv = new Object[]{delegate};
        LoginCallbackHandler.invoke(_dlmcSDMethod, dlmcObject, argv, null);
    }

    private static void dlmcSetLoginException(Callback dlmcObject, Throwable cause) {
        LoginException loginException = null;
        try {
            loginException = (LoginException)cause;
        }
        catch (ClassCastException cce) {
            loginException = new LoginException();
            loginException.initCause(cause);
        }
        Object[] argv = new Object[]{loginException};
        LoginCallbackHandler.invoke(_dlmcSLEMethod, dlmcObject, argv, null);
    }

    private static Map wlmGetDelegateOptionMap(Map optionMap) {
        Object[] argv = new Object[]{optionMap};
        optionMap = (Map)LoginCallbackHandler.invoke(_wlmGDOMMethod, null, argv, Map.class);
        return optionMap;
    }

    private static Object invoke(Method meth, Object obj, Object[] argv, Class resultType) {
        Object result = null;
        try {
            result = meth.invoke(obj, argv);
        }
        catch (InvocationTargetException ite) {
            String msg = _wlmGDOMMethod.toString();
            Throwable cause = ite.getCause();
            throw LoginCallbackHandler.newIncompatibleClassChangeError(msg, cause);
        }
        catch (IllegalAccessException iae) {
            String msg = _wlmGDOMMethod.toString();
            throw LoginCallbackHandler.newIncompatibleClassChangeError(msg, iae);
        }
        if (resultType != null && !resultType.isInstance(result)) {
            String msg = _wlmGDOMMethod.toString();
            String name = resultType.getName();
            ClassCastException cause = new ClassCastException(name);
            throw LoginCallbackHandler.newIncompatibleClassChangeError(msg, cause);
        }
        return result;
    }

    private static IncompatibleClassChangeError newIncompatibleClassChangeError(String msg, Throwable cause) {
        IncompatibleClassChangeError error = new IncompatibleClassChangeError(msg);
        error.initCause(cause);
        return error;
    }

    static {
        LoginCallbackHandler.loadWrapperLoginModuleSupport();
    }
}

