/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.logging.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@Deprecated
@SASScope
public final class Renderer
implements Cloneable,
ConsumedResourceInterface {
    public static final String ELEMENTNAME = "Renderer";
    public static final String ATTRIBUTE_UID = "uid";
    public static final String ATTRIBUTE_RENDEREDCLASS = "renderedClass";
    public static final String ATTRIBUTE_RENDERINGCLASS = "renderingClass";
    public static final String PROPERTYNAME_RENDEREDCLASS = "renderedClass";
    public static final String PROPERTYNAME_RENDERINGCLASS = "renderingClass";
    private String _uid = GUID.newGUID();
    private volatile String _renderedClass;
    private volatile String _renderingClass;
    private static final int PRIME_NUMBER = 31;

    public Renderer() {
    }

    public Renderer(String renderedClass, String renderingClass) {
        this.setRenderedClass(renderedClass);
        this.setRenderingClass(renderingClass);
    }

    public Renderer(String uid, String renderedClass, String renderingClass) {
        this(renderedClass, renderingClass);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public String getUID() {
        return this._uid;
    }

    public String getRenderedClass() {
        return this._renderedClass;
    }

    public void setRenderedClass(String renderedClass) {
        if (renderedClass != null) {
            this._renderedClass = renderedClass.trim();
        }
    }

    public String getRenderingClass() {
        return this._renderingClass;
    }

    public void setRenderingClass(String renderingClass) {
        if (renderingClass != null) {
            this._renderingClass = renderingClass.trim();
        }
    }

    boolean hasConflict(Renderer other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else {
            String otherRenderingClass = other.getRenderingClass();
            isEqual = Strings.equal((String)other.getRenderedClass(), (String)this.getRenderedClass(), (boolean)false, (boolean)false) && ("".equals(otherRenderingClass) || otherRenderingClass == null || this._renderingClass == null || Strings.equal((String)otherRenderingClass, (String)this._renderingClass, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(Renderer newRenderer) {
        if (newRenderer != null) {
            String value = newRenderer.getRenderedClass();
            if (value != null) {
                this.setRenderedClass(value);
            }
            if ((value = newRenderer.getRenderingClass()) != null && !"".equals(value)) {
                this.setRenderingClass(value);
            }
        }
    }

    void replace(Renderer newRenderer) {
        if (newRenderer != null) {
            this.setRenderedClass(newRenderer.getRenderedClass());
            this.setRenderingClass(newRenderer.getRenderingClass());
        }
    }

    DocumentFragment newDocumentFragment(Document document) {
        return Renderer.newDocumentFragment(document, this);
    }

    static DocumentFragment newDocumentFragment(Document document, Renderer renderer) {
        DocumentFragment documentFragment = null;
        if (document != null && renderer != null) {
            documentFragment = document.createDocumentFragment();
            Element elementRenderer = document.createElement(ELEMENTNAME);
            elementRenderer.setAttribute(ATTRIBUTE_UID, renderer.getUID());
            elementRenderer.setAttribute("renderedClass", renderer.getRenderedClass());
            elementRenderer.setAttribute("renderingClass", renderer.getRenderingClass());
            documentFragment.appendChild(elementRenderer);
        }
        return documentFragment;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj == null) {
            isEqual = false;
        } else {
            try {
                Renderer renderer = (Renderer)obj;
                isEqual = Strings.equal((String)this._renderedClass, (String)renderer.getRenderedClass(), (boolean)false, (boolean)false) && Strings.equal((String)this._renderingClass, (String)renderer.getRenderingClass(), (boolean)false, (boolean)false);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 31;
        if (this._renderedClass != null) {
            hashCode ^= this._renderedClass.hashCode();
        }
        if (this._renderingClass != null) {
            hashCode ^= this._renderingClass.hashCode();
        }
        return hashCode;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Renderer renderer = (Renderer)super.clone();
        return renderer;
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._renderedClass;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("Renderer.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"Common.ResourceTypeValue.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return ELEMENTNAME;
    }

    @Override
    public int getResourceTypeCode() {
        return 2;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[renderedClass=");
        sb.append(this._renderedClass);
        sb.append("][renderingClass=");
        sb.append(this._renderingClass);
        sb.append(']');
        return sb.toString();
    }
}

