/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.search.RB;

public enum SearchOperator {
    CONTAINS(RB.getStringResource("SearchOperator.Contains.txt"), "Contains", 1),
    EQUALS(RB.getStringResource("SearchOperator.Equals.txt"), "Equals", 0),
    STARTSWITH(RB.getStringResource("SearchOperator.StartsWith.txt"), "StartsWith", 2);

    private String _displayName;
    private String _operatorName;
    private int _filterOperator = -1;

    private SearchOperator(String displayName, String operatorName, int filterOperator) {
        this._displayName = displayName;
        this._operatorName = operatorName;
        this._filterOperator = filterOperator;
    }

    public int getFilterOperator() {
        return this._filterOperator;
    }

    public String getOperatorName() {
        return this._operatorName;
    }

    public String toString() {
        return this._displayName;
    }

    public static SearchOperator getSearchOperatorForValue(int lvalue) {
        if (lvalue == CONTAINS.getFilterOperator()) {
            return CONTAINS;
        }
        if (lvalue == EQUALS.getFilterOperator()) {
            return EQUALS;
        }
        if (lvalue == STARTSWITH.getFilterOperator()) {
            return STARTSWITH;
        }
        return SearchOperator.getDefaultOperator();
    }

    public static SearchOperator getSearchOperatorForValue(String value) {
        if (value != null) {
            if (value.equalsIgnoreCase(CONTAINS.getOperatorName())) {
                return CONTAINS;
            }
            if (value.equalsIgnoreCase(EQUALS.getOperatorName())) {
                return EQUALS;
            }
            if (value.equalsIgnoreCase(STARTSWITH.getOperatorName())) {
                return STARTSWITH;
            }
        }
        return SearchOperator.getDefaultOperator();
    }

    private static SearchOperator getDefaultOperator() {
        return CONTAINS;
    }
}

