/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;

public class KeywordFilter
implements SearchFilter,
Serializable {
    private static final long serialVersionUID = -983951109236373179L;
    protected static final String KEYWORD_NAME = "Name";
    protected static final String ASSOCIATION_NAME = "Keywords";
    protected static final String ASSOCIATION_TYPE = "Keyword";
    protected List<String> _keywords = null;

    public KeywordFilter(List<String> keywords) {
        this._keywords = keywords;
    }

    public List<String> getKeywords() {
        return this._keywords;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("KeywordFilter.FilterName.txt");
    }

    @Override
    public String getFilterDescription() {
        if (this._keywords != null && this._keywords.size() > 0) {
            return Message.format((ResourceBundle)RB.getResources(), (String)"KeywordFilter.FilterDesc.fmt.txt", (Object)this.getKeywordsToDisplay());
        }
        return null;
    }

    private String getKeywordsToDisplay() {
        String sep = RB.getStringResource("Common.Separator.txt");
        StringBuilder sb = new StringBuilder();
        if (this._keywords != null) {
            for (String keyword : this._keywords) {
                if (sb.length() > 0) {
                    sb.append(sep);
                }
                sb.append("\"").append(keyword).append("\"");
            }
        }
        if (sb.length() == 0) {
            sb.append(RB.getStringResource("Common.NoFilters.txt"));
        }
        return sb.toString();
    }

    @Override
    public FilterComponent getFilterComponent() {
        FilterComponent comp = new FilterComponent();
        AssociationPathComponent ac1 = new AssociationPathComponent();
        ac1.setAssociationPath(ASSOCIATION_NAME, ASSOCIATION_TYPE);
        if (this._keywords != null) {
            FilterComponent keywordComp = new FilterComponent();
            keywordComp.setAggregation(1);
            int length = this._keywords.size();
            for (int i = 0; i < length; ++i) {
                String keyword = this._keywords.get(i);
                keywordComp.addComponent(new FilterComponent(KEYWORD_NAME, 0, keyword));
            }
            ac1.setAttributeCriteria(keywordComp);
        }
        comp.addAssociationPathComponent(ac1);
        return comp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof KeywordFilter) {
            KeywordFilter filter = (KeywordFilter)obj;
            return this.keywordsEqual(this._keywords, filter.getKeywords());
        }
        return false;
    }

    private boolean keywordsEqual(List<String> keywords1, List<String> keywords2) {
        if (keywords1 == null && keywords2 == null) {
            return true;
        }
        if (keywords1 == null && keywords2 != null || keywords1 != null && keywords2 == null) {
            return false;
        }
        if (keywords1.size() != keywords2.size()) {
            return false;
        }
        try {
            int length = keywords1.size();
            for (int index = 0; index < length; ++index) {
                String k1 = keywords1.get(index);
                String k2 = keywords2.get(index);
                if (k1 == null || k2 == null || k1.equalsIgnoreCase(k2)) continue;
                return false;
            }
        }
        catch (Exception re) {
            return false;
        }
        return true;
    }
}

