/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.services.information.sasfolders.UsersFolderNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class SASFoldersUtil {
    public static final char FOLDER_PATH_SEPARATOR = '/';
    private static final String SYSTEMS_FOLDER_NAME = "System";

    public static PublicObjectContainerInterface[] getContainerPath(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        ArrayList<PublicObjectContainerInterface> path = new ArrayList<PublicObjectContainerInterface>(6);
        for (PublicObjectContainerInterface parent = publicObject.getContainer(); parent != null; parent = parent.getContainer()) {
            path.add(parent);
        }
        if (path.size() > 1) {
            Collections.reverse(path);
        }
        return path.toArray(new PublicObjectContainerInterface[path.size()]);
    }

    public static OMIRepositoryInterface getRepositoryForObject(String objectID, ServerInterface server) throws ServiceException, RemoteException {
        String reposID = "A0000001." + objectID.substring(0, 8);
        List reposList = server.getRepositories(true);
        for (RepositoryInterface repos : reposList) {
            if (!(repos instanceof OMIRepositoryInterface) || !reposID.equalsIgnoreCase(((OMIRepositoryInterface)repos).getDefaultRepositoryId())) continue;
            return (OMIRepositoryInterface)repos;
        }
        return null;
    }

    public static String[] getObjectPath(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        return SASFoldersUtil.getObjectPath(publicObject, false);
    }

    public static String[] getObjectPath(PublicObjectInterface publicObject, boolean includeObjectName) throws ServiceException, RemoteException {
        ArrayList<String> path = new ArrayList<String>(6);
        if (includeObjectName) {
            path.add(publicObject.getName());
        }
        PublicObjectContainerInterface parent = publicObject.getContainer();
        while (parent != null) {
            PublicObjectContainerInterface container = parent.getContainer();
            if (container != null) {
                path.add(parent.getName());
            }
            parent = container;
        }
        if (path.size() > 0) {
            Collections.reverse(path);
        }
        return path.toArray(new String[path.size()]);
    }

    public static MetadataInterface getSmartObject(ServerInterface server, PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        String key = SASFoldersUtil.getISEntityKey(publicObject);
        return SASFoldersUtil.getSmartObject(server, key);
    }

    public static MetadataInterface getSmartObject(ServerInterface server, String objectID, String metadataType) throws ServiceException, RemoteException {
        String key = SASFoldersUtil.getISEntityKey(objectID, metadataType);
        return SASFoldersUtil.getSmartObject(server, key);
    }

    private static MetadataInterface getSmartObject(ServerInterface server, String key) throws ServiceException, RemoteException {
        if (server != null) {
            return server.fetch(key, true);
        }
        return null;
    }

    public static String getISEntityKey(PublicObjectInterface obj) throws ServiceException, RemoteException {
        TypeDescriptorInterface type = obj.getTypeDescriptor();
        return SASFoldersUtil.getISEntityKey(obj.getIdentifier(), type);
    }

    public static String getISEntityKey(String id, TypeDescriptorInterface type) throws ServiceException, RemoteException {
        if (type == null) {
            throw new ServiceException("Unable to search for object with unknown type");
        }
        return SASFoldersUtil.getISEntityKey(id, type.getMetadataType());
    }

    public static String getISEntityKey(String id, String metadataType) throws ServiceException, RemoteException {
        return id + "/" + metadataType;
    }

    public static boolean isUnique(PublicObjectInterface node) throws ServiceException, RemoteException {
        return SASFoldersUtil.isUnique(node.getContainer(), node.getName(), node.getTypeDescriptor().getTypeName());
    }

    public static boolean isUnique(PublicObjectContainerInterface parent, String childName, String childType) throws ServiceException, RemoteException {
        if (parent == null) {
            return true;
        }
        if (parent.getChildCount() > 0) {
            List children = parent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                PublicObjectInterface child = (PublicObjectInterface)children.get(i);
                if (!childType.equalsIgnoreCase(child.getTypeDescriptor().getTypeName()) || !childName.equalsIgnoreCase(child.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isRootFolder(PublicObjectInterface object) throws ServiceException, RemoteException {
        String type = object.getTypeDescriptor().getTypeName();
        return "RootFolder".equalsIgnoreCase(type);
    }

    public static boolean isFolder(PublicObjectInterface object) throws ServiceException, RemoteException {
        String type = object.getTypeDescriptor().getTypeName();
        return FolderUtil.isFolder(type) || "RootFolder".equalsIgnoreCase(type);
    }

    public static boolean isSystemFolder(FolderNodeInterface folder) throws ServiceException, RemoteException {
        if (folder == null || folder.getFolderModel() == null) {
            throw new IllegalArgumentException("Invalid folder node");
        }
        if (SYSTEMS_FOLDER_NAME.equalsIgnoreCase(folder.getName())) {
            FolderModelInterface model = folder.getFolderModel();
            ServerInterface server = model.getServer();
            OMIRepositoryInterface repos = SASFoldersUtil.getRepositoryForObject(folder.getIdentifier(), server);
            if (repos == null) {
                return false;
            }
            String type = repos.getRepositoryType();
            if ("FOUNDATION".equalsIgnoreCase(type)) {
                return folder.getContainer().equals(model.getRootFolder());
            }
            if ("CUSTOM".equalsIgnoreCase(type)) {
                List reposTopLevelFolders = server.getRootFolder().getSASFolders(repos);
                if (reposTopLevelFolders != null && !reposTopLevelFolders.isEmpty()) {
                    for (FolderInterface topLevelFolder : reposTopLevelFolders) {
                        String id = topLevelFolder.getIdentifier();
                        if (!id.equalsIgnoreCase(folder.getContainer().getIdentifier())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isUsersFolderNode(FolderNodeInterface folder) throws ServiceException, RemoteException {
        if (folder == null || folder.getFolderModel() == null) {
            throw new IllegalArgumentException("Invalid folder node");
        }
        FolderModelInterface model = folder.getFolderModel();
        return folder.getContainer().equals(model.getRootFolder()) && folder instanceof UsersFolderNode;
    }

    public static FolderNodeInterface getUsersFolderNode(SASFoldersModelInterface model) throws ServiceException, RemoteException {
        FolderNodeInterface rootFolder = model.getRootFolder();
        List<PublicObjectNodeInterface> children = rootFolder.getChildren();
        for (PublicObjectNodeInterface child : children) {
            if (!(child instanceof UsersFolderNode)) continue;
            return (FolderNodeInterface)child;
        }
        return null;
    }

    public static String getContainerType(String publicType, ServerInterface server) throws ServiceException, RemoteException {
        if (publicType == null) {
            return null;
        }
        TypeDescriptorInterface type = server.getTypeDescriptor(publicType);
        return type == null ? null : type.getContainerType();
    }

    public static boolean isValidContainerForChild(PublicObjectInterface child, PublicObjectContainerInterface container) throws ServiceException, RemoteException {
        if (child == null || container == null) {
            return false;
        }
        return SASFoldersUtil.isValidContainerForChild(child.getTypeDescriptor(), container.getTypeDescriptor());
    }

    public static boolean isValidContainerForChild(TypeDescriptorInterface childType, TypeDescriptorInterface containerType) throws ServiceException, RemoteException {
        if (childType == null || containerType == null) {
            return false;
        }
        if ("RootFolder".equalsIgnoreCase(containerType.getTypeName())) {
            return "Folder".equalsIgnoreCase(childType.getTypeName());
        }
        String type = childType.getContainerType();
        return type == null ? false : type.equalsIgnoreCase(containerType.getTypeName());
    }

    public static boolean isContainedByFolder(PublicObjectInterface object) throws ServiceException, RemoteException {
        if (object == null || object.getTypeDescriptor() == null) {
            return true;
        }
        String containerType = object.getTypeDescriptor().getContainerType();
        if ("Folder.Virtual".equalsIgnoreCase(containerType)) {
            return false;
        }
        return FolderUtil.isFolder(containerType);
    }

    public static boolean isContainedByFolder(String publicType, ServerInterface server) throws ServiceException, RemoteException {
        String containerType = SASFoldersUtil.getContainerType(publicType, server);
        if (containerType == null) {
            return true;
        }
        if ("Folder.Virtual".equalsIgnoreCase(containerType)) {
            return false;
        }
        return FolderUtil.isFolder(containerType);
    }

    public static boolean isContainedByVirtualFolder(PublicObjectInterface object) throws ServiceException, RemoteException {
        if (object == null || object.getTypeDescriptor() == null) {
            return true;
        }
        String containerType = object.getTypeDescriptor().getContainerType();
        return "Folder.Virtual".equalsIgnoreCase(containerType);
    }

    public static boolean isContainedByVirtualFolder(String publicType, ServerInterface server) throws ServiceException, RemoteException {
        String containerType = SASFoldersUtil.getContainerType(publicType, server);
        if (containerType == null) {
            return false;
        }
        return "Folder.Virtual".equalsIgnoreCase(containerType);
    }

    public static boolean areFolderPathsEqual(String[] path1, String[] path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.length != path2.length) {
            return false;
        }
        int len = path1.length;
        for (int index = 0; index < len; ++index) {
            String folder1 = path1[index];
            String folder2 = path2[index];
            if (folder1 == null || folder1.equalsIgnoreCase(folder2)) continue;
            return false;
        }
        return true;
    }

    public static boolean areFolderPathsEqual(List<String> path1, List<String> path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.size() != path2.size()) {
            return false;
        }
        int len = path1.size();
        for (int index = 0; index < len; ++index) {
            String folder1 = path1.get(index);
            String folder2 = path2.get(index);
            if (folder1 == null || folder1.equalsIgnoreCase(folder2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isChildOf(List<String> childPath, List<String> parentPath) {
        if (childPath == null || parentPath == null) {
            return false;
        }
        int length = parentPath.size();
        if (length == 0) {
            return true;
        }
        if (length > childPath.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (parentPath.get(i).equals(childPath.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isChildOf(String[] childPath, String[] parentPath) {
        if (childPath == null || parentPath == null) {
            return false;
        }
        int length = parentPath.length;
        if (length == 0) {
            return true;
        }
        if (length > childPath.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (parentPath[i].equals(childPath[i])) continue;
            return false;
        }
        return true;
    }

    public static PublicObjectInterface findNodeByPath(PathUrl path, FolderModelInterface model) throws ServiceException, RemoteException {
        PublicObjectInterface childNode;
        if (path == null) {
            return null;
        }
        PublicObjectInterface parentNode = model.getRootFolder();
        if (path.getRootTree() == null) {
            if (String.valueOf('/').equals(path.getName())) {
                return parentNode;
            }
            return null;
        }
        parentNode = SASFoldersUtil.getChild(parentNode, path.getRootTree(), "Folder");
        List<String> folderPath = SASFoldersUtil.parseFolderPath(path.getPath());
        if (folderPath.isEmpty() && path.getName() == null) {
            return parentNode;
        }
        for (String folderName : folderPath) {
            childNode = SASFoldersUtil.getChild(parentNode, folderName, "Folder");
            if (childNode != null) {
                parentNode = childNode;
                continue;
            }
            return null;
        }
        String type = path.getType();
        String name = path.getPrimaryName();
        childNode = SASFoldersUtil.getChild(parentNode, name, type);
        if (childNode == null) {
            return null;
        }
        if (path.getExtendedPath() != null) {
            return null;
        }
        return childNode;
    }

    private static PublicObjectInterface getChild(PublicObjectInterface parentNode, String childName, String childType) throws ServiceException, RemoteException {
        if (childName != null && childType != null && parentNode instanceof PublicObjectContainerInterface) {
            int index = childType.indexOf(46);
            if (index > -1) {
                childType = childType.substring(0, index);
            }
            List children = ((PublicObjectContainerInterface)parentNode).getChildren();
            for (PublicObjectInterface child : children) {
                TypeDescriptorInterface childTypeDesc = child.getTypeDescriptor();
                if (childTypeDesc == null) continue;
                String typeName = childTypeDesc.getTypeName();
                index = typeName.indexOf(46);
                if (index > -1) {
                    typeName = typeName.substring(0, index);
                }
                if (!childType.equalsIgnoreCase(typeName) || !childName.equalsIgnoreCase(child.getName()) || "Folder".equalsIgnoreCase(childType) && "RootFolder".equalsIgnoreCase(parentNode.getTypeDescriptor().getTypeName()) && child instanceof UsersFolderNode) continue;
                return child;
            }
        }
        return null;
    }

    public static PublicObjectInterface findChildObject(PublicObjectContainerInterface parent, String name, String type) throws ServiceException, RemoteException {
        if (name != null && type != null) {
            int index = type.indexOf(46);
            if (index > -1) {
                type = type.substring(0, index);
            }
            List children = parent.getChildren();
            for (PublicObjectInterface child : children) {
                String childType;
                TypeDescriptorInterface childTypeDesc;
                if (!name.equalsIgnoreCase(child.getName()) || (childTypeDesc = child.getTypeDescriptor()) == null || (childType = childTypeDesc.getTypeName()) == null) continue;
                index = childType.indexOf(46);
                if (index > -1) {
                    childType = childType.substring(0, index);
                }
                if (!type.equalsIgnoreCase(childType) || "Folder".equalsIgnoreCase(childType) && "RootFolder".equalsIgnoreCase(parent.getTypeDescriptor().getTypeName()) && child instanceof UsersFolderNode) continue;
                return child;
            }
        }
        return null;
    }

    public static PublicObjectNodeInterface findChildNode(ContainerNodeInterface parent, String name, String type) throws ServiceException, RemoteException {
        return SASFoldersUtil.findChildNode(parent, name, type, true);
    }

    public static PublicObjectNodeInterface findChildNode(ContainerNodeInterface parent, String name, String type, boolean populateContainers) throws ServiceException, RemoteException {
        if (name != null && type != null) {
            int index = type.indexOf(46);
            if (index > -1) {
                type = type.substring(0, index);
            }
            List<PublicObjectNodeInterface> children = null;
            if (populateContainers) {
                children = parent.getChildren();
            } else if (parent.isPopulated()) {
                children = parent.getChildren();
            }
            if (children != null) {
                for (PublicObjectNodeInterface child : children) {
                    String childType;
                    TypeDescriptorInterface childTypeDesc;
                    if (!name.equalsIgnoreCase(child.getName()) || (childTypeDesc = child.getTypeDescriptor()) == null || (childType = childTypeDesc.getTypeName()) == null) continue;
                    index = childType.indexOf(46);
                    if (index > -1) {
                        childType = childType.substring(0, index);
                    }
                    if (!type.equalsIgnoreCase(childType) || "Folder".equalsIgnoreCase(childType) && "RootFolder".equalsIgnoreCase(parent.getTypeDescriptor().getTypeName()) && child instanceof UsersFolderNode) continue;
                    return child;
                }
            }
        }
        return null;
    }

    public static FolderNodeInterface getSystemFolderNode(FolderModelInterface model, OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        if (repos == null) {
            throw new IllegalArgumentException("Invalid repository");
        }
        String type = repos.getRepositoryType();
        if ("FOUNDATION".equalsIgnoreCase(type)) {
            FolderNodeInterface rootFolder = model.getRootFolder();
            return (FolderNodeInterface)SASFoldersUtil.findChildNode(rootFolder, SYSTEMS_FOLDER_NAME, "Folder");
        }
        if ("CUSTOM".equalsIgnoreCase(type)) {
            List folders = repos.getRootFolders();
            if (folders.size() <= 0) {
                throw new ServiceException("No root folders were found for the repository \"" + repos.getDefaultRepositoryName() + "\".");
            }
            FolderInterface reposFolder = (FolderInterface)folders.get(0);
            FolderNodeInterface rootFolder = model.getRootFolder();
            FolderNodeInterface reposFolderNode = (FolderNodeInterface)SASFoldersUtil.findChildNode(rootFolder, reposFolder.getName(), "Folder");
            if (reposFolderNode != null) {
                return (FolderNodeInterface)SASFoldersUtil.findChildNode(reposFolderNode, SYSTEMS_FOLDER_NAME, "Folder");
            }
        }
        return null;
    }

    public static List<String> parseFolderPath(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(path, String.valueOf('/'));
        ArrayList<String> pathList = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            pathList.add(token);
        }
        return pathList;
    }
}

