/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.RB;
import com.sas.services.information.sasfolders.SASFoldersModel;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public class SASFoldersModel2
extends SASFoldersModel {
    private static final List<String> virtualFolderNames = Arrays.asList("Security", "Servers", "Access Control Templates", "Authentication Domains", "Roles", "User Groups", "Users");

    public SASFoldersModel2(ServerInterface server) throws ServiceException, RemoteException {
        super(server);
    }

    @Override
    public PublicObjectNodeInterface getObjectByPath(PathUrl path) throws ServiceException, RemoteException {
        String[] pathElements;
        PublicObjectNodeInterface node;
        ModelConfiguration config = this.getConfiguration();
        if (config != null && !config.isBypassingCache() && (node = (PublicObjectNodeInterface)SASFoldersUtil.findNodeByPath(path, this)) != null) {
            return node;
        }
        boolean isVirtual = false;
        String pathString = path.getDisplayPath();
        for (String pathElement : pathElements = pathString.split("/")) {
            if (!virtualFolderNames.contains(pathElement)) continue;
            isVirtual = true;
        }
        MetadataInterface meta = null;
        meta = isVirtual ? this._server.getObjectByPath(path) : this._server.getObjectByPathFilter(path);
        if (meta != null && meta.getTypeDescriptor() != null) {
            return this.getObject(meta);
        }
        return null;
    }

    private PublicObjectNodeInterface getObject(MetadataInterface smartObject) throws ServiceException, RemoteException {
        FolderNodeInterface rootFolder;
        TypeDescriptorInterface type = smartObject.getTypeDescriptor();
        if (type == null) {
            throw new ServiceException(RB.getStringResource("SASFoldersModel.InvalidType.txt"));
        }
        if ("RootFolder".equalsIgnoreCase(type.getTypeName()) && (rootFolder = this.getRootFolder()).getIdentifier().equalsIgnoreCase(smartObject.getIdentifier())) {
            return rootFolder;
        }
        if (SASFoldersUtil.isContainedByFolder(smartObject)) {
            return this.getObjectNode(smartObject.getIdentifier(), type);
        }
        return this.getObjectNode(smartObject);
    }
}

