/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.AbstractPublicObjectNode;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class ContainerNode
extends AbstractPublicObjectNode
implements ContainerNodeInterface {
    protected List<PublicObjectNodeInterface> _children;
    protected boolean _isPopulated = false;

    public ContainerNode(BrowseMetadataInterface browseObject) {
        super(browseObject);
    }

    public ContainerNode(String id, String name, TypeDescriptorInterface type) {
        super(id, name, type);
    }

    @Override
    public void addChild(PublicObjectInterface newChild) throws ServiceException, RemoteException {
        this.insertChild(newChild, this.getChildCount());
    }

    @Override
    public List<PublicObjectNodeInterface> getChildren() throws ServiceException, RemoteException {
        this.populateChildren();
        if (this._children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._children);
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        super.refresh();
        this.setPopulated(false);
        this.populateChildren();
    }

    @Override
    public PublicObjectNodeInterface getChildAt(int index) throws ServiceException, RemoteException {
        if (this._children == null || this._children.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("The container has no children");
        }
        return this._children.get(index);
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public void insertChild(PublicObjectInterface child, int index) throws ServiceException, RemoteException {
        if (child == null) {
            throw new IllegalArgumentException("Child item is null");
        }
        if (this.isNodeAncestor(child)) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ContainerNode.AncestorNode.fmt.txt", (Object)child.getName(), (Object)this.getName()));
        }
        if (this._children == null) {
            this._children = new ArrayList<PublicObjectNodeInterface>();
        }
        if (!this._children.contains(child) && child instanceof PublicObjectNodeInterface) {
            ((PublicObjectNodeInterface)child).setContainer(this);
            this._children.add(index, (PublicObjectNodeInterface)child);
        }
    }

    @Override
    public void removeChild(PublicObjectInterface child) throws ServiceException, RemoteException {
        if (child == null) {
            throw new IllegalArgumentException("Child item is null");
        }
        int index = this.getChildIndex(child);
        if (index > -1) {
            this._children.remove(index);
        }
    }

    @Override
    public boolean isPopulated() {
        return this._isPopulated;
    }

    @Override
    public void setPopulated(boolean populated) {
        this._isPopulated = populated;
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException("This method is not supported");
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException("This method is not supported");
    }

    protected void populateChildren() throws ServiceException, RemoteException {
        if (this._model != null && !this.isPopulated()) {
            if (this._children != null) {
                this._children.clear();
            }
            this._model.populateContainer(this);
        }
    }

    protected int getChildIndex(PublicObjectInterface child) throws ServiceException, RemoteException {
        if (child != null) {
            String objectID = child.getIdentifier();
            if (this._children != null && !this._children.isEmpty()) {
                int len = this._children.size();
                for (int index = 0; index < len; ++index) {
                    PublicObjectInterface childItem = this._children.get(index);
                    if (!(objectID == null || objectID.length() == 0 ? child.equals(childItem) : objectID.equalsIgnoreCase(childItem.getIdentifier()))) continue;
                    return index;
                }
            }
        }
        return -1;
    }

    protected boolean isNodeAncestor(PublicObjectInterface child) throws ServiceException, RemoteException {
        if (child == null) {
            return false;
        }
        PublicObjectContainerInterface ancestor = this;
        do {
            if (ancestor != child) continue;
            return true;
        } while ((ancestor = ancestor.getContainer()) != null);
        return false;
    }
}

