/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.RootFolderNode;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.UsersFolderNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractPublicObjectNode
extends BasePublicObject
implements PublicObjectNodeInterface {
    public static final char PATH_SEPARATOR = '/';
    protected FolderModelInterface _model;
    protected Object _userObject = null;

    public AbstractPublicObjectNode(BrowseMetadataInterface browse) {
        super(browse);
    }

    public AbstractPublicObjectNode(String id, String name, TypeDescriptorInterface type) {
        super(id, name, type);
    }

    @Override
    public void setContainer(PublicObjectContainerInterface container) throws ServiceException, RemoteException {
        this._container = container;
    }

    @Override
    public PublicObjectContainerInterface getContainer() throws ServiceException, RemoteException {
        return this._container;
    }

    @Override
    public void setFolderModel(FolderModelInterface model) throws ServiceException, RemoteException {
        this._model = model;
        this.setServer(model.getServer());
    }

    @Override
    public FolderModelInterface getFolderModel() {
        return this._model;
    }

    @Override
    public PathUrl getPathUrl() throws ServiceException, RemoteException {
        if (this._path != null) {
            return this._path;
        }
        String path = this.getNodePath();
        if (path == null) {
            MetadataInterface meta = SASFoldersUtil.getSmartObject(this._server, this);
            if (meta == null) {
                return null;
            }
            this._path = meta.getPathUrl();
        } else {
            this._path = PathUrl.newPathUrlFromAbsolutePath(this._model.getServer(), path);
        }
        return this._path;
    }

    @Override
    public String getAbsolutePath() throws ServiceException, RemoteException {
        PathUrl path = this.getPathUrl();
        return path == null ? "" : path.getAbsolutePath();
    }

    @Override
    public String getDisplayPath() throws ServiceException, RemoteException {
        PathUrl path = this.getPathUrl();
        return path == null ? this.getName() : path.getDisplayPath();
    }

    private String getNodePath() throws ServiceException, RemoteException {
        List<PublicObjectContainerInterface> parentPath = this.getParentContainerPath();
        if (this.isParentedByFolders(parentPath)) {
            String publicType;
            int length;
            StringBuilder sb = new StringBuilder(100);
            int n = length = parentPath == null ? 0 : parentPath.size();
            if (length == 0) {
                sb.append('/');
            } else {
                int containerIndex = 0;
                for (PublicObjectContainerInterface container : parentPath) {
                    if (containerIndex == 0 && container instanceof RootFolderNode) {
                        sb.append('/');
                        ++containerIndex;
                        continue;
                    }
                    sb.append(container.getName());
                    sb.append('/');
                }
            }
            if (sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(this.getName());
            TypeDescriptorInterface type = this.getTypeDescriptor();
            String string = publicType = type == null ? "Unknown" : type.getTypeName();
            if (publicType != null) {
                int index = publicType.indexOf(46);
                if (index > -1) {
                    publicType = publicType.substring(0, index);
                }
                sb.append("(");
                sb.append(publicType);
                sb.append(")");
            }
            return sb.toString();
        }
        return null;
    }

    private boolean isParentedByFolders(List<PublicObjectContainerInterface> containers) throws ServiceException, RemoteException {
        if (containers == null || containers.isEmpty()) {
            return false;
        }
        int containerIndex = 0;
        for (PublicObjectContainerInterface container : containers) {
            String containerType = container.getTypeDescriptor().getTypeName();
            if (containerIndex == 0 && "RootFolder".equalsIgnoreCase(containerType)) {
                ++containerIndex;
                continue;
            }
            if (FolderUtil.isFolder(containerType)) {
                if (container instanceof UsersFolderNode) {
                    return false;
                }
                ++containerIndex;
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getLevel() throws ServiceException, RemoteException {
        List<PublicObjectContainerInterface> parentPath = this.getParentContainerPath();
        return parentPath.size();
    }

    protected List<PublicObjectContainerInterface> getParentContainerPath() throws ServiceException, RemoteException {
        ArrayList<PublicObjectContainerInterface> parentPath = new ArrayList<PublicObjectContainerInterface>(6);
        for (PublicObjectContainerInterface parent = this._container; parent != null; parent = parent.getContainer()) {
            parentPath.add(parent);
        }
        if (parentPath.size() > 0) {
            Collections.reverse(parentPath);
        }
        return parentPath;
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        ServerInterface server = this.getServer();
        if (server != null && this._model != null) {
            String template;
            Filter filter = new Filter();
            ModelConfiguration config = this._model.getConfiguration();
            if (config != null && (template = config.getObjectDetails().getTemplate()) != null && template.length() > 0) {
                int flags = -2080374764;
                filter.setOMRFlags(flags);
                filter.setOMRTemplate("<Templates>" + template + "</Templates>");
            }
            BrowseMetadataInterface browse = server.browseFetch(SASFoldersUtil.getISEntityKey(this), filter);
            this.setBrowseObject(browse);
        }
    }

    @Override
    public void setUserObject(Object obj) throws ServiceException, RemoteException {
        this._userObject = obj;
    }

    @Override
    public Object getUserObject() throws ServiceException, RemoteException {
        return this._userObject;
    }

    @Override
    public String toString() {
        if (this._container != null) {
            try {
                return this.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.toString();
    }
}

