/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.publicobject;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TypeDefinition;
import com.sas.services.ServiceException;
import com.sas.services.information.Factory;
import com.sas.services.information.FactoryNotInitializedException;
import com.sas.services.information.Filter;
import com.sas.services.information.NewInstanceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicTypeInfoInterface;
import com.sas.services.information.publicobject.PublicTypeInfoInterface2;
import com.sas.services.information.publicobject.PublicTypeInfoInterface3;
import com.sas.services.information.publicobject.PublicTypeUtility;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.visuals.Resources;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.apache.commons.io.IOUtils;

@SASScope
public class TypeDescriptorImpl
implements Serializable,
TypeDescriptorInterface {
    private static final String TEMPLATE_NOTE_NAME = "Public Object Template";
    private static final long serialVersionUID = 499141046284272626L;
    private String name;
    private String description;
    private String icon;
    private String typeName;
    private String containerType;
    private String containerAssociation;
    private String defaultLocation;
    private String javaClassName;
    private String usageVersion;
    private String template;
    private boolean allowsChildren;
    private transient Object transportHandler;
    private String metadataType;
    private List applicablePermissions;
    private Map<String, String> propertyValues;

    public TypeDescriptorImpl() {
        this.propertyValues = new HashMap<String, String>();
    }

    public TypeDescriptorImpl(TypeDefinition typeDefinition) throws ServiceException, RemoteException {
        this.name = typeDefinition.getName();
        this.description = typeDefinition.getDesc();
        this.icon = typeDefinition.getDefaultIcon();
        this.typeName = typeDefinition.getTypeName();
        this.containerType = typeDefinition.getContainerType();
        this.containerAssociation = typeDefinition.getContainerAssociation();
        this.defaultLocation = typeDefinition.getDefaultLocation();
        this.allowsChildren = typeDefinition.getAllowsChildren() == 1;
        this.javaClassName = typeDefinition.getJavaClass();
        this.usageVersion = String.valueOf(typeDefinition.getUsageVersion());
        this.metadataType = typeDefinition.getMetadataType();
        this.applicablePermissions = this.parsePermissions(typeDefinition.getApplicablePermissions());
        this.loadProperties(typeDefinition);
    }

    public final void update(TypeDefinition def) throws ServiceException, RemoteException {
        def.setName(this.name);
        def.setDesc(this.description);
        def.setDefaultIcon(this.icon);
        def.setTypeName(this.typeName);
        def.setContainerType(this.containerType);
        def.setContainerAssociation(this.containerAssociation);
        def.setDefaultLocation(this.defaultLocation);
        def.setJavaClass(this.javaClassName);
        def.setUsageVersion(Double.parseDouble(this.usageVersion));
        def.setMetadataType(this.metadataType);
        def.setAllowsChildren(this.allowsChildren ? 1 : 0);
        def.setApplicablePermissions(this.makePermissionString(this.applicablePermissions));
        this.setTemplate(def, this.template);
        this.setProperties(def, this.propertyValues);
    }

    @Override
    public final String getClassName() throws ServiceException, RemoteException {
        return this.javaClassName;
    }

    public final void setClassName(String className) throws ServiceException, RemoteException {
        this.javaClassName = className;
    }

    @Override
    public final String getContainerAssociation() throws ServiceException, RemoteException {
        return this.containerAssociation;
    }

    public final void setContainerAssociation(String containerAssociation) {
        this.containerAssociation = containerAssociation;
    }

    @Override
    public final String getContainerType() throws ServiceException, RemoteException {
        return this.containerType;
    }

    public final void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    @Override
    public final String getDefaultLocation() throws ServiceException, RemoteException {
        return this.defaultLocation;
    }

    public final void setDefaultLocation(String defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    @Override
    public final String getDescription() throws ServiceException, RemoteException {
        return this.getDescription(Locale.getDefault());
    }

    @Override
    public final String getDescription(Locale locale) throws ServiceException, RemoteException {
        PublicTypeInfoInterface pii;
        String localString = PublicTypeUtility.getLocalizedDescription(this.typeName, locale);
        if (localString == null && (pii = this.getPublicInfoObject()) != null && (localString = pii.getDescription(this.typeName, locale)) == null) {
            localString = pii.getDescription(this.typeName, Locale.getDefault());
        }
        if (localString == null) {
            localString = this.description;
        }
        return localString;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    @Override
    public final String getIconName() throws ServiceException, RemoteException {
        return this.icon;
    }

    @Override
    public final Icon getIcon() throws ServiceException, RemoteException {
        PublicTypeInfoInterface pii;
        Icon result = null;
        if (this.icon != null && this.icon.trim().length() > 0) {
            try {
                result = Resources.getImageIcon((String)this.icon, (int)16);
            }
            catch (IllegalArgumentException ex) {
                result = null;
            }
        }
        if ((result == null || result.getIconWidth() == -1) && (pii = this.getPublicInfoObject()) != null) {
            try {
                result = pii.getIcon(this.typeName);
            }
            catch (IllegalArgumentException ex) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public final Icon getIcon(int size) throws ServiceException, RemoteException {
        PublicTypeInfoInterface pii;
        Icon result = null;
        if (this.icon != null && this.icon.trim().length() > 0) {
            try {
                result = Resources.getImageIcon((String)this.icon, (int)size);
            }
            catch (IllegalArgumentException ex) {
                result = null;
            }
        }
        if ((result == null || result.getIconWidth() == -1) && (pii = this.getPublicInfoObject()) != null && pii instanceof PublicTypeInfoInterface2) {
            try {
                result = ((PublicTypeInfoInterface2)pii).getIcon(this.typeName, size);
            }
            catch (IllegalArgumentException ex) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public final byte[] getIconData(int size) throws ServiceException, RemoteException {
        PublicTypeInfoInterface pii;
        byte[] result;
        block6: {
            result = null;
            if (this.icon != null && this.icon.trim().length() > 0) {
                try {
                    InputStream stream = Resources.getImageStream((String)this.icon, (int)size);
                    if (stream == null) break block6;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        IOUtils.copy((InputStream)stream, (OutputStream)baos);
                    }
                    catch (IOException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                    result = baos.toByteArray();
                }
                catch (IllegalArgumentException stream) {
                    // empty catch block
                }
            }
        }
        if ((result == null || result.length == 0) && (pii = this.getPublicInfoObject()) != null && pii instanceof PublicTypeInfoInterface3) {
            result = ((PublicTypeInfoInterface3)pii).getIconData(this.typeName, size);
        }
        return result;
    }

    public final void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public final String getLabel() throws ServiceException, RemoteException {
        return this.name;
    }

    public final void setLabel(String label) throws ServiceException, RemoteException {
        this.name = label;
    }

    @Override
    public final String getLabelPlural() throws ServiceException, RemoteException {
        return this.getPropertyValue("LabelPlural");
    }

    public final void setLabelPlural(String labelPlural) {
        this.setPropertyValue("LabelPlural", labelPlural);
    }

    @Override
    public final String getTemplate() throws ServiceException, RemoteException {
        return this.template;
    }

    @Override
    public final String getTemplate(ServerInterface server) throws ServiceException, RemoteException {
        if (this.template != null) {
            return this.template;
        }
        Filter filter = new Filter("TypeName", 0, this.typeName);
        filter.setOMRTemplate("<Templates><TypeDefinition><Notes/></TypeDefinition></Templates>");
        filter.setType("TypeDefinition");
        List tdResult = server.search(filter);
        if (tdResult != null && tdResult.size() > 0) {
            TypeDefinition td = (TypeDefinition)((MetadataInterface)tdResult.get(0)).getRepositoryEntity();
            this.template = this.getTemplate(td);
        }
        return this.template;
    }

    public final void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public final Object getTransportHandler() throws ServiceException, RemoteException {
        if (this.transportHandler == null && this.javaClassName != null) {
            Class[] parameters = new Class[]{TypeDescriptorInterface.class};
            Object[] arguments = new Object[]{this};
            try {
                this.transportHandler = Factory.getInstance().newInstance(this.javaClassName, parameters, arguments);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return this.transportHandler;
    }

    @Override
    public final String getType() throws ServiceException, RemoteException {
        return this.getType(Locale.getDefault());
    }

    @Override
    public final String getType(Locale locale) throws ServiceException, RemoteException {
        PublicTypeInfoInterface pii;
        String localString = PublicTypeUtility.getLocalizedName(this.typeName, locale);
        if (localString == null && (pii = this.getPublicInfoObject()) != null && (localString = pii.getLabel(this.typeName, locale)) == null) {
            localString = pii.getLabel(this.typeName, Locale.getDefault());
        }
        if (localString == null) {
            localString = this.name;
        }
        return localString;
    }

    private PublicTypeInfoInterface getPublicInfoObject() throws ServiceException, RemoteException {
        String localizerClass = this.getPropertyValue("LocalizerClass");
        if (localizerClass == null) {
            return null;
        }
        try {
            return (PublicTypeInfoInterface)Factory.getInstance().newInstance(localizerClass);
        }
        catch (FactoryNotInitializedException ex) {
            try {
                Class[] initParams = new Class[]{};
                Object[] initArgs = new Object[]{};
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> objectClass = loader.loadClass(localizerClass);
                try {
                    Constructor<?> ctor = objectClass.getConstructor(initParams);
                    return (PublicTypeInfoInterface)ctor.newInstance(initArgs);
                }
                catch (InstantiationException e) {
                    throw new NewInstanceException(e, localizerClass);
                }
                catch (IllegalAccessException e) {
                    throw new NewInstanceException(e, localizerClass);
                }
                catch (NoSuchMethodException e) {
                    throw new NewInstanceException(e, localizerClass);
                }
                catch (InvocationTargetException e) {
                    throw new NewInstanceException(e, localizerClass);
                }
                catch (IllegalArgumentException e) {
                    throw new NewInstanceException(e, localizerClass);
                }
                catch (SecurityException e) {
                    throw new NewInstanceException(e, localizerClass);
                }
            }
            catch (ClassNotFoundException ex2) {
                return null;
            }
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    @Override
    public final String getTypeName() throws ServiceException, RemoteException {
        return this.typeName;
    }

    public final void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public final String getUsageVersion() throws ServiceException, RemoteException {
        return this.usageVersion;
    }

    public final void setUsageVersion(String usageVersion) {
        this.usageVersion = usageVersion;
    }

    @Override
    public final boolean allowsChildren() throws ServiceException, RemoteException {
        return this.allowsChildren;
    }

    @Override
    public final void setLogicalTypeClassName(String logicalTypeClass) throws ServiceException, RemoteException {
        this.setPropertyValue("LogicalTypeClass", logicalTypeClass);
    }

    @Override
    public final String getLogicalTypeClassName() throws ServiceException, RemoteException {
        return this.getPropertyValue("LogicalTypeClass");
    }

    @Override
    public final String getMetadataType() throws ServiceException, RemoteException {
        return this.metadataType;
    }

    @Override
    public final String getPropertyValue(String key) throws ServiceException, RemoteException {
        return this.propertyValues.get(key);
    }

    public final void setPropertyValue(String key, String value) {
        if (key == null) {
            return;
        }
        this.propertyValues.put(key, value);
    }

    @Override
    public final List getApplicablePermissions() throws ServiceException, RemoteException {
        return this.applicablePermissions;
    }

    @Override
    public final void setApplicablePermissions(List permissionList) throws ServiceException, RemoteException {
        this.applicablePermissions = permissionList;
    }

    private List parsePermissions(String permString) {
        ArrayList<String> result = null;
        if (permString == null) {
            result = Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(permString, ",");
        result = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            result.add(nextToken.trim());
        }
        return result;
    }

    private String makePermissionString(List permissionList) {
        if (permissionList == null || permissionList.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(64);
        boolean isFirst = true;
        Iterator it = permissionList.iterator();
        while (it.hasNext()) {
            if (!isFirst) {
                result.append(", ");
            }
            result.append((String)it.next());
            isFirst = false;
        }
        return result.toString();
    }

    private String getTemplate(TypeDefinition def) throws ServiceException, RemoteException {
        String templateString = null;
        try {
            AssociationList noteList = def.getNotes();
            for (TextStore ts : noteList) {
                if (!TEMPLATE_NOTE_NAME.equals(ts.getName())) continue;
                templateString = ts.getStoredText();
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return templateString;
    }

    private void setTemplate(TypeDefinition def, String newTemplate) throws ServiceException, RemoteException {
        try {
            AssociationList noteList = def.getNotes();
            for (TextStore ts : noteList) {
                if (!TEMPLATE_NOTE_NAME.equals(ts.getName())) continue;
                ts.setStoredText(newTemplate);
                return;
            }
            MdObjectStore store = (MdObjectStore)def.getObjectStore();
            MdFactory factory = store.getFactory();
            String id = def.getRepositoryID();
            TextStore ts = (TextStore)factory.createComplexMetadataObject(store, TEMPLATE_NOTE_NAME, "TextStore", id);
            ts.setStoredText(newTemplate);
            noteList.add(ts);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void loadProperties(TypeDefinition def) throws ServiceException, RemoteException {
        this.propertyValues = new HashMap<String, String>(5);
        try {
            AssociationList propList = def.getProperties();
            for (Property prop : propList) {
                String name = prop.getPropertyName();
                if (name == null || name.length() <= 0) continue;
                this.propertyValues.put(name, prop.getDefaultValue());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void setProperties(TypeDefinition def, Map<String, String> propertyValues) throws ServiceException, RemoteException {
        try {
            for (String propName : propertyValues.keySet()) {
                String propValue = propertyValues.get(propName);
                Property property = null;
                AssociationList propList = def.getProperties();
                for (Property prop : propList) {
                    if (!prop.getPropertyName().equalsIgnoreCase(propName)) continue;
                    property = prop;
                    break;
                }
                if (property != null) {
                    if (propValue == null) {
                        property.delete();
                        continue;
                    }
                    property.setDefaultValue(propValue);
                    continue;
                }
                if (propValue == null) continue;
                MdObjectStore store = (MdObjectStore)def.getObjectStore();
                MdFactory factory = store.getFactory();
                String id = def.getRepositoryID();
                property = (Property)factory.createComplexMetadataObject(store, propName, "Property", id);
                property.setPropertyName(propName);
                property.setDefaultValue(propValue);
                property.setSQLType(12);
                property.setAssociatedObject((Root)def);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public boolean hasContentBacking() throws ServiceException, RemoteException {
        String content = this.getPropertyValue("HasContentBacking");
        return content == null ? false : "1".equals(content) || "true".equalsIgnoreCase(content);
    }
}

