/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.publicobject;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.publicobject.RB;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@SASScope
public class ResponsibilitiesModel {
    public static final String ROLE_OWNER = "OWNER";
    public static final String ROLE_OWNER_LABEL = RB.getStringResource("ResponsibilitiesModel.Role.Owner.txt");
    public static final String ROLE_ADMINISTRATOR = "ADMINISTRATOR";
    public static final String ROLE_ADMINISTRATOR_LABEL = RB.getStringResource("ResponsibilitiesModel.Role.Administrator.txt");

    public static String[] getRoles() {
        return new String[]{ROLE_OWNER, ROLE_ADMINISTRATOR};
    }

    public static String[] getRoleLabels() {
        return new String[]{ROLE_OWNER_LABEL, ROLE_ADMINISTRATOR_LABEL};
    }

    public static String getLabelForRole(String role) {
        if (ROLE_OWNER.equalsIgnoreCase(role)) {
            return ROLE_OWNER_LABEL;
        }
        if (ROLE_ADMINISTRATOR.equalsIgnoreCase(role)) {
            return ROLE_ADMINISTRATOR_LABEL;
        }
        return role;
    }

    public static String getRoleForLabel(String label) {
        if (ROLE_OWNER_LABEL.equalsIgnoreCase(label)) {
            return ROLE_OWNER;
        }
        if (ROLE_ADMINISTRATOR_LABEL.equalsIgnoreCase(label)) {
            return ROLE_ADMINISTRATOR;
        }
        return label;
    }

    public static List<String> getUserNames(ServerInterface server) throws ServiceException, RemoteException {
        if (server == null) {
            return Collections.emptyList();
        }
        Filter filter = new Filter();
        filter.setOMRTemplate("<Templates><Person Name=\"\"/></Templates>");
        filter.setType("Person");
        filter.setOMRFlags(-2147475196);
        ArrayList<String> names = new ArrayList<String>();
        List results = server.browseSearch(filter);
        for (BrowseMetadataInterface browse : results) {
            names.add(browse.getName());
        }
        Collections.sort(names, new UserNameSorter());
        return names;
    }

    @SASScope
    static class UserNameSorter
    implements Comparator<String> {
        UserNameSorter() {
        }

        @Override
        public int compare(String name1, String name2) {
            if (name1 == name2) {
                return 0;
            }
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareToIgnoreCase(name2);
        }
    }
}

