/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.servers.AbstractConnectionBuilder;
import com.sas.services.information.metadata.servers.ServerBuilder;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class TeradataServerBuilder
extends ServerBuilder<ServerComponentInterface, ServerComponent, TeradataServerBuilder> {
    private static final double USAGE_VERSION = 1000000.0;
    private List<Connection> connections = new ArrayList<Connection>();

    public static TeradataServerBuilder builder() {
        return new TeradataServerBuilder();
    }

    private TeradataServerBuilder() {
        super(ServerComponent.class, "Server.Teradata", 1000000.0, "TERADATA", "TERADATA");
        this.serviceType = "DBMS Server";
        this.prototypeName = "Server.Teradata.Prototype.Name.xmlKey.txt";
        this.vendor("Teradata Corporation");
    }

    public Connection connection() {
        Connection connection = (Connection)new Connection().buildName(this.name, this.connections.size() + 1);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        if (this.connections.isEmpty()) {
            throw new IllegalStateException("No connection is defined.");
        }
        super.validate(user);
        for (Connection builder : this.connections) {
            builder.validate(user);
        }
        Connection.checkForDuplicateNames(this.connections);
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        super.createObject();
        for (Connection connection : this.connections) {
            connection.buildAndConnect(this.user, (DeployedComponent)this.built);
        }
    }

    public final class Connection
    extends AbstractConnectionBuilder<SASClientConnectionInterface, SASClientConnection, Connection> {
        public static final String TMSSERVER = "TMSSERVER";
        public static final String ACCOUNT = "ACCOUNT";

        public Connection server(String server) {
            this.option("SERVER", server);
            TeradataServerBuilder.this.associatedMachine(server);
            return this;
        }

        private Connection() {
            super(SASClientConnection.class, null, 0.0, "TeradataProtocol", "TCP");
            this.prototypeName = "Connection.Teradata.Prototype.Name.xmlKey.txt";
        }

        public TeradataServerBuilder end() {
            return TeradataServerBuilder.this;
        }

        @Override
        public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
            super.validate(user);
            if (!this.options.containsKey("SERVER")) {
                throw new IllegalStateException("SERVER must be specified");
            }
        }
    }
}

