/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.DatabaseCatalogInterface;
import com.sas.services.information.metadata.DeployedDataPackageInterface;
import com.sas.services.information.metadata.ExtensionInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRDatabaseServer;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.servers.DataServerInterface;
import com.sas.services.information.metadata.servers.DatabaseInterface;
import com.sas.services.information.metadata.servers.RB;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class SASInfrastructureDataServerImpl
extends OMRDatabaseServer
implements DataServerInterface {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_LIST_INIT = 1;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    static final String DEFAULT_DESC = "SAS Infrastructure Data Server";
    static final String APPLICATION_PROTOCOL = "PostgresPROTOCOL";
    static final String COMMUNICATION_PROTOCOL = "TCP";
    static final String SERVER_PROPERTY_NAME = "Connection.DBMS.Property.SERVER.Name.xmlKey.txt";
    static final String SERVER_PROPERTY_PROPERTYNAME = "SERVER";
    static final String PORT_PROPERTY_NAME = "Connection.DBMS.Property.NPORT.Name.xmlKey.txt";
    static final String PORT_PROPERTY_PROPERTYNAME = "PORT";

    public SASInfrastructureDataServerImpl() throws RemoteException {
        this(SASInfrastructureDataServerImpl.class);
    }

    public SASInfrastructureDataServerImpl(ServerComponent o) throws RemoteException {
        this(o, SASInfrastructureDataServerImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SASInfrastructureDataServerImpl(ServerComponentImpl o) throws RemoteException {
        this(o, SASInfrastructureDataServerImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SASInfrastructureDataServerImpl(ServerComponentImpl_Stub o) throws RemoteException {
        this(o, SASInfrastructureDataServerImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SASInfrastructureDataServerImpl(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, SASInfrastructureDataServerImpl.class);
    }

    protected SASInfrastructureDataServerImpl(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected SASInfrastructureDataServerImpl(ServerComponent o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected SASInfrastructureDataServerImpl(ServerComponentImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected SASInfrastructureDataServerImpl(ServerComponentImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected SASInfrastructureDataServerImpl(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        super(theClass);
        if (repos == null || name == null || parent != null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            ServerComponent sc = (ServerComponent)omirepository.createMetadata(name, "ServerComponent");
            sc.setPublicType("Server.SASInfrastructureData");
            sc.setUsageVersion(CURRENT_VERSION.encode());
            sc.setClassIdentifier("SASInfrastructureData");
            sc.setMajor(9);
            sc.setMinor(4);
            sc.setVendor("SAS Institute");
            sc.setProductName("SASInfrastructureDataServer");
            sc.setDesc(DEFAULT_DESC);
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = sc;
            this._repositoryFlag = 2;
            this.setRepository(repos);
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    @Override
    public Map<String, String> getServerProperties() throws RemoteException, ServiceException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("DESCRIPTION", this.getDescription());
        List extensions = this.getExtensions();
        for (ExtensionInterface extension : extensions) {
            if (!extension.getName().equalsIgnoreCase("used.by")) continue;
            properties.put("used.by", extension.getValue());
            break;
        }
        this.fetchConnectionProperties((ConnectionInterface)this.getSourceConnections().get(0), properties);
        return properties;
    }

    @Override
    public void updateServerProperties(Map<String, String> properties) throws ServiceException, RemoteException {
        if (properties.containsKey("DESCRIPTION")) {
            this.setDescription(properties.get("DESCRIPTION"));
        }
        if (properties.containsKey("used.by")) {
            ExtensionInterface usedByExtension = null;
            List extensions = this.getExtensions();
            for (ExtensionInterface extension : extensions) {
                if (!extension.getName().equalsIgnoreCase("used.by")) continue;
                usedByExtension = extension;
                break;
            }
            if (usedByExtension != null) {
                usedByExtension.setValue(properties.get("used.by"));
            } else {
                this.addExtension("used.by", properties.get("used.by"), "");
            }
        }
        if (this.getSourceConnections().isEmpty()) {
            this.createConnection(this.getName(), properties);
        } else {
            this.updateConnectionProperties((ConnectionInterface)this.getSourceConnections().get(0), properties);
        }
    }

    @Override
    public Map<String, String> getConnectionProperties(String connectionName) throws ServiceException, RemoteException {
        List connections = this.getSourceConnections();
        for (ConnectionInterface connection : connections) {
            if (!connection.getName().equals(connectionName)) continue;
            HashMap<String, String> properties = new HashMap<String, String>();
            this.fetchConnectionProperties(connection, properties);
            return properties;
        }
        return null;
    }

    @Override
    public ConnectionInterface createConnection(String connectionName, Map<String, String> properties) throws RemoteException, ServiceException {
        OMIRepositoryInterface repository = (OMIRepositoryInterface)this._repository;
        SASClientConnectionInterface connection = (SASClientConnectionInterface)SASInfrastructureDataServerImpl.getInformationService().newMetadata(repository.getDefaultRepositoryId(), connectionName, repository, "SASClientConnection");
        connection.setApplicationProtocol(APPLICATION_PROTOCOL);
        connection.setCommunicationProtocol(COMMUNICATION_PROTOCOL);
        this.addSourceConnection(connection);
        this.updateConnectionProperties(connection, properties);
        return connection;
    }

    @Override
    public void updateConnectionProperties(String connectionName, Map<String, String> properties) throws ServiceException, RemoteException {
        List connections = this.getSourceConnections();
        for (ConnectionInterface connection : connections) {
            if (!connectionName.equals(connection.getName())) continue;
            this.updateConnectionProperties(connection, properties);
            return;
        }
        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SASInfrastructureDataServerImpl.ConnectionNotFound.fmt.txt", (Object)connectionName));
    }

    private void fetchConnectionProperties(ConnectionInterface connection, Map<String, String> properties) throws ServiceException, RemoteException {
        List<MetadataInterface> connectionProperties = connection.getProperties();
        for (MetadataInterface propertyObject : connectionProperties) {
            PropertyInterface property = (PropertyInterface)propertyObject;
            if (SERVER_PROPERTY_PROPERTYNAME.equals(property.getKey())) {
                properties.put(SERVER_PROPERTY_PROPERTYNAME, property.getValue());
            }
            if (!PORT_PROPERTY_PROPERTYNAME.equals(property.getKey())) continue;
            properties.put(PORT_PROPERTY_PROPERTYNAME, property.getValue());
        }
        String authDomain = connection.getDomain();
        if (authDomain != null && authDomain.length() > 0) {
            properties.put("AUTHDOMAIN", authDomain);
        }
        properties.put("AUTHTYPE", connection.getAuthenticationType());
    }

    private void updateConnectionProperties(ConnectionInterface rawConnection, Map<String, String> properties) throws RemoteException, ServiceException {
        String machine;
        OMIRepositoryInterface repository = (OMIRepositoryInterface)this._repository;
        SASClientConnectionInterface connection = (SASClientConnectionInterface)rawConnection;
        if (properties.containsKey(SERVER_PROPERTY_PROPERTYNAME) && !(machine = properties.get(SERVER_PROPERTY_PROPERTYNAME)).equals(this.getMachine())) {
            this.setMachine(properties.get(SERVER_PROPERTY_PROPERTYNAME));
        }
        PropertyInterface serverProperty = null;
        PropertyInterface portProperty = null;
        List objectProperties = connection.getObjectProperties();
        for (PropertyInterface property : objectProperties) {
            if (property.getName().equals(SERVER_PROPERTY_NAME)) {
                serverProperty = property;
                continue;
            }
            if (!property.getName().equals(PORT_PROPERTY_NAME)) continue;
            portProperty = property;
        }
        if (properties.containsKey(SERVER_PROPERTY_PROPERTYNAME)) {
            String server = properties.get(SERVER_PROPERTY_PROPERTYNAME);
            if (serverProperty == null) {
                serverProperty = (PropertyInterface)SASInfrastructureDataServerImpl.getInformationService().newMetadata(repository.getDefaultRepositoryId(), SERVER_PROPERTY_NAME, repository, "Property");
                serverProperty.setDelimiter("=");
                ((Property)serverProperty.getRepositoryEntity()).setPropertyName(SERVER_PROPERTY_PROPERTYNAME);
                serverProperty.setSQLType(12);
                serverProperty.setValue(server);
                connection.addObjectProperty(serverProperty);
            } else if (!server.equals(serverProperty.getValue())) {
                serverProperty.setValue(server);
            }
        }
        if (properties.containsKey(PORT_PROPERTY_PROPERTYNAME)) {
            String portString = properties.get(PORT_PROPERTY_PROPERTYNAME);
            int port = Integer.parseInt(portString);
            if (port != connection.getPort()) {
                connection.setPort(port);
            }
            if (portProperty == null) {
                portProperty = (PropertyInterface)SASInfrastructureDataServerImpl.getInformationService().newMetadata(repository.getDefaultRepositoryId(), PORT_PROPERTY_NAME, repository, "Property");
                portProperty.setDelimiter("=");
                ((Property)portProperty.getRepositoryEntity()).setPropertyName(PORT_PROPERTY_PROPERTYNAME);
                portProperty.setSQLType(12);
                portProperty.setValue(Integer.toString(port));
                connection.addObjectProperty(portProperty);
            } else if (!portString.equals(portProperty.getValue())) {
                portProperty.setValue(portString);
            }
        } else if (portProperty == null) {
            connection.setPort(5432);
            portProperty = (PropertyInterface)SASInfrastructureDataServerImpl.getInformationService().newMetadata(repository.getDefaultRepositoryId(), PORT_PROPERTY_NAME, repository, "Property");
            portProperty.setDelimiter("=");
            ((Property)portProperty.getRepositoryEntity()).setPropertyName(PORT_PROPERTY_PROPERTYNAME);
            portProperty.setSQLType(12);
            portProperty.setValue(Integer.toString(5432));
            connection.addObjectProperty(portProperty);
        }
        if (properties.containsKey("AUTHTYPE")) {
            String authType = properties.get("AUTHTYPE");
            if (!authType.equals(connection.getAuthenticationType())) {
                connection.setAuthenticationType(authType);
            }
        } else if (connection.getAuthenticationType().length() == 0) {
            connection.setAuthenticationType("user/password");
        }
        try {
            AuthenticationDomain domain = ((SASClientConnection)connection.getRepositoryEntity()).getDomain();
            String domainName = properties.get("AUTHDOMAIN");
            if (domain == null || domainName != null) {
                if (domainName == null || domainName.equals("use-default")) {
                    domainName = this.getName().replaceAll("\\s+", "") + "Admin";
                }
                if (domain == null || !domainName.equals(connection.getDomain())) {
                    if (domain != null && domain.getConnections().size() == 1) {
                        domain.setName(domainName);
                    } else {
                        connection.setDomain(domainName);
                        domain = ((SASClientConnection)connection.getRepositoryEntity()).getDomain();
                    }
                }
            }
            if (properties.containsKey("USERNAME") && properties.containsKey("PASSWORD")) {
                LoginInterface login = null;
                IdentityInterface currentIdentity = this._repository.getIdentity();
                List identityLogins = currentIdentity.getLogins();
                for (LoginInterface identityLogin : identityLogins) {
                    if (!domainName.equalsIgnoreCase(identityLogin.getDomain())) continue;
                    login = identityLogin;
                    break;
                }
                if (login == null) {
                    OMIRepositoryInterface loginRepository = (OMIRepositoryInterface)currentIdentity.getRepository();
                    login = (LoginInterface)SASInfrastructureDataServerImpl.getInformationService().newMetadata(loginRepository.getDefaultRepositoryId(), "Login." + currentIdentity.getName(), loginRepository, "Login");
                    ((Login)login.getRepositoryEntity()).setDomain(domain);
                    currentIdentity.addLogin(login);
                }
                login.setUserId(properties.get("USERNAME"));
                login.setPassword(properties.get("PASSWORD"));
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public DatabaseInterface createDatabase(String databaseName, Map<String, String> properties) throws RemoteException, ServiceException {
        OMIRepositoryInterface repository = (OMIRepositoryInterface)this._repository;
        DatabaseInterface database = (DatabaseInterface)SASInfrastructureDataServerImpl.getInformationService().newMetadata(repository.getDefaultRepositoryId(), databaseName, repository, "DatabaseCatalog");
        this.addDataPackage((DatabaseCatalogInterface)((Object)database));
        database.updateDatabaseProperties(properties);
        return database;
    }

    @Override
    public DatabaseInterface getDatabase(String databaseName) throws RemoteException, ServiceException {
        List dataPackages = this.getDataPackages();
        for (DeployedDataPackageInterface dataPkg : dataPackages) {
            if (!dataPkg.getType().equals("DatabaseCatalog") || !dataPkg.getName().equals(databaseName)) continue;
            return (DatabaseInterface)((Object)dataPkg);
        }
        return null;
    }

    @Override
    public List<DatabaseInterface> getDatabases() throws RemoteException, ServiceException {
        ArrayList<DatabaseInterface> result = null;
        List dataPackages = this.getDataPackages();
        for (DeployedDataPackageInterface dataPkg : dataPackages) {
            if (!dataPkg.getType().equals("DatabaseCatalog")) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.add((DatabaseInterface)((Object)dataPkg));
        }
        if (result == null) {
            result = new ArrayList<DatabaseInterface>(1);
        }
        return result;
    }
}

