/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.servers.AbstractConnectionBuilder;
import com.sas.services.information.metadata.servers.ServerBuilder;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class PostgresServerBuilder
extends ServerBuilder<ServerComponentInterface, ServerComponent, PostgresServerBuilder> {
    private static final double USAGE_VERSION = 1000000.0;
    private List<Connection> connections = new ArrayList<Connection>();

    public static PostgresServerBuilder builder() {
        return new PostgresServerBuilder();
    }

    private PostgresServerBuilder() {
        super(ServerComponent.class, "Server.Postgres", 1000000.0, "Postgres", "Postgres");
        this.serviceType = "DBMS Server";
        this.prototypeName = "Server.Postgres.Prototype.Name.xmlKey.txt";
        this.vendor("Postgres Inc.");
    }

    public Connection connection() {
        Connection connection = (Connection)new Connection().buildName(this.name, this.connections.size() + 1);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        if (this.connections.isEmpty()) {
            throw new IllegalStateException("No connection is defined.");
        }
        super.validate(user);
        for (Connection connection : this.connections) {
            connection.validate(user);
        }
        Connection.checkForDuplicateNames(this.connections);
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        try {
            super.createObject();
            for (Connection connection : this.connections) {
                connection.buildAndConnect(this.user, (DeployedComponent)this.built);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException();
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public final class Connection
    extends AbstractConnectionBuilder<SASClientConnectionInterface, SASClientConnection, Connection> {
        private Connection() {
            super(SASClientConnection.class, null, 0.0, "PostgresProtocol", "TCP");
            this.prototypeName = "Connection.Postgres.Prototype.Name.xmlKey.txt";
        }

        public Connection port(int port) {
            this.option("PORT", Integer.toString(port));
            return this;
        }

        public Connection server(String server) {
            this.option("SERVER", server);
            PostgresServerBuilder.this.associatedMachine(server);
            return this;
        }

        public PostgresServerBuilder end() {
            return PostgresServerBuilder.this;
        }

        @Override
        public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
            super.validate(user);
            boolean serverSpecified = this.options.containsKey("SERVER");
            boolean dsnSpecified = this.options.containsKey("DSN");
            if (!serverSpecified && !dsnSpecified) {
                throw new IllegalStateException("SERVER or DSN option must be specified");
            }
            if (serverSpecified && dsnSpecified) {
                throw new IllegalStateException("SERVER and DSN options cannot be specified together");
            }
        }

        @Override
        protected void createObject() throws RemoteException, MdException, ServiceException {
            super.createObject();
            if (this.options.containsKey("SERVER")) {
                ((SASClientConnection)this.built).setRemoteAddress((String)this.options.get("SERVER"));
            }
            if (this.options.containsKey("PORT")) {
                try {
                    int port = Integer.parseInt((String)this.options.get("PORT"));
                    ((SASClientConnection)this.built).setPort(port);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

