/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.lookup.io;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.SoftwareComponentImpl;
import com.sas.metadata.remote.impl.TextStoreImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRTextStore;
import com.sas.services.information.metadata.TextStoreInterface;
import com.sas.services.information.metadata.lookup.io.IOInterface;
import com.sas.services.information.metadata.lookup.security.crypto.Symmetric;
import com.sas.services.information.metadata.lookup.utils.XML;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.TransformerFactoryFactory;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

@Deprecated
public class TextStoreIO
implements IOInterface {
    public static final String NAME = "SAS 9.1.3 to 9.2 Folder Remapping";
    static final String template1 = "<XMLSELECT Search=\"*[@Name='SAS 9.1.3 to 9.2 Folder Remapping'][Objects/SoftwareComponent[@Name='BIP Service']]\" />";
    static final String template2 = "<XMLSELECT Search=\"*[@Name='BIP Service']\" />";

    TextStoreIO() {
    }

    @Override
    public Document extractDocument(UserContextInterface user) {
        Document rval = null;
        try {
            TextStoreInterface text = this.getMetadata(user.getAuthRepository(), false);
            if (null == text) {
                rval = XML.newDocument("mappings");
            } else {
                OMRTextStore store = (OMRTextStore)user.getAuthRepository().fetch(text.getEntityKey(), true);
                Symmetric symmetric = new Symmetric();
                byte[] cipherText = store.getText().getBytes("UTF8");
                byte[] plainText = symmetric.decrypt(cipherText);
                String xml = new String(plainText, "UTF8");
                rval = XML.createDocument(xml);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        if (null == rval) {
            rval = XML.newDocument("mappings");
        }
        return rval;
    }

    @Override
    public void persistDocument(UserContextInterface user, Document document) {
        try {
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            Transformer xformer = TransformerFactoryFactory.newFactory().newTransformer();
            xformer.transform(source, result);
            Symmetric symmetric = new Symmetric();
            byte[] cipherText = symmetric.encrypt(stream.toByteArray());
            TextStoreInterface text = this.getMetadata(user.getAuthRepository(), true);
            text.setText(new String(cipherText, "UTF8"));
            text.setTextType("");
            text.setTextRole("FolderRemapping");
            text.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TextStoreInterface getMetadata(RepositoryInterface repository, boolean bCreate) throws ServiceException, RemoteException, MdException {
        TextStoreInterface rval = null;
        int queryFlags = -2080372348;
        Filter filter = new Filter();
        filter.setOMRFlags(-2080372348);
        filter.setOMRTemplate(template1);
        List list = repository.search(filter);
        if (null == list || list.isEmpty()) {
            if (bCreate) {
                filter.setOMRTemplate(template2);
                list = repository.search(filter);
                MetadataInterface metadata = (MetadataInterface)list.get(0);
                SoftwareComponentImpl softwareComponent = (SoftwareComponentImpl)metadata.getRepositoryEntity();
                String reposFQID = repository.getBase();
                String reposID = reposFQID.substring(reposFQID.indexOf(46) + 1);
                metadata = repository.newMetadata(reposID, NAME, "TextStore");
                TextStoreImpl textStore = (TextStoreImpl)metadata.getRepositoryEntity();
                AssociationList objects = textStore.getObjects();
                objects.add((Object)softwareComponent);
                AssociationList notes = softwareComponent.getNotes();
                notes.add((Object)textStore);
                rval = (TextStoreInterface)metadata;
            }
        } else {
            rval = (TextStoreInterface)list.get(0);
        }
        return rval;
    }

    void reset(UserContextInterface user) {
        try {
            TextStoreInterface mdata = this.getMetadata(user.getAuthRepository(), false);
            if (null == mdata) {
                return;
            }
            mdata.delete();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
    }
}

