/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.libraries.LibraryBuilder;

public final class TeradataLibraryBuilder
extends LibraryBuilder<TeradataLibraryBuilder> {
    private static final String ENGINE = "TERADATA";

    public static TeradataLibraryBuilder builder() {
        return new TeradataLibraryBuilder();
    }

    private TeradataLibraryBuilder() {
        this.engine = ENGINE;
        this.isDBMSLibrary = true;
        this.dataServerPublicType = "Server.Teradata";
        this.prototypeName = "Library.Teradata.Prototype.Name.xmlKey.txt";
    }

    public TeradataLibraryBuilder dataServer(String serverName) {
        this.dataServerName = serverName;
        return this;
    }

    public TeradataLibraryBuilder dataServer(ServerComponentInterface server) {
        this.dataServer = server;
        return this;
    }

    public TeradataLibraryBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public TeradataLibraryBuilder connection(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    public TeradataLibraryBuilder connection(SASClientConnectionInterface connection) {
        this.connection = connection;
        return this;
    }

    public TeradataLibraryBuilder defaultLogin(String defaultLoginUserId) {
        this.defaultLoginUserId = defaultLoginUserId;
        return this;
    }

    public TeradataLibraryBuilder defaultLogin(LoginInterface defaultLogin) {
        this.defaultLogin = defaultLogin;
        return this;
    }
}

