/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.libraries.LibraryBuilder;

public final class PostgresLibraryBuilder
extends LibraryBuilder<PostgresLibraryBuilder> {
    private static final String ENGINE = "POSTGRES";

    public static PostgresLibraryBuilder builder() {
        return new PostgresLibraryBuilder();
    }

    private PostgresLibraryBuilder() {
        this.engine = ENGINE;
        this.isDBMSLibrary = true;
        this.dataServerPublicType = "Server.Postgres";
        this.prototypeName = "Library.Postgres.Prototype.Name.xmlKey.txt";
    }

    public PostgresLibraryBuilder dataServer(String serverName) {
        this.dataServerName = serverName;
        return this;
    }

    public PostgresLibraryBuilder dataServer(ServerComponentInterface server) {
        this.dataServer = server;
        return this;
    }

    public PostgresLibraryBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public PostgresLibraryBuilder connection(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    public PostgresLibraryBuilder connection(SASClientConnectionInterface connection) {
        this.connection = connection;
        return this;
    }

    public PostgresLibraryBuilder defaultLogin(String defaultLoginUserId) {
        this.defaultLoginUserId = defaultLoginUserId;
        return this;
    }

    public PostgresLibraryBuilder defaultLogin(LoginInterface defaultLogin) {
        this.defaultLogin = defaultLogin;
        return this;
    }
}

