/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.libraries.LibraryBuilder;
import com.sas.services.information.metadata.libraries.SASLibraryUtil;
import com.sas.services.information.metadata.servers.LASRServerInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;

public final class LASRLibraryBuilder
extends LibraryBuilder<LASRLibraryBuilder> {
    static final String ENGINE = "SASIOLA";
    static final String DATA_PROVIDER_LIBRARY_NAME = "DataProviderLibraryTransformation";
    static final String DATA_PROVIDER_LIBRARY_ROLE = "DataProviderLibrary";
    private String dataProviderLibraryPath = null;
    private SASLibraryInterface dataProviderLibrary = null;
    public static final String TAG = "TAG";

    public static LASRLibraryBuilder builder() {
        return new LASRLibraryBuilder();
    }

    private LASRLibraryBuilder() {
        this.engine = ENGINE;
        this.isDBMSLibrary = true;
        this.schema = "";
        this.prototypeName = "Library.LASR.Prototype.Name.xmlKey.txt";
    }

    public LASRLibraryBuilder dataServer(String serverName) {
        this.dataServerName = serverName;
        return this;
    }

    public LASRLibraryBuilder dataServer(LASRServerInterface server) {
        this.dataServer = server;
        return this;
    }

    @Override
    public LASRLibraryBuilder dataProviderLibrary(SASLibraryInterface library) {
        this.dataProviderLibrary = library;
        return this;
    }

    @Override
    public LASRLibraryBuilder dataProviderLibrary(String libraryPath) {
        this.dataProviderLibraryPath = libraryPath;
        return this;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        super.validate(user);
        if (this.dataProviderLibrary == null && this.dataProviderLibraryPath != null) {
            this.dataProviderLibrary = SASLibraryUtil.getLibrary(user, this.dataProviderLibraryPath);
            if (this.dataProviderLibrary == null) {
                throw new ServiceException("Library " + this.dataProviderLibraryPath + " does not exist");
            }
        }
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        super.createObject();
        if (this.dataProviderLibrary != null) {
            Transformation transform = this.createMetadata(DATA_PROVIDER_LIBRARY_NAME, Transformation.class);
            transform.setTransformRole(DATA_PROVIDER_LIBRARY_ROLE);
            transform.getTransformationSources().add(this.dataProviderLibrary.getRepositoryEntity());
            transform.getTransformationTargets().add((Object)this.built);
        }
    }
}

