/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.AttachmentInterface;
import com.sas.services.information.metadata.Comment;
import com.sas.services.information.metadata.CommentInterface;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFolder;
import com.sas.services.information.metadata.dav.DAVItemInterface;
import com.sas.services.information.metadata.dav.RB;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVRemarks
extends DAVFolder {
    private static String P_OWNER = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}creator";
    private static String P_TOPIC = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}topic";
    private static String P_STARTED = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}started";
    private static String P_REFERRALS = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}referrals";
    private static String P_THREAD_ID = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}threadid";
    private static String P_COMMENTREF = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}commentref";
    private static String P_NAME = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}name";
    private static String P_DESCRIPTION = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}description";
    private static String P_MIMETYPE = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}mimetype";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS'Z'");
    private static Calendar GMTCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static Logger logger = LogManager.getLogger(DAVRemarks.class);
    private transient DocumentBuilder builder = null;
    private transient Document remarksDoc;

    public DAVRemarks(RepositoryInterface repos, String reposId) throws RemoteException {
        super(repos, reposId);
        this._objectClass = "remarks";
        this.builder = this.getDocumentBuilder();
    }

    public DAVRemarks(RepositoryData entity) throws RemoteException {
        super(entity);
        this._objectClass = "remarks";
        this.builder = this.getDocumentBuilder();
    }

    public void addComment(CommentInterface comment) throws RemoteException {
        if (comment == null) {
            return;
        }
        if (comment.hasAttachments()) {
            List attachments = comment.getAttachments();
            for (int i = 0; i < attachments.size(); ++i) {
                this.addAttachment(i, comment.getTimestamp(), (AttachmentInterface)attachments.get(i));
            }
        }
        if (this.remarksDoc == null) {
            this.getComments();
            if (this.remarksDoc == null) {
                this.remarksDoc = this.builder.newDocument();
                this.remarksDoc.appendChild(this.remarksDoc.createElement("Comments"));
            }
        }
        Element newComment = this.remarksDoc.createElement("Comment");
        newComment.setAttribute("timeStamp", sdf.format(new Date(comment.getTimestamp())));
        newComment.setAttribute("author", comment.getAuthor());
        Text commText = this.remarksDoc.createTextNode(comment.getText());
        newComment.appendChild(commText);
        DAVItemInterface commentNode = (DAVItemInterface)this.getItem("comments");
        if (commentNode == null) {
            try {
                commentNode = this.createItem("comments");
            }
            catch (ServiceException e) {
                logger.error((Object)e);
            }
        }
        this.remarksDoc.getDocumentElement().appendChild(newComment);
        try {
            commentNode.setContents(XMLUtil.convertNodeToString(this.remarksDoc).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public CommentInterface[] getComments() throws RemoteException {
        Logger _logger = LogManager.getLogger((String)"com.sas.services.information.metadata.dav.DAVRemarks");
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        long timestamp = 0L;
        String author = null;
        String text = null;
        DAVItemInterface commentNode = (DAVItemInterface)this.getItem("comments");
        if (commentNode == null) {
            return null;
        }
        try {
            this.remarksDoc = this.builder.parse(new ByteArrayInputStream(commentNode.getContentsAsBytes()));
        }
        catch (Exception e) {
            if (_logger != null) {
                _logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRemarks.badparse.msg.fmt", (Object)commentNode.getUrl()));
            }
            e.printStackTrace();
        }
        if (this.remarksDoc == null) {
            if (_logger != null) {
                _logger.warn(RB.getStringResource("DAVRemarks.nullcomments.msg.txt"));
            }
            return null;
        }
        NodeList nl = this.remarksDoc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element commElem = (Element)nl.item(i);
            author = commElem.getAttribute("author");
            try {
                timestamp = sdf.parse(commElem.getAttribute("timeStamp")).getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Node textNode = commElem.getFirstChild();
            text = textNode != null && textNode instanceof Text ? textNode.getNodeValue() : "";
            Comment c = new Comment();
            c.setTimeStamp(timestamp);
            c.setAuthor(author);
            c.setText(text);
            commentList.add(c);
            Map items = this.getItems();
            for (DAVEntityInterface de : items.values()) {
                if (!(de instanceof DAVItemInterface)) continue;
                DAVItemInterface di = (DAVItemInterface)de;
                String ref = de.getAttribute(P_COMMENTREF);
                if (ref == null || !ref.equals(Long.toString(timestamp))) continue;
                String name = de.getAttribute(P_NAME);
                String desc = de.getAttribute(P_DESCRIPTION);
                String mime = de.getAttribute(P_MIMETYPE);
                c.addAttachment(name, desc, mime, di.getContents());
            }
        }
        return commentList.toArray(new CommentInterface[0]);
    }

    private void addAttachment(int attNo, long timestamp, AttachmentInterface attachment) throws RemoteException {
        String _name = Long.toString(timestamp) + '_' + attNo;
        DAVItemInterface attachNode = (DAVItemInterface)this.getItem(_name);
        if (attachNode == null) {
            try {
                attachNode = this.createItem(_name);
                attachNode.setContents(attachment.getContent());
                attachNode.setAttribute(P_COMMENTREF, Long.toString(timestamp));
                attachNode.setAttribute(P_NAME, attachment.getName());
                attachNode.setAttribute(P_DESCRIPTION, attachment.getDescription());
                attachNode.setAttribute(P_MIMETYPE, attachment.getMimeType());
            }
            catch (ServiceException e) {
                logger.error((Object)e);
            }
        }
    }

    public void setOwner(String owner) {
        this.setAttribute(P_OWNER, owner);
    }

    public String getOwner() {
        return this.getAttribute(P_OWNER);
    }

    public void setTopic(String topic) {
        this.setAttribute(P_TOPIC, topic);
    }

    public String getTopic() {
        return this.getAttribute(P_TOPIC);
    }

    public void setStarted(long started) {
        if (this.getAttribute(P_STARTED) == null) {
            this.setAttribute(P_STARTED, sdf.format(new Date(started)));
        }
    }

    public long getStarted() {
        String startedStr = this.getAttribute(P_STARTED);
        Date date = null;
        try {
            date = sdf.parse(startedStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date.getTime();
    }

    public void setReferrals(Set referralSet) {
        StringBuffer referrals = new StringBuffer();
        Iterator items = referralSet.iterator();
        while (items.hasNext()) {
            if (referrals.length() > 0) {
                referrals.append("|");
            }
            referrals.append((String)items.next());
        }
        this.setAttribute(P_REFERRALS, referrals.toString());
    }

    public Set getReferrals() {
        String referrals = this.getAttribute(P_REFERRALS);
        HashSet<String> referralSet = new HashSet<String>();
        if (referrals != null) {
            StringTokenizer st = new StringTokenizer(referrals, "|");
            while (st.hasMoreTokens()) {
                referralSet.add(st.nextToken());
            }
        }
        return referralSet;
    }

    public void setThreadId(String threadId) {
        this.setAttribute(P_THREAD_ID, threadId);
    }

    public String getThreadId() {
        return this.getAttribute(P_THREAD_ID);
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilderFactory factory = TransformerFactoryFactory.newDocumentBuilderFactory();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return this.builder;
    }

    static {
        sdf.setCalendar(GMTCalendar);
    }
}

