/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.dav.DAVEntity;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFactory;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.information.metadata.dav.DAVItemInterface;
import com.sas.services.webdav.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVFolder
extends DAVEntity
implements DAVFolderInterface {
    private static final int UNFETCHED = 0;
    private static final int STORE = 2;
    private int structureStatus = 0;
    private Map _items = new HashMap();

    public DAVFolder(RepositoryInterface repos, String reposId) {
        super(repos, reposId);
        this._objectClass = "folder";
    }

    public DAVFolder(String url, Map properties) {
        super(url, properties);
    }

    public DAVFolder(RepositoryData entity) {
        super(entity);
    }

    @Override
    public DAVEntityInterface getItem(String name) {
        try {
            if (name.indexOf("/") < 0) {
                if (!this.hasBeenFetched) {
                    this.refresh();
                }
                if (this.structureStatus == 0) {
                    this.getItems();
                }
                return (DAVEntityInterface)this._items.get(name);
            }
            String reposIdwoType = this._reposId.substring(0, this._reposId.lastIndexOf("/"));
            String _id = null;
            try {
                URI _uri = new URI(null, null, Utils.addSegment((String)reposIdwoType, (String)name), null);
                URI _newuri = _uri.normalize();
                _id = _newuri.getPath();
            }
            catch (URISyntaxException _uri) {
                // empty catch block
            }
            MetadataInterface mi = this._repos.fetch(Utils.addSegment(_id, (String)"entity"));
            if (mi != null) {
                DAVEntityInterface de = (DAVEntityInterface)mi.getRepositoryEntity();
                return de;
            }
            return null;
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void addEntity(DAVEntityInterface anItem) throws ServiceException, RemoteException {
        if (this.structureStatus == 0) {
            this.getItems();
        }
        this._items.put(Utils.getRelativePath((String)anItem.getUrl()), anItem);
    }

    @Override
    public DAVItemInterface createItem(String name, String contentClass) throws ServiceException, RemoteException {
        if (this.structureStatus == 0) {
            this.getItems();
        }
        try {
            String _url = this.getUrl();
            if (!_url.endsWith("/")) {
                _url = _url + '/';
            }
            String reposId = ((DAVRepositoryInterface)this._repos).getReposIdwoTypeFromUrl(_url + name) + "/item";
            DAVItemInterface f = (DAVItemInterface)DAVFactory.newDAVEntity(contentClass, reposId, this._repos);
            f.setContentClass(contentClass);
            this._repos.addEntity(new Metadata(f));
            if (this._items == null) {
                this._items = new HashMap();
            }
            this._items.put(name, f);
            return f;
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DAVItemInterface createItem(String name) throws ServiceException, RemoteException {
        return this.createItem(name, "item");
    }

    @Override
    public DAVFolderInterface createFolder(String name) throws ServiceException, RemoteException {
        return this.createFolder(name, "folder");
    }

    @Override
    public DAVFolderInterface createFolder(String name, String contentClass) throws ServiceException, RemoteException {
        String _url;
        if (this.structureStatus == 0) {
            this.getItems();
        }
        if (!(_url = this.getUrl()).endsWith("/")) {
            _url = _url + '/';
        }
        String reposId = ((DAVRepositoryInterface)this._repos).getReposIdwoTypeFromUrl(_url + name) + "/folder";
        DAVFolderInterface f = (DAVFolderInterface)DAVFactory.newDAVEntity(contentClass, reposId, this._repos);
        f.setContentClass(contentClass);
        this._repos.addEntity(new Folder(f));
        this._items.put(name, f);
        return f;
    }

    @Override
    public void refresh() {
        if (this._repos == null) {
            return;
        }
        try {
            Folder mi = new Folder(this);
            this._repos.refreshEntity(mi);
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.hasBeenFetched = true;
    }

    @Override
    public void refresh(DAVFolderInterface entity) {
        super.refresh(entity);
        this._items = entity.getItems();
    }

    @Override
    public Collection getEntities() {
        return this.getItems().values();
    }

    @Override
    public Map getItems() {
        if (this.structureStatus == 0) {
            try {
                List ITEMS = ((DAVRepositoryInterface)this._repos).getItems(this);
                for (DAVEntityInterface anItem : ITEMS) {
                    this._items.put(Utils.getRelativePath((String)anItem.getUrl()), anItem);
                }
                this.structureStatus = 2;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return this._items;
    }

    protected void setItems(Map items) {
        this._items = items;
    }
}

