/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dataexplorer;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.dataexplorer.BookmarkEntryInterface;
import com.sas.services.information.metadata.dataexplorer.DataExplorationEntryInterface;
import com.sas.services.information.metadata.dataexplorer.OMRUtils;
import com.sas.services.util.UpgradeInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRBookmarkEntry
extends Metadata
implements BookmarkEntryInterface,
UpgradeInterface {
    public static final String RB_KEY = "OMRBookmarkEntry.";
    public static final String RB_KEY2 = "Transformation.";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private Boolean _isDefault = null;
    private transient MetadataInterface associatedDataExploration = null;
    private boolean inUpgrade = false;

    public OMRBookmarkEntry() throws RemoteException {
        super(OMRBookmarkEntry.class);
    }

    public OMRBookmarkEntry(Transformation o) throws RemoteException {
        super(o, OMRBookmarkEntry.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        String roleType = o.getTransformRole();
        if (!roleType.equals(this.getType())) {
            throw new IllegalArgumentException(Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource(RB_KEY2, "unableToCreate.fmt.txt"), (Object)this.getType(), (Object)o.toString()));
        }
    }

    public OMRBookmarkEntry(TransformationImpl o) throws RemoteException {
        super(o, OMRBookmarkEntry.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        String roleType = o.getTransformRole();
        if (!roleType.equals(this.getType())) {
            throw new IllegalArgumentException(Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource(RB_KEY2, "unableToCreate.fmt.txt"), (Object)this.getType(), (Object)o.toString()));
        }
    }

    public OMRBookmarkEntry(TransformationImpl_Stub o) throws RemoteException {
        super(o, OMRBookmarkEntry.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        String roleType = o.getTransformRole();
        if (!roleType.equals(this.getType())) {
            throw new IllegalArgumentException(Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource(RB_KEY2, "unableToCreate.fmt.txt"), (Object)this.getType(), (Object)o.toString()));
        }
    }

    public OMRBookmarkEntry(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRBookmarkEntry.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            Transformation transform = (Transformation)omirepository.createMetadata(name, "Transformation");
            transform.setPublicType("DataExplorationBookmark");
            transform.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            transform.setTransformRole(this.getType());
            this._repositoryObject = transform;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), OMRBookmarkEntry.class.getName(), (Throwable)((Object)ex));
                }
            }
        }
        catch (ServiceException ex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), OMRBookmarkEntry.class.getName(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "DataExplorationBookmark";
    }

    @Override
    public void setDataExplorationURL(PathUrl url) throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property URLprop = OMRUtils.getPropertyByName((Transformation)this.getRepositoryEntity(), "DataExplorationURL", true, this.getRepository());
        if (null == url) {
            OMRUtils.removeProperty((Transformation)this.getRepositoryEntity(), URLprop);
        } else {
            URLprop.setDefaultValue(url.getAbsolutePath());
        }
        this.associatedDataExploration = null;
    }

    @Override
    public void setDataExplorationId(String deId) throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        MetadataInterface mdata = OMRUtils.getMetaDataObjectFromId(deId, this.getRepository());
        PathUrl url = mdata.getPathUrl();
        this.setDataExplorationURL(url);
    }

    public DataExplorationEntryInterface getAssociatedDataExploration() throws ServiceException, RemoteException, MdException {
        DataExplorationEntryInterface result = null;
        if (null == this.associatedDataExploration) {
            this.associatedDataExploration = this.getRepository().getObjectByPath(this.getDataExplorationURL());
        }
        try {
            result = (DataExplorationEntryInterface)this.associatedDataExploration;
        }
        catch (Exception e) {
            this.logMessage(Level.WARN, "Unable to find associated data exploration for bookmark " + this + "\n" + e.getLocalizedMessage());
            result = null;
        }
        return result;
    }

    @Override
    public FolderInterface getParent() throws ServiceException, RemoteException {
        MetadataInterface value = null;
        try {
            value = this.getAssociatedDataExploration();
            if (null != value) {
                value = value.getParent();
            }
            if (null == value) {
                value = super.getParent();
            }
        }
        catch (MdException mde) {
            throw new ServiceException(mde);
        }
        return (FolderInterface)value;
    }

    @Override
    public PathUrl getDataExplorationURL() throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (this.shouldConvert()) {
            this.upgradeFromPreviousVersion();
        }
        PathUrl result = null;
        Property URLprop = OMRUtils.getPropertyByName((Transformation)this.getRepositoryEntity(), "DataExplorationURL");
        if (null != URLprop) {
            String url = URLprop.getDefaultValue();
            result = PathUrl.newPathUrlFromAbsolutePath(this.getRepository().getServer(), url);
        }
        return result;
    }

    @Override
    public String getDataExplorationId() throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PathUrl url = this.getDataExplorationURL();
        if (null == url) {
            return null;
        }
        MetadataInterface mdata = this.getRepository().getObjectByPath(url);
        if (null == mdata) {
            return null;
        }
        return mdata.getReposId();
    }

    @Override
    public String getDataModelState() throws MdException, RemoteException, ServiceException {
        Transformation trans;
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (this.shouldConvert()) {
            this.upgradeFromPreviousVersion();
        }
        if (!this.inUpgrade) {
            OMRUtils.checkPermissions(this.getAssociatedDataExploration(), "ReadMetadata", this.getParent());
        }
        if (null == (trans = (Transformation)this.getRepositoryEntity())) {
            return null;
        }
        Text text = trans.getSourceCode();
        if (null == text) {
            return null;
        }
        if (text instanceof TextStore) {
            TextStore textStore = (TextStore)text;
            String storedText = textStore.getStoredText();
            if (null == storedText) {
                return null;
            }
            if (storedText.startsWith("00000001")) {
                storedText = storedText.substring("00000001".length());
            }
            return storedText;
        }
        return null;
    }

    @Override
    public boolean isDefault() throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore textstore = this.getTextStore();
        this._isDefault = null == textstore ? Boolean.FALSE : ("default".equals(textstore.getDesc()) ? Boolean.TRUE : Boolean.FALSE);
        return this._isDefault;
    }

    @Override
    public void setDataModelState(String model) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Transformation trans = (Transformation)this.getRepositoryEntity();
        TextStore textStore = null;
        if (null == trans) {
            return;
        }
        Text text = trans.getSourceCode();
        if (null == text) {
            String reposId = this.getReposId();
            reposId = OMRUtils.getRepositoryIdOf(reposId);
            MetadataInterface mdata = this.getRepository().newMetadata(reposId, this.getName(), "TextStore");
            textStore = (TextStore)mdata.getRepositoryEntity();
            textStore.setTextRole("DataExplorationBookmarkTextStore");
            textStore.setTextType("XML");
            trans.setSourceCode((Text)textStore);
        } else if (text instanceof TextStore) {
            textStore = (TextStore)text;
        }
        if (null != textStore) {
            textStore.setStoredText(model);
        }
    }

    @Override
    public TextStore getTextStore() throws RemoteException, MdException, ServiceException {
        Transformation trans;
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (this.shouldConvert()) {
            this.upgradeFromPreviousVersion();
        }
        if (!this.inUpgrade) {
            OMRUtils.checkPermissions(this.getAssociatedDataExploration(), "ReadMetadata", this.getParent());
        }
        if (null == (trans = (Transformation)this.getRepositoryEntity())) {
            return null;
        }
        return (TextStore)trans.getSourceCode();
    }

    @Override
    public void setDefault(boolean isDefault) throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null != this._isDefault && this._isDefault == isDefault) {
            return;
        }
        this._isDefault = isDefault ? Boolean.TRUE : Boolean.FALSE;
        TextStore textstore = this.getTextStore();
        if (textstore != null) {
            if (isDefault) {
                textstore.setDesc("default");
            } else {
                textstore.setDesc("");
            }
            textstore.setTextType("XML");
        }
    }

    @Override
    public void update() throws ServiceException, RemoteException {
        TextStore textstore = null;
        try {
            if (this.shouldConvert()) {
                this.upgradeFromPreviousVersion();
            }
            OMRUtils.checkPermissions(this.getAssociatedDataExploration(), "WriteMetadata", this.getParent());
            textstore = this.getTextStore();
            if (null != textstore) {
                textstore.updateMetadataAll();
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        super.update();
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (this.isDeleted()) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            OMRUtils.checkPermissions(this.getAssociatedDataExploration(), "WriteMetadata", this.getParent());
            ArrayList<Transformation> omrObjectsToDelete = new ArrayList<Transformation>();
            CMetadata omrObject = (CMetadata)this.getRepositoryEntity();
            if (omrObject != null && omrObject instanceof Transformation) {
                Transformation transform = (Transformation)omrObject;
                omrObjectsToDelete.addAll((Collection<Transformation>)transform.getProperties());
                omrObjectsToDelete.addAll((Collection<Transformation>)transform.getKeywords());
                omrObjectsToDelete.addAll((Collection<Transformation>)transform.getSourceCodes());
                omrObjectsToDelete.add(transform);
            }
            OMIRepositoryInterface repos = (OMIRepositoryInterface)this.getRepository();
            repos.deleteEntities(omrObjectsToDelete);
            super.delete();
            this.destroy();
        }
        catch (MdException e) {
            throw new ServiceException(e, null);
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        try {
            if (obj instanceof BookmarkEntryInterface) {
                BookmarkEntryInterface bkmk = (BookmarkEntryInterface)obj;
                result = this.getReposId().equals(bkmk.getReposId());
            } else {
                result = super.equals(obj);
            }
        }
        catch (Exception e) {
            result = super.equals(obj);
        }
        return result;
    }

    private boolean shouldConvert() throws RemoteException, MdException, ServiceException {
        boolean convert = false;
        if (OMRUtils.isTempObj(this)) {
            return false;
        }
        Object omrObj = this.getRepositoryEntity();
        if (null == omrObj) {
            return false;
        }
        Transformation trans = (Transformation)omrObj;
        convert = convert || CURRENT_VERSION.compareTo((Object)UsageVersion.decode((double)trans.getUsageVersion())) > 0;
        convert = convert || !"DataExplorationBookmark".equals(trans.getPublicType());
        return convert;
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this.inUpgrade) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.inUpgrade = true;
        try {
            Transformation trans = (Transformation)this.getRepositoryEntity();
            if (OMRUtils.changePropertyValueFromIDtoURL(this, trans, this.getRepository(), "DataExplorationId", "DataExplorationURL")) {
                this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("Transformation.convert3.fmt.txt"), (Object)trans.getRepositoryID(), (Object)"DataExplorationBookmark", (Object)String.valueOf(CURRENT_VERSION.encode())));
            } else {
                this.logMessage(Level.WARN, "Unable to convert dataexploration id property of bookmark to dataexploration URL for bookmark " + this);
            }
            trans.setPublicType("DataExplorationBookmark");
            trans.setUsageVersion(CURRENT_VERSION.encode());
            TextStore textstore = this.getTextStore();
            String role = null;
            if (null != textstore) {
                role = textstore.getTextRole();
            }
            if (null == role || role.trim().length() == 0) {
                textstore.setTextRole("DataExplorationBookmarkTextStore");
                textstore.setTextType("XML");
                Property prop = OMRUtils.getPropertyByName((Transformation)this.getRepositoryEntity(), "DataExplorationURL");
                if (null == prop) {
                    this._isDefault = Boolean.FALSE;
                } else {
                    this._isDefault = "true".equalsIgnoreCase(prop.getDesc()) ? Boolean.TRUE : Boolean.FALSE;
                    prop.setDesc("");
                }
                if (this._isDefault.booleanValue()) {
                    textstore.setDesc("default");
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            this.inUpgrade = false;
        }
    }
}

