/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.configpersist;

import com.sas.services.information.metadata.configpersist.ConfigurationXMLPersistenceUtility;
import com.sas.services.information.metadata.configpersist.EnumerationItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ParsedConfigurationXMLObject {
    private static final int MAPPING_INIT = 16;
    private static final int VALUE_LIST_INIT = 32;
    protected Map mappings = new HashMap(16);

    public List getEnumerationValues() {
        if (this.mappings.containsKey("Enumeration")) {
            ArrayList<Object> valuesList = new ArrayList<Object>(32);
            List eItemsList = (List)this.mappings.get("Enumeration");
            int listSize = eItemsList.size();
            for (int i = 0; i < listSize; ++i) {
                valuesList.add(((EnumerationItem)eItemsList.get(i)).getValue());
            }
            return valuesList;
        }
        return null;
    }

    public List getEnumerationItems() {
        if (this.mappings.containsKey("Enumeration")) {
            ArrayList valuesList = new ArrayList(32);
            List eItemsList = (List)this.mappings.get("Enumeration");
            return eItemsList;
        }
        return null;
    }

    public List getEnumerationTextLabels() {
        return this.getEnumerationTextLabels(null);
    }

    public List getEnumerationTextLabels(Locale locale) {
        if (this.mappings.containsKey("Enumeration")) {
            ArrayList<Object> labelsList = new ArrayList<Object>(32);
            List eItemsList = (List)this.mappings.get("Enumeration");
            int listSize = eItemsList.size();
            String textLabel = null;
            EnumerationItem eItem = null;
            for (int i = 0; i < listSize; ++i) {
                eItem = (EnumerationItem)eItemsList.get(i);
                textLabel = eItem.getTextLabel(locale);
                if (textLabel != null) {
                    labelsList.add(textLabel);
                    continue;
                }
                labelsList.add(eItem.getValue());
            }
            return labelsList;
        }
        return null;
    }

    public Map getEnumerationValuesLabelsMap(Locale locale) {
        if (this.mappings.containsKey("Enumeration")) {
            LinkedHashMap<Object, String> valueLabelMap = new LinkedHashMap<Object, String>(32);
            List eItemsList = (List)this.mappings.get("Enumeration");
            int listSize = eItemsList.size();
            Object textLabel = null;
            EnumerationItem eItem = null;
            for (int i = 0; i < listSize; ++i) {
                eItem = (EnumerationItem)eItemsList.get(i);
                valueLabelMap.put(eItem.getValue(), eItem.getTextLabel(locale));
            }
            return valueLabelMap;
        }
        return null;
    }

    public boolean hasUniqueTextLabels(Locale locale) {
        if (this.mappings.containsKey("Enumeration")) {
            List valuesList = this.getEnumerationValues();
            List textLabelsList = this.getEnumerationTextLabels(locale);
            return valuesList == null || textLabelsList == null ? false : !textLabelsList.equals(valuesList);
        }
        return false;
    }

    public void setEnumerationData(List list) {
        this.mappings.put("Enumeration", list);
    }

    public void setEnumerationOptions(Map map) {
        this.mappings.put("EnumerationOptions", map);
    }

    public boolean isEnumerationOthersAllowedSet() {
        if (this.mappings.containsKey("EnumerationOptions")) {
            Map enumerationOptions = (Map)this.mappings.get("EnumerationOptions");
            return enumerationOptions.containsKey("isOthersAllowed");
        }
        return false;
    }

    public boolean isEnumerationOthersAllowed() {
        if (!this.mappings.containsKey("EnumerationOptions")) {
            throw new IllegalArgumentException();
        }
        Map optionsMap = (Map)this.mappings.get("EnumerationOptions");
        if (!optionsMap.containsKey("isOthersAllowed")) {
            throw new IllegalArgumentException();
        }
        return (Boolean)optionsMap.get("isOthersAllowed");
    }

    public Map getSelectionRange() {
        return this.mappings.containsKey("SelectionRange") ? (Map)this.mappings.get("SelectionRange") : null;
    }

    public void setSelectionRange(Map map) {
        this.mappings.put("SelectionRange", map);
    }

    public Map getIntegerRange() {
        return this.mappings.containsKey("IntegerRange") ? (Map)this.mappings.get("IntegerRange") : null;
    }

    public void setIntegerRange(Map map) {
        this.mappings.put("IntegerRange", map);
    }

    public boolean isIntegerRangeMinimumSet() {
        return this.isIntegerRangeValueSet("min");
    }

    public boolean isIntegerRangeMaximumSet() {
        return this.isIntegerRangeValueSet("max");
    }

    public boolean isIntegerRangeIncrementSet() {
        return this.isIntegerRangeValueSet("increment");
    }

    protected boolean isIntegerRangeValueSet(String intValue) {
        if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(intValue)) {
            throw new IllegalArgumentException();
        }
        if (this.mappings.containsKey("IntegerRange")) {
            Map numericMap = (Map)this.mappings.get("IntegerRange");
            return numericMap.containsKey(intValue);
        }
        return false;
    }

    public int getIntegerRangeMinimum() {
        return this.getIntegerRangeValues("min");
    }

    public int getIntegerRangeMaximum() {
        return this.getIntegerRangeValues("max");
    }

    protected int getIntegerRangeValues(String intValue) {
        if (!this.mappings.containsKey("IntegerRange")) {
            throw new IllegalArgumentException();
        }
        if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(intValue)) {
            throw new IllegalArgumentException();
        }
        Map intMap = (Map)this.mappings.get("IntegerRange");
        if (intMap.containsKey(intValue)) {
            return (Integer)intMap.get(intValue);
        }
        if (intValue.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (intValue.equals("increment")) {
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public int getIntegerRangeIncrement() {
        return this.getIntegerRangeValues("increment");
    }

    public Map getNumericRange() {
        return this.mappings.containsKey("NumericRange") ? (Map)this.mappings.get("NumericRange") : null;
    }

    public void setNumericRange(Map map) {
        this.mappings.put("NumericRange", map);
    }

    public boolean isNumericRangeMinimumSet() {
        return this.isNumericRangeValueSet("min");
    }

    public boolean isNumericRangeMaximumSet() {
        return this.isNumericRangeValueSet("max");
    }

    public boolean isNumericRangeIncrementSet() {
        return this.isNumericRangeValueSet("increment");
    }

    protected boolean isNumericRangeValueSet(String intValue) {
        if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(intValue)) {
            throw new IllegalArgumentException();
        }
        if (this.mappings.containsKey("NumericRange")) {
            Map numericMap = (Map)this.mappings.get("NumericRange");
            if (intValue.equals("min")) {
                return numericMap.containsKey("min") || numericMap.containsKey("minExclusive");
            }
            if (intValue.equals("max")) {
                return numericMap.containsKey("max") || numericMap.containsKey("maxExclusive");
            }
            if (intValue.equals("increment")) {
                return numericMap.containsKey("increment");
            }
            return false;
        }
        return false;
    }

    public Number getNumericRangeMinimum() {
        return this.getNumericRangeValues("min");
    }

    public Number getNumericRangeMaximum() {
        return this.getNumericRangeValues("max");
    }

    public Number getNumericRangeIncrement() {
        return this.getNumericRangeValues("increment");
    }

    protected Number getNumericRangeValues(String numericValue) {
        if (!this.mappings.containsKey("NumericRange")) {
            throw new IllegalArgumentException();
        }
        if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(numericValue)) {
            throw new IllegalArgumentException();
        }
        Map numericMap = (Map)this.mappings.get("NumericRange");
        if (numericValue.equals("min")) {
            if (numericMap.containsKey("min") || numericMap.containsKey("minExclusive")) {
                if (numericMap.containsKey("min")) {
                    return (Number)numericMap.get("min");
                }
                return (Number)numericMap.get("minExclusive");
            }
            return null;
        }
        if (numericValue.equals("max")) {
            if (numericMap.containsKey("max") || numericMap.containsKey("maxExclusive")) {
                if (numericMap.containsKey("max")) {
                    return (Number)numericMap.get("max");
                }
                return (Number)numericMap.get("maxExclusive");
            }
            return null;
        }
        if (numericValue.equals("increment")) {
            if (numericMap.containsKey("increment")) {
                return (Number)numericMap.get("increment");
            }
            return null;
        }
        return null;
    }

    public boolean isNumericRangeMinimumExclusive() {
        if (this.isNumericRangeValueSet("min")) {
            return this.isNumericRangeValueExclusive("min");
        }
        throw new IllegalArgumentException();
    }

    public boolean isNumericRangeMaximumExclusive() {
        if (this.isNumericRangeValueSet("max")) {
            return this.isNumericRangeValueExclusive("max");
        }
        throw new IllegalArgumentException();
    }

    protected boolean isNumericRangeValueExclusive(String numericValue) {
        if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(numericValue)) {
            throw new IllegalArgumentException();
        }
        Map numericMap = (Map)this.mappings.get("NumericRange");
        if (numericValue.equals("min")) {
            return numericMap.containsKey("minExclusive");
        }
        return numericMap.containsKey("maxExclusive");
    }

    public Map getStringLengthRange() {
        return this.mappings.containsKey("StringLengthRange") ? (Map)this.mappings.get("StringLengthRange") : null;
    }

    public void setStringLengthRange(Map map) {
        this.mappings.put("StringLengthRange", map);
    }
}

