/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.configpersist;

import com.sas.services.information.metadata.configpersist.DOMDoc;
import com.sas.services.information.metadata.configpersist.EnumerationItem;
import com.sas.services.information.metadata.configpersist.ParsedConfigurationXMLObject;
import com.sas.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigurationXMLPersistenceUtility {
    private static final int OPTION_MAP_INIT = 16;
    private static final int RANGE_MAP_INIT = 4;
    private static final int ATTRIBUTE_LIST_INIT = 48;
    static Map enumerationOptions = new HashMap(16);
    static final char[] ENTITYREF = new char[]{'&', '<', '>', '\"', '\'', '\n'};
    private static char[] xmlSpecial = new char[]{'&', '\"', '<', '>', '\''};
    private static String[] xmlReplacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;", "&apos;"};
    public static final String ENUMERATION = "Enumeration";
    public static final String ENUMERATION_OPTIONS = "EnumerationOptions";
    public static final String ENUMERATION_MINIMUM_SELECTIONS = "EnumerationMinimumSelections";
    public static final String ENUMERATION_MAXIMUM_SELECTIONS = "EnumerationMaximumSelections";
    public static final String ENUMERATION_OTHERS_ALLOWED = "isOthersAllowed";
    public static final String SELECTION_RANGE = "SelectionRange";
    public static final String INTEGER_RANGE = "IntegerRange";
    public static final String NUMERIC_RANGE = "NumericRange";
    public static final String CLASS_TYPE = "classType";
    public static final String RANGE_INCREMENT = "increment";
    public static final String MINIMUM = "min";
    public static final String MINIMUM_EXCLUSIVE = "minExclusive";
    public static final String MAXIMUM = "max";
    public static final String MAXIMUM_EXCLUSIVE = "maxExclusive";
    public static final String STRING_LENGTH_RANGE = "StringLengthRange";
    private static final String CONFIGURATION = "Configuration";
    private static final String VALUE = "Value";
    private static final String TEXT = "Text";
    private static final String VERSION = "version";
    private static final String NAME = "name";

    public static String writeConfigurationXML(Map dataTypesMap) {
        DOMDoc domDoc = new DOMDoc();
        domDoc.newDocument(false);
        Element configuration = domDoc.createElement(CONFIGURATION);
        domDoc.appendChild(configuration);
        Attr entityVersion = domDoc.createAttribute(VERSION);
        entityVersion.setValue("2.0");
        configuration.setAttributeNode(entityVersion);
        if (dataTypesMap.containsKey(ENUMERATION_OPTIONS)) {
            enumerationOptions = (Map)dataTypesMap.get(ENUMERATION_OPTIONS);
        }
        Iterator iter = dataTypesMap.entrySet().iterator();
        Map.Entry mapEntry = null;
        while (iter.hasNext()) {
            mapEntry = iter.next();
            String elementName = (String)mapEntry.getKey();
            Element eachElement = domDoc.createElement(elementName);
            configuration.appendChild(eachElement);
            if (elementName.equals(ENUMERATION)) {
                boolean haveEnumerationOptions;
                Object type = mapEntry.getValue();
                boolean bl = haveEnumerationOptions = enumerationOptions.size() > 0;
                if (haveEnumerationOptions && enumerationOptions.containsKey(ENUMERATION_OTHERS_ALLOWED)) {
                    Boolean othersAllowedValue = (Boolean)enumerationOptions.get(ENUMERATION_OTHERS_ALLOWED);
                    Attr othersAllowed = domDoc.createAttribute(ENUMERATION_OTHERS_ALLOWED);
                    eachElement.setAttributeNode(othersAllowed);
                    othersAllowed.setValue(othersAllowedValue.toString());
                }
                if (type instanceof List) {
                    ConfigurationXMLPersistenceUtility.writeEnumerationElement(domDoc, eachElement, (List)type);
                } else if (type instanceof Map) {
                    ConfigurationXMLPersistenceUtility.writeEnumerationElement(domDoc, eachElement, (Map)type);
                } else if (type instanceof EnumerationItem) {
                    ConfigurationXMLPersistenceUtility.writeEnumerationElement(domDoc, eachElement, (EnumerationItem)type);
                }
                if (enumerationOptions.size() <= 0 || !enumerationOptions.containsKey(SELECTION_RANGE)) continue;
                ConfigurationXMLPersistenceUtility.writeSelectionRangeElement(domDoc, eachElement);
                continue;
            }
            if (elementName.equals(INTEGER_RANGE)) {
                ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, eachElement, (Map)mapEntry.getValue());
                continue;
            }
            if (elementName.equals(NUMERIC_RANGE)) {
                ConfigurationXMLPersistenceUtility.writeNumericRangeElement(domDoc, eachElement, (Map)mapEntry.getValue());
                continue;
            }
            if (!elementName.equals(STRING_LENGTH_RANGE)) continue;
            ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, eachElement, (Map)mapEntry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        domDoc.writeDocument(stringWriter, true);
        return stringWriter.toString();
    }

    protected static void writeEnumerationElement(DOMDoc domDoc, Element eachElement, Map valuesMap) {
        Iterator iter = valuesMap.entrySet().iterator();
        Map.Entry mapEntry = null;
        String mapValue = null;
        Element value = null;
        while (iter.hasNext()) {
            mapEntry = iter.next();
            mapValue = (String)mapEntry.getKey();
            value = domDoc.createElement(VALUE);
            eachElement.appendChild(value);
            Attr name = domDoc.createAttribute(NAME);
            value.setAttributeNode(name);
            name.setValue(Strings.replace((String)mapValue, (char[])xmlSpecial, (String[])xmlReplacements));
            String s = Strings.replace((String)((String)mapEntry.getValue()), (char[])xmlSpecial, (String[])xmlReplacements);
            Element textElement = domDoc.createElement(TEXT);
            value.appendChild(textElement);
            Text textNode = domDoc.createTextNode(s);
            textElement.appendChild(textNode);
        }
    }

    protected static void writeEnumerationElement(DOMDoc domDoc, Element eachElement, EnumerationItem item) {
        Map labelMap;
        String mapValue = null;
        Element value = null;
        mapValue = item.getValue().toString();
        value = domDoc.createElement(VALUE);
        eachElement.appendChild(value);
        Attr name = domDoc.createAttribute(NAME);
        value.setAttributeNode(name);
        name.setValue(Strings.replace((String)mapValue, (char[])xmlSpecial, (String[])xmlReplacements));
        if (item.getTextLabel() != null) {
            String s = Strings.replace((String)item.getTextLabel(), (char[])xmlSpecial, (String[])xmlReplacements);
            Element textElement = domDoc.createElement(TEXT);
            value.appendChild(textElement);
            Text textNode = domDoc.createTextNode(s);
            textElement.appendChild(textNode);
        }
        if ((labelMap = item.getTextLabels()).size() > 0) {
            Iterator it = labelMap.entrySet().iterator();
            Map.Entry mapEntry = null;
            while (it.hasNext()) {
                mapEntry = it.next();
                Locale locale = (Locale)mapEntry.getKey();
                String s = Strings.replace((String)((String)mapEntry.getValue()), (char[])xmlSpecial, (String[])xmlReplacements);
                Element textElement = domDoc.createElement(TEXT);
                textElement.setAttribute("xml:lang", locale.getLanguage());
                Text textNode = domDoc.createTextNode(s);
                textElement.appendChild(textNode);
            }
        }
    }

    protected static void writeSelectionRangeElement(DOMDoc domDoc, Element enumerationElement) {
        Element selectionRange = domDoc.createElement(SELECTION_RANGE);
        enumerationElement.appendChild(selectionRange);
        if (enumerationOptions.containsKey(SELECTION_RANGE)) {
            Map rangeOptions = (Map)enumerationOptions.get(SELECTION_RANGE);
            ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, selectionRange, rangeOptions);
        }
    }

    protected static void writeEnumerationElement(DOMDoc domDoc, Element eachElement, List valuesList) {
        int listSize = valuesList.size();
        Object listValue = null;
        Element value = null;
        for (int i = 0; i < listSize; ++i) {
            Attr name;
            listValue = valuesList.get(i);
            value = domDoc.createElement(VALUE);
            eachElement.appendChild(value);
            if (listValue instanceof String) {
                Attr name2 = domDoc.createAttribute(NAME);
                value.setAttributeNode(name2);
                name2.setValue(Strings.replace((String)((String)listValue), (char[])xmlSpecial, (String[])xmlReplacements));
                continue;
            }
            if (listValue instanceof EnumerationItem) {
                Map labelMap;
                EnumerationItem item = (EnumerationItem)listValue;
                Attr name3 = domDoc.createAttribute(NAME);
                value.setAttributeNode(name3);
                name3.setValue(Strings.replace((String)item.getValue().toString(), (char[])xmlSpecial, (String[])xmlReplacements));
                if (item.getTextLabel() != null) {
                    String s = Strings.replace((String)item.getTextLabel(), (char[])xmlSpecial, (String[])xmlReplacements);
                    Element textElement = domDoc.createElement(TEXT);
                    value.appendChild(textElement);
                    Text textNode = domDoc.createTextNode(s);
                    textElement.appendChild(textNode);
                }
                if ((labelMap = item.getTextLabels()).size() <= 0) continue;
                Iterator it = labelMap.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (it.hasNext()) {
                    mapEntry = it.next();
                    Locale locale = (Locale)mapEntry.getKey();
                    String s = Strings.replace((String)((String)mapEntry.getValue()), (char[])xmlSpecial, (String[])xmlReplacements);
                    Element textElement = domDoc.createElement(TEXT);
                    value.appendChild(textElement);
                    textElement.setAttribute("xml:lang", locale.getLanguage());
                    Text textNode = domDoc.createTextNode(s);
                    textElement.appendChild(textNode);
                }
                continue;
            }
            boolean foundClassType = false;
            boolean haveSetClassType = false;
            Class<?> listValueClass = listValue.getClass();
            if (listValue instanceof Integer) {
                Integer intValue = (Integer)listValue;
                name = domDoc.createAttribute(NAME);
                value.setAttributeNode(name);
                name.setValue(intValue.toString());
                foundClassType = true;
            } else if (listValue instanceof Float) {
                Float floatValue = (Float)listValue;
                name = domDoc.createAttribute(NAME);
                value.setAttributeNode(name);
                name.setValue(floatValue.toString());
                foundClassType = true;
            }
            if (!foundClassType || haveSetClassType) continue;
            Attr rClassType = domDoc.createAttribute(CLASS_TYPE);
            eachElement.setAttributeNode(rClassType);
            rClassType.setValue(listValueClass.getName());
            haveSetClassType = true;
        }
    }

    protected static void writeIntegerRangeElement(DOMDoc domDoc, Element rangeElement, Map valuesMap) {
        Iterator iter = valuesMap.entrySet().iterator();
        Map.Entry mapEntry = null;
        while (iter.hasNext()) {
            mapEntry = iter.next();
            String rangePoint = (String)mapEntry.getKey();
            if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(rangePoint)) {
                throw new IllegalArgumentException();
            }
            Integer rangeValue = (Integer)mapEntry.getValue();
            Attr rPoint = domDoc.createAttribute(rangePoint);
            rangeElement.setAttributeNode(rPoint);
            rPoint.setValue(rangeValue.toString());
        }
    }

    protected static boolean isValidKeyWord(String value) {
        return value.equals(RANGE_INCREMENT) ? true : (value.equals(MINIMUM) ? true : (value.equals(MINIMUM_EXCLUSIVE) ? true : (value.equals(MAXIMUM) ? true : value.equals(MAXIMUM_EXCLUSIVE))));
    }

    protected static void writeNumericRangeElement(DOMDoc domDoc, Element rangeElement, Map valuesMap) {
        boolean haveSetNumericType = false;
        Iterator iter = valuesMap.entrySet().iterator();
        Map.Entry mapEntry = null;
        while (iter.hasNext()) {
            mapEntry = iter.next();
            String rangePoint = (String)mapEntry.getKey();
            if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(rangePoint)) {
                throw new IllegalArgumentException();
            }
            if (!haveSetNumericType) {
                Object o = valuesMap.get(rangePoint);
                Class<?> c = o.getClass();
                Attr rClassType = domDoc.createAttribute(CLASS_TYPE);
                rangeElement.setAttributeNode(rClassType);
                rClassType.setValue(c.getName());
                haveSetNumericType = true;
            }
            Number rangeValue = (Number)mapEntry.getValue();
            Attr rPoint = domDoc.createAttribute(rangePoint);
            rangeElement.setAttributeNode(rPoint);
            rPoint.setValue(rangeValue.toString());
        }
    }

    public static ParsedConfigurationXMLObject createParsedConfigurationXMLObject(String docString) {
        ParsedConfigurationXMLObject parsedObject;
        block30: {
            parsedObject = new ParsedConfigurationXMLObject();
            try {
                byte[] xmlBytes = docString.getBytes("UTF-8");
                if (xmlBytes == null || xmlBytes.length == 0) {
                    return null;
                }
                DOMDoc doc = new DOMDoc();
                doc.loadDocument(new ByteArrayInputStream(xmlBytes), false);
                Element rootElement = doc.getDocumentElement();
                if (!rootElement.getTagName().equals(CONFIGURATION)) break block30;
                NamedNodeMap rootAttributesMap = rootElement.getAttributes();
                if (rootAttributesMap.getLength() == 0) {
                    return ConfigurationXMLPersistenceUtility.createOldParsedConfigurationXMLObject(docString);
                }
                NodeList nl = rootElement.getElementsByTagName("*");
                int nodeLength = nl.getLength();
                HashMap<String, Boolean> enumerationOptions = null;
                ArrayList<EnumerationItem> al = null;
                HashMap<String, Object> numericMap = null;
                for (int i = 0; i < nodeLength; ++i) {
                    NamedNodeMap nodeMap;
                    int j;
                    Node attributeElement = nl.item(i);
                    String nodeName = attributeElement.getNodeName();
                    if (nodeName.equals(ENUMERATION)) {
                        al = new ArrayList<EnumerationItem>(48);
                        String enumerationType = null;
                        if (attributeElement.hasAttributes()) {
                            NamedNodeMap nodeMap2 = attributeElement.getAttributes();
                            int mapLength = nodeMap2.getLength();
                            Boolean nodeValue = null;
                            for (int w = 0; w < mapLength; ++w) {
                                Node enumOption = nodeMap2.item(w);
                                String enumNodeName = enumOption.getNodeName();
                                if (enumNodeName.equals(ENUMERATION_OTHERS_ALLOWED)) {
                                    nodeValue = Boolean.valueOf(enumOption.getNodeValue());
                                    if (enumerationOptions != null) continue;
                                    enumerationOptions = new HashMap<String, Boolean>(16);
                                    enumerationOptions.put(ENUMERATION_OTHERS_ALLOWED, nodeValue);
                                    parsedObject.setEnumerationOptions(enumerationOptions);
                                    continue;
                                }
                                if (!enumNodeName.equals(CLASS_TYPE)) continue;
                                String classType = enumOption.getNodeValue();
                                nodeMap2.removeNamedItem(CLASS_TYPE);
                                enumerationType = classType;
                            }
                        }
                        NodeList valueType = attributeElement.getChildNodes();
                        int valueTypeLength = valueType.getLength();
                        EnumerationItem eItem = null;
                        for (j = 0; j < valueTypeLength; ++j) {
                            eItem = new EnumerationItem();
                            Node subtagElement = valueType.item(j);
                            String subtagName = subtagElement.getNodeName();
                            if (subtagName.equals(VALUE)) {
                                String attributeValue = null;
                                if (subtagElement.hasAttributes()) {
                                    NamedNodeMap nodeMap3 = subtagElement.getAttributes();
                                    attributeValue = nodeMap3.getNamedItem(NAME).getNodeValue();
                                    if (enumerationType == null) {
                                        eItem.setValue(attributeValue);
                                    } else {
                                        eItem.setValue(ConfigurationXMLPersistenceUtility.createClassType(attributeValue, enumerationType));
                                    }
                                } else {
                                    NodeList dataList = subtagElement.getChildNodes();
                                    if (dataList.getLength() > 0) {
                                        Node childElement = dataList.item(0);
                                        String listValue = childElement.getNodeValue();
                                        eItem.setValue(listValue);
                                    }
                                }
                                if (subtagElement.hasChildNodes()) {
                                    NodeList textList = subtagElement.getChildNodes();
                                    Node textElement = null;
                                    String textName = null;
                                    int textListLength = textList.getLength();
                                    for (int m = 0; m < textListLength; ++m) {
                                        Node langNode;
                                        textElement = textList.item(m);
                                        Locale locale = null;
                                        NamedNodeMap textAtts = textElement.getAttributes();
                                        if (textAtts != null && (langNode = textAtts.getNamedItem("xml:lang")) != null) {
                                            String language = langNode.getNodeValue();
                                            locale = new Locale(language);
                                        }
                                        if (!(textName = textElement.getNodeName()).equals(TEXT)) continue;
                                        if (textElement.hasChildNodes()) {
                                            NodeList textChildList = textElement.getChildNodes();
                                            int listLength = textChildList.getLength();
                                            for (int p = 0; p < listLength; ++p) {
                                                Node childElement = textChildList.item(p);
                                                String listValue = childElement.getNodeValue();
                                                if (locale != null) {
                                                    eItem.setTextLabel(locale, listValue);
                                                    continue;
                                                }
                                                eItem.setTextLabel(listValue);
                                            }
                                            continue;
                                        }
                                        eItem.setTextLabel(textElement.getNodeValue());
                                    }
                                }
                                al.add(eItem);
                                continue;
                            }
                            if (!subtagName.equals(SELECTION_RANGE)) continue;
                            numericMap = new HashMap(4);
                            NamedNodeMap nodeMap4 = subtagElement.getAttributes();
                            int nodeMapLength = nodeMap4.getLength();
                            Integer nodeValue = null;
                            for (int k = 0; k < nodeMapLength; ++k) {
                                Node intElement = nodeMap4.item(k);
                                String intName = intElement.getNodeName();
                                nodeValue = Integer.valueOf(intElement.getNodeValue());
                                numericMap.put(intName, nodeValue);
                            }
                            if (numericMap.size() <= 0) continue;
                            parsedObject.setSelectionRange(numericMap);
                        }
                        parsedObject.setEnumerationData(al);
                        continue;
                    }
                    if (nodeName.equals(INTEGER_RANGE)) {
                        numericMap = new HashMap<String, Object>(4);
                        nodeMap = attributeElement.getAttributes();
                        int nodeMapLength = nodeMap.getLength();
                        Integer nodeValue = null;
                        for (int j2 = 0; j2 < nodeMapLength; ++j2) {
                            Node intElement = nodeMap.item(j2);
                            String intName = intElement.getNodeName();
                            nodeValue = Integer.valueOf(intElement.getNodeValue());
                            numericMap.put(intName, nodeValue);
                        }
                        if (numericMap.size() <= 0) continue;
                        parsedObject.setIntegerRange(numericMap);
                        continue;
                    }
                    if (nodeName.equals(NUMERIC_RANGE)) {
                        String numericType = null;
                        numericMap = new HashMap(4);
                        NamedNodeMap nodeMap5 = attributeElement.getAttributes();
                        Node classTypeNode = nodeMap5.getNamedItem(CLASS_TYPE);
                        if (classTypeNode != null) {
                            String classType = classTypeNode.getNodeValue();
                            nodeMap5.removeNamedItem(CLASS_TYPE);
                            numericType = classType;
                        } else {
                            numericType = "java.lang.Double";
                        }
                        int nodeMapLength = nodeMap5.getLength();
                        for (j = 0; j < nodeMapLength; ++j) {
                            Node numericElement = nodeMap5.item(j);
                            String numericName = numericElement.getNodeName();
                            String nodeValue = numericElement.getNodeValue();
                            numericMap.put(numericName, ConfigurationXMLPersistenceUtility.createClassType(nodeValue, numericType));
                        }
                        if (numericMap.size() <= 0) continue;
                        parsedObject.setNumericRange(numericMap);
                        continue;
                    }
                    if (!nodeName.equals(STRING_LENGTH_RANGE)) continue;
                    numericMap = new HashMap(4);
                    nodeMap = attributeElement.getAttributes();
                    int nodeMapLength = nodeMap.getLength();
                    String intName = null;
                    Integer nodeValue = null;
                    for (j = 0; j < nodeMapLength; ++j) {
                        Node intElement = nodeMap.item(j);
                        intName = intElement.getNodeName();
                        nodeValue = Integer.valueOf(intElement.getNodeValue());
                        numericMap.put(intName, nodeValue);
                    }
                    if (numericMap.size() <= 0) continue;
                    parsedObject.setStringLengthRange(numericMap);
                }
            }
            catch (UnsupportedEncodingException uee) {
                Logger logger = LogManager.getLogger((String)ConfigurationXMLPersistenceUtility.class.getName());
                logger.warn(uee.getMessage(), (Throwable)uee);
            }
        }
        return parsedObject;
    }

    public static Object createClassType(String nodeValue, String className) {
        if (className.equals("java.lang.Double")) {
            return Double.valueOf(nodeValue);
        }
        if (className.equals("java.lang.Float")) {
            return Float.valueOf(nodeValue);
        }
        if (className.equals("java.lang.Integer")) {
            return Integer.valueOf(nodeValue);
        }
        return Double.valueOf(nodeValue);
    }

    public static void setEnumerationOptions(Map options) {
        if (options == null) {
            enumerationOptions.clear();
        } else {
            enumerationOptions.putAll(options);
        }
    }

    public static ParsedConfigurationXMLObject createOldParsedConfigurationXMLObject(String docString) {
        ParsedConfigurationXMLObject parsedObject = new ParsedConfigurationXMLObject();
        try {
            byte[] xmlBytes = docString.getBytes("UTF-8");
            if (xmlBytes == null || xmlBytes.length == 0) {
                return null;
            }
            DOMDoc doc = new DOMDoc();
            doc.loadDocument(new ByteArrayInputStream(xmlBytes), false);
            Element rootElement = doc.getDocumentElement();
            if (rootElement.getTagName().equals(CONFIGURATION)) {
                NodeList nl = rootElement.getElementsByTagName("*");
                int nodeLength = nl.getLength();
                HashMap<String, Integer> numericMap = null;
                ArrayList<String> al = null;
                for (int i = 0; i < nodeLength; ++i) {
                    int j;
                    Number nodeValue;
                    int nodeMapLength;
                    NamedNodeMap nodeMap;
                    Node attributeElement = nl.item(i);
                    String nodeName = attributeElement.getNodeName();
                    if (nodeName.equals(ENUMERATION)) {
                        al = new ArrayList<String>(48);
                        NodeList valueType = attributeElement.getChildNodes();
                        int valueTypeLength = valueType.getLength();
                        for (int j2 = 0; j2 < valueTypeLength; ++j2) {
                            NodeList childList;
                            Node childElement;
                            Node valueElement = valueType.item(j2);
                            String valueName = valueElement.getNodeName();
                            if (!valueName.equals(VALUE)) continue;
                            if (valueElement.hasAttributes()) {
                                NamedNodeMap nodeMap2 = valueElement.getAttributes();
                                String attributeValue = nodeMap2.getNamedItem(NAME).getNodeValue();
                                al.add(attributeValue);
                                continue;
                            }
                            if (!valueElement.hasChildNodes() || (childElement = (childList = valueElement.getChildNodes()).item(0)).getNodeType() != 4) continue;
                            String listValue = childElement.getNodeValue();
                            al.add(listValue);
                        }
                        parsedObject.setEnumerationData(al);
                        continue;
                    }
                    if (nodeName.equals(INTEGER_RANGE)) {
                        numericMap = new HashMap<String, Integer>(4);
                        nodeMap = attributeElement.getAttributes();
                        nodeMapLength = nodeMap.getLength();
                        String intName = null;
                        nodeValue = null;
                        for (j = 0; j < nodeMapLength; ++j) {
                            Node intElement = nodeMap.item(j);
                            intName = intElement.getNodeName();
                            nodeValue = Integer.valueOf(intElement.getNodeValue());
                            numericMap.put(intName, (Integer)nodeValue);
                        }
                        if (numericMap.size() <= 0) continue;
                        parsedObject.setIntegerRange(numericMap);
                        continue;
                    }
                    if (!nodeName.equals(NUMERIC_RANGE)) continue;
                    numericMap = new HashMap(4);
                    nodeMap = attributeElement.getAttributes();
                    nodeMapLength = nodeMap.getLength();
                    String numericName = null;
                    nodeValue = null;
                    for (j = 0; j < nodeMapLength; ++j) {
                        Node numericElement = nodeMap.item(j);
                        numericName = numericElement.getNodeName();
                        nodeValue = Double.valueOf(numericElement.getNodeValue());
                        numericMap.put(numericName, (Integer)nodeValue);
                    }
                    if (numericMap.size() <= 0) continue;
                    parsedObject.setNumericRange(numericMap);
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            Logger logger = LogManager.getLogger((String)ConfigurationXMLPersistenceUtility.class.getName());
            logger.warn(uee.getMessage(), (Throwable)uee);
        }
        return parsedObject;
    }
}

