/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.metadata.RB;
import com.sas.services.util.XMLUtil;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PersonFilter
extends Filter {
    private static final long serialVersionUID = 256251445046144289L;
    int _relation;

    public PersonFilter() {
        this.setType("Person");
        this._relation = 0;
    }

    public PersonFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("Person");
    }

    public void setRelation(int relation) {
        if (relation != 0 && relation != 1) {
            throw new IllegalArgumentException(RB.getStringResource("PersonFilter.relationerror.ex.txt"));
        }
        this._relation = relation;
    }

    @Override
    public String getOMRType() {
        return "Person";
    }

    public String getLDAPType() {
        return "inetorgperson";
    }

    @Override
    public String getXMLSelectString() {
        FilterComponent compy = this._component;
        String name = this.getName();
        if (name != null) {
            FilterComponent nameComp = new FilterComponent("Name", this._relation, XMLUtil.normalize(name));
            if (compy != null) {
                nameComp.addComponent(compy);
                nameComp.setAggregation(0);
            }
            this.setFilterComponent(nameComp);
            this.setName(null);
        }
        String result = super.getXMLSelectString();
        this.setName(name);
        this.setFilterComponent(compy);
        return result;
    }
}

