/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.SmartDef;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PathFilter
extends Filter
implements FilterInterface {
    private static final long serialVersionUID = 8050097097456027899L;
    private static final int STRINGBUFFER_INIT = 128;
    private PathUrl pathurl;

    public PathFilter(PathUrl pathurl, String metadataType) {
        this(pathurl);
        this.setType(metadataType);
    }

    public PathFilter(PathUrl pathurl, MetadataServerInterface server) {
        this(pathurl);
        String pathType = pathurl.getType();
        if (pathType == null) {
            throw new IllegalArgumentException("A PathUrl with a null type is invalid in this usage.");
        }
        try {
            TypeDescriptorInterface tdi = server.getTypeDescriptor(pathType);
            if (tdi != null) {
                this.setType(tdi.getMetadataType());
            } else {
                Map actionMap;
                Object o;
                InformationServiceInterface isi;
                Map smartMap;
                SmartDef def;
                Map typeMap = server.getTypeDictionaryMap();
                for (String nextKey : typeMap.keySet()) {
                    if (!nextKey.startsWith(pathType)) continue;
                    tdi = server.getTypeDescriptor(nextKey);
                    this.setType(tdi.getMetadataType());
                    break;
                }
                if (this.getType() == null && (def = (SmartDef)(smartMap = (isi = OMIServerRepository.getInformationService()).getSmartObjectDefinitions()).get(pathType)) != null && (o = (actionMap = def.getActions()).get("omi")) != null && !(o instanceof List)) {
                    SmartDef.ActionDef action = (SmartDef.ActionDef)o;
                    this.setType(action.getType());
                }
            }
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.getType() == null) {
            this.setType(pathType);
        }
    }

    public PathFilter(PathUrl pathurl) {
        if (pathurl == null) {
            throw new IllegalArgumentException();
        }
        this.pathurl = pathurl;
        if (pathurl.getName() == null && pathurl.getPath() == null) {
            this.setName(pathurl.getRootTree());
        } else {
            this.setName(pathurl.getName());
        }
    }

    @Override
    public String getXMLSelectString() {
        StringBuffer buffer = new StringBuffer(128);
        FilterComponent compy = this._component;
        String name = this.getName();
        if (name != null) {
            FilterComponent nameComp = new FilterComponent("Name", 0, name);
            if (compy != null) {
                nameComp.addComponent(compy);
                nameComp.setAggregation(0);
            }
            this._component = nameComp;
        }
        if (this._component == null) {
            return "";
        }
        String componentFilter = this.component2Select(this._component);
        if ("UNSUPPORTED".equals(componentFilter)) {
            return "UNSUPPORTED";
        }
        if (componentFilter.length() == 0) {
            return "";
        }
        componentFilter = componentFilter.trim();
        buffer.append("<XMLSelect Search=\"*[");
        buffer.append(componentFilter);
        buffer.append("]");
        buffer.append(this.getPathString());
        buffer.append("\" />\n");
        return buffer.toString();
    }

    protected String getPathString() {
        StringBuffer buffer = new StringBuffer(1024);
        String path = this.pathurl.getPath();
        if (path != null || this.pathurl.getName() != null) {
            String type = this.getOMRType();
            if (type != null && type.equals("Tree")) {
                buffer.append("[ParentTree");
            } else {
                buffer.append("[Trees");
            }
            if (path != null && path.trim().length() > 0) {
                ArrayList<String> pathList = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(path, "/", false);
                while (st.hasMoreTokens()) {
                    String parent = st.nextToken();
                    pathList.add(parent);
                }
                for (int i = pathList.size() - 1; i >= 0; --i) {
                    String parent = (String)pathList.get(i);
                    buffer.append("/Tree[@Name='" + parent + "']/ParentTree");
                }
            }
            String root = this.pathurl.getRootTree();
            buffer.append("/Tree[@Name='" + root + "']/SoftwareComponents/SoftwareComponent[@Name='BIP Service']]");
        } else {
            buffer.append("[SoftwareComponents/SoftwareComponent[@Name='BIP Service']]");
        }
        return buffer.toString();
    }
}

