/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryClause;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.impl.QueryClauseImpl;
import com.sas.metadata.remote.impl.QueryClauseImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.QueryClauseInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.TextStoreInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRQueryClause
extends Metadata
implements QueryClauseInterface {
    private static final long serialVersionUID = -2541561049776595686L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRQueryClause() throws RemoteException {
        super(OMRQueryClause.class);
    }

    public OMRQueryClause(QueryClause o) throws RemoteException {
        super(o, OMRQueryClause.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRQueryClause(QueryClauseImpl o) throws RemoteException {
        super(o, OMRQueryClause.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRQueryClause(QueryClauseImpl_Stub o) throws RemoteException {
        super(o, OMRQueryClause.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRQueryClause(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRQueryClause.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                QueryClause clause = (QueryClause)omirepository.createMetadata(name, "QueryClause");
                this._isCompatible = true;
                this._isReadCompatible = true;
                clause.setUsageVersion(CURRENT_VERSION.encode());
                this._repositoryObject = clause;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    clause.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public TextStoreInterface getSourceCode() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        QueryClause qc = (QueryClause)this._repositoryObject;
        try {
            TextStore ts = (TextStore)qc.getSourceCode();
            if (ts == null) {
                return null;
            }
            TextStoreInterface result = (TextStoreInterface)this._repository.factoryProcess(ts);
            return result;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "QueryClause";
    }

    @Override
    public void setSourceCode(TextStoreInterface text) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        QueryClause qc = (QueryClause)this._repositoryObject;
        try {
            TextStore ts = (TextStore)text.getRepositoryEntity();
            qc.setSourceCode((Text)ts);
        }
        catch (Exception mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public List getColumns() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<ColumnInterface> result = Collections.EMPTY_LIST;
        QueryClause qc = (QueryClause)this._repositoryObject;
        try {
            AssociationList mColumns = qc.getColumns();
            result = new ArrayList<ColumnInterface>(mColumns.size());
            for (Column col : mColumns) {
                ColumnInterface ci = (ColumnInterface)this._repository.factoryProcess(col);
                result.add(ci);
            }
            return result;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void addColumn(ColumnInterface column) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        QueryClause qc = (QueryClause)this._repositoryObject;
        try {
            AssociationList mColumns = qc.getColumns();
            Column col = (Column)column.getRepositoryEntity();
            mColumns.add(col);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeColumn(ColumnInterface column) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        QueryClause qc = (QueryClause)this._repositoryObject;
        try {
            AssociationList mColumns = qc.getColumns();
            Column col = (Column)column.getRepositoryEntity();
            mColumns.remove(col);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void setColumns(List columns) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        QueryClause qc = (QueryClause)this._repositoryObject;
        try {
            AssociationList mColumns = qc.getColumns();
            mColumns.clear();
            for (ColumnInterface column : columns) {
                Column col = (Column)column.getRepositoryEntity();
                mColumns.add(col);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }
}

