/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.PrototypeProperty;
import com.sas.metadata.remote.impl.PrototypeImpl;
import com.sas.metadata.remote.impl.PrototypeImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.AssociationPropertyInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyGroupInterface;
import com.sas.services.information.metadata.PrototypeInterface;
import com.sas.services.information.metadata.PrototypePropertyInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRPrototype
extends Metadata
implements PrototypeInterface {
    private static final long serialVersionUID = -2384893276863807276L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRPrototype(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRPrototype() throws RemoteException {
        super(OMRPrototype.class);
    }

    protected OMRPrototype(Prototype o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRPrototype(Prototype o) throws RemoteException {
        super(o, OMRPrototype.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRPrototype(PrototypeImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRPrototype(PrototypeImpl o) throws RemoteException {
        super(o, OMRPrototype.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRPrototype(PrototypeImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRPrototype(PrototypeImpl_Stub o) throws RemoteException {
        super(o, OMRPrototype.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPrototype(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRPrototype.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Prototype prototype = (Prototype)omirepository.createMetadata(name, "Prototype");
                prototype.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = prototype;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    prototype.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPrototype", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        PrimaryType pt;
        String publicType;
        if (this._repositoryObject != null && (publicType = (pt = (PrimaryType)this._repositoryObject).getPublicType()) != null && publicType.length() > 0) {
            return publicType;
        }
        return "Prototype";
    }

    @Override
    public String getMetadataType() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        return prototype.getMetadataType();
    }

    @Override
    public void setMetadataType(String type) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        prototype.setMetadataType(type);
    }

    @Override
    public List getPrototypeProperties() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            Object propList = prototype.getPrototypeProperties();
            if (propList.size() > 0) {
                results = new ArrayList<MetadataInterface>(propList.size());
                Iterator it = propList.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    results.add(this._repository.factoryProcess(o));
                }
            } else {
                propList = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addPrototypeProperty(PrototypePropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        try {
            AssociationList propList = prototype.getPrototypeProperties();
            PrototypeProperty ptp = (PrototypeProperty)property.getRepositoryEntity();
            propList.add(ptp);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removePrototypeProperty(PrototypePropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        try {
            AssociationList propList = prototype.getPrototypeProperties();
            PrototypeProperty ptp = (PrototypeProperty)property.getRepositoryEntity();
            propList.remove(ptp);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getAssociations() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList assList = prototype.getAssociations();
            if (assList.size() > 0) {
                results = new ArrayList<MetadataInterface>(assList.size());
                for (Object o : assList) {
                    results.add(this._repository.factoryProcess(o));
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addAssociation(AssociationPropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        try {
            AssociationList assList = prototype.getAssociations();
            AssociationProperty ap = (AssociationProperty)property.getRepositoryEntity();
            assList.add(ap);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeAssociation(AssociationPropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        try {
            AssociationList assList = prototype.getAssociations();
            AssociationProperty ap = (AssociationProperty)property.getRepositoryEntity();
            assList.remove(ap);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setPrimaryPropertyGroup(PropertyGroupInterface propertyGroup) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        prototype.setPrimaryPropertyGroup((PropertyGroup)propertyGroup.getRepositoryEntity());
    }

    @Override
    public PropertyGroupInterface getPrimaryPropertyGroup() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Prototype prototype = (Prototype)this._repositoryObject;
        try {
            PropertyGroup pg = prototype.getPrimaryPropertyGroup();
            return (PropertyGroupInterface)this._repository.factoryProcess(pg);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

