/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.impl.PropertyGroupImpl;
import com.sas.metadata.remote.impl.PropertyGroupImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.AbstractPropertyInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PortalProperties;
import com.sas.services.information.metadata.PropertyGroupInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRPropertyGroup
extends Metadata
implements PropertyGroupInterface {
    private static final long serialVersionUID = 420975398825669061L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRPropertyGroup() throws RemoteException {
        super(OMRPropertyGroup.class);
    }

    public OMRPropertyGroup(PropertyGroup o) throws RemoteException {
        super(o, OMRPropertyGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPropertyGroup(PropertyGroupImpl o) throws RemoteException {
        super(o, OMRPropertyGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPropertyGroup(PropertyGroupImpl_Stub o) throws RemoteException {
        super(o, OMRPropertyGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPropertyGroup(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRPropertyGroup.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                PropertyGroup pgroup = (PropertyGroup)omirepository.createMetadata(name, "PropertyGroup");
                pgroup.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = pgroup;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    pgroup.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPropertyGroup", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "PropertyGroup";
    }

    @Override
    public boolean isVisible() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        int value = pgroup.getIsVisible();
        return value != 0;
    }

    @Override
    public void setIsVisible(boolean isVisible) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        int value = isVisible ? 1 : 0;
        pgroup.setIsVisible(value);
    }

    @Override
    public int getMinimum() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        return pgroup.getMinimum();
    }

    @Override
    public void setMinimum(int minimum) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        pgroup.setMinimum(minimum);
    }

    @Override
    public int getMaximum() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        return pgroup.getMaximum();
    }

    @Override
    public void setMaximum(int maximum) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        pgroup.setMaximum(maximum);
    }

    @Override
    public List getSubpropertyGroups() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList subs = pgroup.getSubpropertyGroups();
            if (subs.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            results = new ArrayList<MetadataInterface>(subs.size());
            Iterator it = subs.iterator();
            while (it.hasNext()) {
                results.add(this._repository.factoryProcess(it.next()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addSubpropertyGroup(PropertyGroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getSubpropertyGroups();
            subs.add(group.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeSubpropertyGroup(PropertyGroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getSubpropertyGroups();
            subs.remove(group.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setSubpropertyGroups(List groups) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getSubpropertyGroups();
            subs.clear();
            for (PropertyGroupInterface group : groups) {
                subs.add(group.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getCustomizers() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList subs = pgroup.getCustomizers();
            if (subs.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            results = new ArrayList<MetadataInterface>(subs.size());
            Iterator it = subs.iterator();
            while (it.hasNext()) {
                results.add(this._repository.factoryProcess(it.next()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addCustomizer(SoftwareComponentInterface softcom) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getCustomizers();
            subs.add(softcom.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeCustomizer(SoftwareComponentInterface softcom) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getCustomizers();
            subs.remove(softcom.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setCustomizers(List softcoms) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getCustomizers();
            subs.clear();
            for (SoftwareComponentInterface group : softcoms) {
                subs.add(group.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getGroupedProperties() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList subs = pgroup.getGroupedProperties();
            if (subs.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            results = new ArrayList<MetadataInterface>(subs.size());
            Iterator it = subs.iterator();
            while (it.hasNext()) {
                results.add(this._repository.factoryProcess(it.next()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addGroupedProperty(AbstractPropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getGroupedProperties();
            subs.add(property.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeGroupedProperty(AbstractPropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getGroupedProperties();
            subs.remove(property.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setGroupedProperties(List properties) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            AssociationList subs = pgroup.getGroupedProperties();
            subs.clear();
            for (PropertyInterface group : properties) {
                subs.add(group.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public PortalProperties getPortalProperties() throws ServiceException, RemoteException {
        PortalProperties result = null;
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PropertyGroup pgroup = (PropertyGroup)this._repositoryObject;
        try {
            MetadataInterface mi = null;
            pgroup.setIdState(32);
            AssociationList list = pgroup.getGroupedProperties(false);
            ArrayList<MetadataInterface> gpropList = new ArrayList<MetadataInterface>(list.size());
            for (Object o : list) {
                mi = this._repository.factoryProcess(o);
                gpropList.add(mi);
            }
            list = pgroup.getCustomizers(false);
            ArrayList<MetadataInterface> custList = new ArrayList<MetadataInterface>(list.size());
            for (Object o : list) {
                mi = this._repository.factoryProcess(o);
                custList.add(mi);
            }
            list = pgroup.getProperties(false);
            ArrayList<MetadataInterface> propList = new ArrayList<MetadataInterface>(list.size());
            for (Object o : list) {
                mi = this._repository.factoryProcess(o);
                propList.add(mi);
            }
            result = new PortalProperties(gpropList, custList, propList);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }
}

