/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.UniqueKey;
import com.sas.metadata.remote.impl.PhysicalTableImpl;
import com.sas.metadata.remote.impl.PhysicalTableImpl_Stub;
import com.sas.metadata.remote.impl.RelationalTableImpl;
import com.sas.prompts.definitions.BaseFileDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.IndexInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.information.metadata.OMRIndex;
import com.sas.services.information.metadata.OMRRelationalTable;
import com.sas.services.information.metadata.PhysicalTableAttributes;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.SmartUtils;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.ProcessStatus;
import com.sas.services.util.UpgradeInterface;
import com.sas.services.util.XMLUtil;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

@SASScope
public class OMRPhysicalTable
extends OMRRelationalTable
implements PhysicalTableInterface,
SubstitutionProperties,
LocalizableProperties,
UpgradeInterface {
    private static final long serialVersionUID = -7591433379231338232L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion FAILED_UPGRADE_VERSION = new UsageVersion(0, 5);

    protected OMRPhysicalTable(Class c) throws RemoteException {
        super(c);
    }

    public OMRPhysicalTable() throws RemoteException {
        this(OMRPhysicalTable.class);
    }

    protected OMRPhysicalTable(PhysicalTable o, Class c) throws RemoteException {
        super((RelationalTable)o, c);
    }

    public OMRPhysicalTable(PhysicalTable o) throws RemoteException {
        this(o, OMRPhysicalTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRPhysicalTable(PhysicalTableImpl o, Class c) throws RemoteException {
        super((RelationalTableImpl)o, c);
    }

    public OMRPhysicalTable(PhysicalTableImpl o) throws RemoteException {
        this(o, OMRPhysicalTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRPhysicalTable(PhysicalTableImpl_Stub o, Class c) throws RemoteException {
        super((RelationalTable)o, c);
    }

    public OMRPhysicalTable(PhysicalTableImpl_Stub o) throws RemoteException {
        this(o, OMRPhysicalTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPhysicalTable(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRPhysicalTable.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                PhysicalTable physicalTable = (PhysicalTable)omirepository.createMetadata(name, "PhysicalTable");
                physicalTable.setPublicType("Table");
                physicalTable.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = physicalTable;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    physicalTable.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPhysicalTable", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        PrimaryType pt;
        String ptype;
        if (this._repositoryObject != null && (ptype = (pt = (PrimaryType)this._repositoryObject).getPublicType()) != null && ptype.trim().length() > 0) {
            return pt.getPublicType();
        }
        return "Table";
    }

    @Override
    public IndexInterface addIndex(String name, List<ColumnInterface> listColumn) throws RemoteException, ServiceException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        OMRIndex smartIndex = null;
        PhysicalTable physicalTable = (PhysicalTable)this.getRepositoryEntity();
        try {
            if (listColumn.size() == 1) {
                return this.addSimpleIndex(listColumn.get(0));
            }
            SmartUtils.validateDuplicates(listColumn);
            SmartUtils.validateDuplicates(name, this.getIndexes());
            smartIndex = new OMRIndex(this.getRepository(), name, null);
            smartIndex.addColumns(listColumn);
            Index i = (Index)smartIndex.getRepositoryEntity();
            physicalTable.getIndexes().add((Object)i);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return smartIndex;
    }

    @Override
    public IndexInterface addSimpleIndex(ColumnInterface column) throws RemoteException, ServiceException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        OMRIndex smartIndex = null;
        PhysicalTable physicalTable = (PhysicalTable)this.getRepositoryEntity();
        try {
            SmartUtils.validateDuplicates(column.getName(), this.getIndexes());
            smartIndex = new OMRIndex(this.getRepository(), column.getName(), null);
            smartIndex.addColumn(column);
            Index i = (Index)smartIndex.getRepositoryEntity();
            physicalTable.getIndexes().add((Object)i);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return smartIndex;
    }

    @Override
    public List<IndexInterface> getIndexes() throws RemoteException, ServiceException {
        ArrayList<IndexInterface> listIndexes = null;
        MetadataInterface mi = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        PhysicalTable physicalTable = (PhysicalTable)this.getRepositoryEntity();
        try {
            AssociationList alIndex = physicalTable.getIndexes();
            listIndexes = new ArrayList<IndexInterface>(alIndex.size());
            Iterator iterIndexes = alIndex.iterator();
            while (iterIndexes.hasNext()) {
                mi = this._repository.factoryProcess(iterIndexes.next());
                if (!(mi instanceof IndexInterface)) continue;
                listIndexes.add((IndexInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listIndexes;
    }

    @Override
    public void removeIndex(IndexInterface index) throws RemoteException, ServiceException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        PhysicalTable physicalTable = (PhysicalTable)this.getRepositoryEntity();
        try {
            Index i = (Index)index.getRepositoryEntity();
            if (index.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRPhysicalTable.removeIndex.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            physicalTable.getIndexes().remove((Object)i);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public PhysicalTableAttributes getPhysicalTableAttributes() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        PhysicalTable pt = (PhysicalTable)this._repositoryObject;
        boolean isCompressed = pt.getIsCompressed() != 0;
        boolean isEncrypted = pt.getIsEncrypted() != 0;
        boolean isDBMSView = pt.getIsDBMSView() != 0;
        String dbmsType = pt.getDBMSType();
        String sasTableName = pt.getSASTableName();
        String memberType = pt.getMemberType();
        PhysicalTableAttributes result = new PhysicalTableAttributes(isCompressed, isEncrypted, isDBMSView, dbmsType, sasTableName, memberType);
        return result;
    }

    @Override
    public void setPhysicalTableAttributes(PhysicalTableAttributes attributes) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        PhysicalTable pt = (PhysicalTable)this._repositoryObject;
        pt.setIsCompressed(attributes.isCompressed() ? 1 : 0);
        pt.setIsEncrypted(attributes.isEncrypted() ? 1 : 0);
        pt.setIsDBMSView(attributes.isDBMSView() ? 1 : 0);
        pt.setDBMSType(attributes.getDbmsType());
        pt.setSASTableName(attributes.getSasTableName());
        pt.setMemberType(attributes.getMemberType());
    }

    @Override
    public List getColumns() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        PhysicalTable group = (PhysicalTable)this._repositoryObject;
        try {
            AssociationList columnList = group.getColumns();
            ArrayList<MetadataInterface> list = new ArrayList<MetadataInterface>(columnList.size());
            if (columnList != null) {
                Iterator e = columnList.iterator();
                while (e.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(e.next());
                    list.add(mi);
                }
            }
            return list;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public SASLibraryInterface getLibrary() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        PhysicalTable table = (PhysicalTable)this._repositoryObject;
        try {
            DatabaseSchema schema;
            AssociationList list;
            SASLibrary library = null;
            RelationalSchema tablePackage = table.getTablePackage();
            if (tablePackage instanceof SASLibrary) {
                library = (SASLibrary)tablePackage;
            } else if (tablePackage instanceof DatabaseSchema && (list = (schema = (DatabaseSchema)tablePackage).getUsedByPackages()) != null && list.size() > 0) {
                try {
                    library = (SASLibrary)list.get(0);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (library == null) {
                return null;
            }
            return (SASLibraryInterface)this._repository.factoryProcess(library);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    public PropertyList getLocalizableProperties() {
        if (!this._isCompatible) {
            return null;
        }
        PropertyList list = null;
        try {
            list = this.getDefaultLocalizableProperties();
            Iterator iter = this.getColumns().iterator();
            int idx = 1;
            while (iter.hasNext()) {
                MetadataInterface column = (MetadataInterface)iter.next();
                if (column instanceof OMRColumn) {
                    PropertyList columnProperties = ((OMRColumn)column).getLocalizableProperties();
                    list.addProperty("Column", idx, columnProperties);
                }
                ++idx;
            }
            List prompts = this.getPrompts();
            if (prompts.size() > 0) {
                list.addBlankLine();
                list.addComment("Prompts");
            }
            for (int i = 0; i < prompts.size(); ++i) {
                OMRPromptGroupInterface promptGroup;
                PromptGroupInterface promptGroupI;
                BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)prompts.get(i);
                if (!(prompt instanceof OMRPromptGroupInterface) || !((promptGroupI = (promptGroup = (OMRPromptGroupInterface)prompt).getPromptGroup()) instanceof LocalizableProperties)) continue;
                list.addProperty("Prompts[" + i + "]", ((LocalizableProperties)promptGroupI).getLocalizableProperties());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) {
        if (!this._isCompatible) {
            return;
        }
        try {
            this.setDefaultLocalizableProperties(map);
            Iterator iter = this.getColumns().iterator();
            int idx = 1;
            while (iter.hasNext()) {
                MetadataInterface column = (MetadataInterface)iter.next();
                if (column instanceof OMRColumn && map.containsIndexedNestedProperty("Column", idx)) {
                    ((OMRColumn)column).setLocalizableProperties(map.getNestedProperties("Column", idx));
                }
                ++idx;
            }
            List prompts = this.getPrompts();
            for (int i = 0; i < prompts.size(); ++i) {
                OMRPromptGroupInterface promptGroup;
                PromptGroupInterface promptGroupI;
                BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)prompts.get(0);
                if (!(prompt instanceof OMRPromptGroupInterface) || !((promptGroupI = (promptGroup = (OMRPromptGroupInterface)prompt).getPromptGroup()) instanceof LocalizableProperties)) continue;
                ((LocalizableProperties)promptGroupI).setLocalizableProperties(map.getNestedProperties("Prompts[" + i + "]"));
                PromptsPersistUtil.updateGroupSmartObject(promptGroupI, this.getRepository().getUserContext(), promptGroup, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PropertyList getSubstitutionProperties() {
        PropertyList props = new PropertyList();
        try {
            List prompts = this.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                OMRPromptDefinitionInterface smartPromptDef;
                PromptDefinitionInterface promptDef;
                if (prompt instanceof OMRPromptDefinitionInterface && (promptDef = (smartPromptDef = (OMRPromptDefinitionInterface)prompt).getPromptDefinition()) instanceof BaseFileDefinition) {
                    BaseFileDefinition promptFileDef = (BaseFileDefinition)promptDef;
                    PropertyList pdefProps = promptFileDef.getSubstitutionProperties();
                    props.addProperty(promptFileDef.getPromptName(), pdefProps);
                }
                if (!(prompt instanceof OMRPromptGroupInterface)) continue;
                OMRPromptGroupInterface promptGroup = (OMRPromptGroupInterface)prompt;
                PromptGroupInterface promptGroupI = promptGroup.getPromptGroup();
                List promptDefs = promptGroupI.getPromptDefinitions(true);
                for (PromptDefinitionInterface promptDef2 : promptDefs) {
                    if (!(promptDef2 instanceof SubstitutionProperties)) continue;
                    SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef2;
                    PropertyList pdefProps = promptFileDef.getSubstitutionProperties();
                    props.addProperty(promptDef2.getPromptName(), pdefProps);
                }
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt substitution information", this.getClass().getName(), (Throwable)((Object)e));
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return props;
    }

    public void setSubstitutionProperties(PropertyMap map) {
        try {
            List prompts = this.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                OMRPromptDefinitionInterface smartPromptDef;
                PromptDefinitionInterface promptDef;
                if (!(prompt instanceof OMRPromptDefinitionInterface) || !((promptDef = (smartPromptDef = (OMRPromptDefinitionInterface)prompt).getPromptDefinition()) instanceof SubstitutionProperties)) continue;
                SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef;
                promptFileDef.setSubstitutionProperties(map);
                prompt.update();
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error setting prompt substitution information", this.getClass().getName(), (Throwable)((Object)e));
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this._repositoryObject != null && this._repositoryObject instanceof PhysicalTable) {
            if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), CURRENT_VERSION)) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            PhysicalTable jomaTableObject = (PhysicalTable)this._repositoryObject;
            ProcessStatus status = new ProcessStatus(LogManager.getLogger((String)"com.sas.services.information.metadata"), ProcessStatus.generateLoggingName((CMetadata)jomaTableObject));
            try {
                Object returnValue;
                Method methodConverter;
                Object classObject;
                Class[] parameters;
                Constructor<?> classConstructor;
                this.prepareTableMigration(jomaTableObject);
                MdObjectStore store = (MdObjectStore)jomaTableObject.getObjectStore();
                PhysicalTable table = this.getTableMetadataObject(store, jomaTableObject.getCMetadataType(), jomaTableObject.getId());
                this.ensureLibraryAndFolder();
                String convertClassName = "com.sas.wadmin.prompts.conversion.DISEntityConverter";
                Class<?> loadedClass = Class.forName(convertClassName, true, this.getClass().getClassLoader());
                if (loadedClass != null && (classConstructor = loadedClass.getConstructor(parameters = new Class[]{MdObjectStore.class, Root.class, UserContextInterface.class})) != null && (classObject = classConstructor.newInstance(store, table, this.getRepository().getUserContext())) != null && (methodConverter = classObject.getClass().getMethod("convert2Prompt", Boolean.TYPE, Boolean.TYPE)) != null && (returnValue = methodConverter.invoke(classObject, Boolean.FALSE, Boolean.TRUE)) != null && returnValue instanceof PromptGroupInterface) {
                    PromptGroupInterface prompt = (PromptGroupInterface)returnValue;
                    String message = Message.format((String)RB.getStringResource("OMRPhysicalTable.CreatedNewPrompt.fmt.txt"), (Object[])new Object[]{prompt, this.getName()});
                    this.logMessage(Level.INFO, message);
                    status.addInfo(message);
                }
                this.fixTablePackageAssignment(table);
                if (!table.getPublicType().equals("Table")) {
                    table.setPublicType("Table");
                }
                if (table.getUsageVersion() < CURRENT_VERSION.encode()) {
                    table.setUsageVersion(CURRENT_VERSION.encode());
                }
                AssociationList columns = table.getColumns();
                ArrayList<String> lSASColumnNames = new ArrayList<String>();
                ArrayList<Column> lColumns = new ArrayList<Column>();
                for (Column column : columns) {
                    String sasColName;
                    if (!column.getPublicType().equals("Column")) {
                        column.setPublicType("Column");
                    }
                    if (column.getUsageVersion() < OMRColumn.CURRENT_VERSION.encode()) {
                        column.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                    }
                    if ((sasColName = column.getSASColumnName()) == null || sasColName.length() == 0) {
                        lColumns.add(column);
                        continue;
                    }
                    lSASColumnNames.add(sasColName);
                }
                this.fixSASColumnNames(status, lColumns, lSASColumnNames);
                AssociationList indexes = table.getIndexes();
                ArrayList<Index> toDeleteIndexes = new ArrayList<Index>();
                for (Index index : indexes) {
                    AssociationList indexCols = index.getColumns();
                    if (indexCols.size() != 0) continue;
                    toDeleteIndexes.add(index);
                }
                for (Index index : toDeleteIndexes) {
                    String message = Message.format((String)RB.getStringResource("OMRPhysicalTable.DeleteIndexNoCols.fmt.txt"), (Object[])new Object[]{index.getName(), this.getName()});
                    this.logMessage(Level.WARN, message);
                    status.addWarning(message);
                    index.delete();
                }
                this.cleanUpKeys(status, table);
                table.updateMetadataAll();
            }
            catch (SecurityException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            catch (InvocationTargetException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            catch (ClassNotFoundException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            catch (NoSuchMethodException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            catch (IllegalArgumentException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            catch (InstantiationException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            catch (MdException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)jomaTableObject), e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException(e, e.getLocalizedMessage());
            }
            finally {
                ProcessStatus globalStatus = ProcessStatus.getGlobalStatus();
                if (globalStatus != null) {
                    globalStatus.addStatus(status);
                } else {
                    status.logStatus();
                }
            }
        }
    }

    private void fixTablePackageAssignment(PhysicalTable table) throws RemoteException, MdException {
        RelationalSchema lib = table.getTablePackage();
        if (lib != null) {
            AssociationList usgpkgs = lib.getUsingPackages();
            DatabaseSchema schema = null;
            Iterator usgPkgIter = usgpkgs.iterator();
            while (usgPkgIter.hasNext() && schema == null) {
                DeployedDataPackage dpkg = (DeployedDataPackage)usgPkgIter.next();
                if (!(dpkg instanceof DatabaseSchema)) continue;
                schema = (DatabaseSchema)dpkg;
            }
            if (schema != null) {
                table.getTablePackages().clear();
                table.getTablePackages().add(schema);
            }
        }
        table.updateMetadataAll();
    }

    private void cleanUpKeys(ProcessStatus status, PhysicalTable table) throws RemoteException, ServiceException, MdException {
        ArrayList<ForeignKey> keysToRemove = new ArrayList<ForeignKey>();
        AssociationList foreignKeys = table.getForeignKeys();
        ArrayList<ForeignKey> usedKeys = new ArrayList<ForeignKey>();
        for (ForeignKey fkey : foreignKeys) {
            UniqueKey ukey = fkey.getPartnerUniqueKey();
            if (ukey == null) {
                keysToRemove.add(fkey);
                continue;
            }
            if (fkey.getKeyedColumns().size() != ukey.getKeyedColumns().size()) {
                keysToRemove.add(fkey);
                this.logMessage(Level.DEBUG, "Number of columns on foreign key \"" + fkey + "\" does not match colums on unique key \"" + ukey + "\"");
                continue;
            }
            AssociationList keyedCols = fkey.getKeyedColumns();
            ArrayList<Column> unmatchedColumns = new ArrayList<Column>();
            for (Column col : keyedCols) {
                AssociationList fkassocs = col.getForeignKeyAssociations();
                if (fkassocs.size() != 0) continue;
                unmatchedColumns.add(col);
            }
            for (Column col : unmatchedColumns) {
                Column uKeyedCol;
                AssociationList keyedColumns = ukey.getKeyedColumns();
                boolean match = false;
                Column matchedCol = null;
                Iterator ukeyedColIter = keyedColumns.iterator();
                while (ukeyedColIter.hasNext() && !match) {
                    uKeyedCol = (Column)ukeyedColIter.next();
                    if (!uKeyedCol.getSASColumnName().equals(col.getSASColumnName())) continue;
                    matchedCol = uKeyedCol;
                    match = true;
                }
                if (!match) {
                    int fkIndex = keyedCols.indexOf(col);
                    if (keyedColumns.size() > fkIndex) {
                        uKeyedCol = (Column)keyedColumns.get(fkIndex);
                        match = true;
                        matchedCol = uKeyedCol;
                    }
                }
                if (match && matchedCol != null) {
                    KeyAssociation ka = (KeyAssociation)col.getObjectStore().getFactory().createComplexMetadataObject((MdObjectStore)col.getObjectStore(), fkey.getName(), "KeyAssociation", col.getRepositoryID());
                    ka.setForeignKeyColumn(col);
                    ka.setOwningForeignKey(fkey);
                    ka.setUniqueKeyColumn(matchedCol);
                    usedKeys.add(fkey);
                    this.logMessage(Level.WARN, Message.format((String)RB.getStringResource("OMRPhysicalTable.CreatedKeyAssoc.fmt.txt"), (Object)col, (Object)matchedCol, (Object)this.getPathUrl().getDisplayPath()));
                }
                if (match) continue;
                keysToRemove.add(fkey);
                this.logMessage(Level.DEBUG, "No matching keys were found from key \"" + fkey + "\" on column \"" + col + "\"");
            }
        }
        for (ForeignKey fk : keysToRemove) {
            if (usedKeys.contains(fk)) continue;
            String msg = Message.format((String)RB.getStringResource("OMRPhysicalTable.RemovingForeignKey.fmt.txt"), (Object)fk.getName(), (Object)this.getPathUrl().getDisplayPath());
            this.logMessage(Level.WARN, msg);
            foreignKeys.remove(fk);
            fk.delete();
            status.addWarning(msg);
        }
        table.updateMetadataAll();
    }

    private void prepareTableMigration(PhysicalTable jomaTableObject) throws RemoteException, MdException {
        PhysicalTable table = this.getTableMetadataObject((MdObjectStore)jomaTableObject.getObjectStore(), jomaTableObject.getCMetadataType(), jomaTableObject.getId());
        if (!table.getPublicType().equals("Table")) {
            table.setPublicType("Table");
        }
        if (table.getUsageVersion() < FAILED_UPGRADE_VERSION.encode()) {
            table.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
        }
        AssociationList columns = table.getColumns();
        for (Column column : columns) {
            if (!column.getPublicType().equals("Column")) {
                column.setPublicType("Column");
            }
            if (!(column.getUsageVersion() < FAILED_UPGRADE_VERSION.encode())) continue;
            column.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
        }
        table.updateMetadataAll();
    }

    private void ensureLibraryAndFolder() throws ServiceException, RemoteException {
        FolderInterface targetFolder = this.getParent();
        SASLibraryInterface library = this.getLibrary();
        if (targetFolder != null && FolderUtil.isDIStudioUngroupedFolder(targetFolder) && !FolderUtil.isInProjectRepository(this, targetFolder)) {
            targetFolder = null;
        }
        if (targetFolder == null) {
            if (library == null) {
                targetFolder = FolderUtil.makeOrphanedTablesFolder(this);
                if (targetFolder != null) {
                    targetFolder.moveMembersOnOverflow();
                }
            } else if (this.getReposId().substring(0, 8).equals(library.getReposId().substring(0, 8))) {
                targetFolder = library.getParent();
            }
            if (targetFolder == null) {
                String folderName = Names.mapNameToOMRObjectName(library.getName());
                FolderInterface sharedData = FolderUtil.makeSharedDataFolder(this);
                targetFolder = sharedData.getSubfolder(folderName);
                if (targetFolder == null) {
                    targetFolder = sharedData.makeSubfolder(folderName);
                }
            }
        }
        TableNameConstraint constraint = null;
        if (library != null) {
            constraint = new TableNameConstraint(this, library);
        }
        this.validateNameAndFolder(targetFolder, constraint);
        this.update();
    }

    private PhysicalTable getTableMetadataObject(MdObjectStore store, String type, String fqid) throws MdException, RemoteException {
        String template = "<Templates><PhysicalTable><Columns/><Documents/><Notes/><ResponsibleParties/><PropertySets/></PhysicalTable><Column><Documents/><Notes/></Column><PropertySet><Properties/></PropertySet></Templates>";
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return (PhysicalTable)object;
    }

    private void fixSASColumnNames(ProcessStatus status, List lColumns, List lUniqueSASColumnNames) throws RemoteException, MdException {
        for (Column column : lColumns) {
            PhysicalTable pTable;
            RelationalSchema lib;
            String metaName = column.getName();
            String newSASColumnName = null;
            try {
                if (metaName != null && metaName.length() > 0) {
                    newSASColumnName = Names.mapNameToSASVariableName(metaName, lUniqueSASColumnNames);
                } else {
                    String tName = Names.generateName(32);
                    newSASColumnName = Names.mapNameToSASVariableName(tName, lUniqueSASColumnNames);
                }
            }
            catch (IllegalArgumentException e) {
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
            }
            lUniqueSASColumnNames.add(newSASColumnName);
            String oldName = column.getSASColumnName();
            String message = Message.format((String)RB.getStringResource("OMRPhysicalTable.SetSASColumnName.fmt.txt"), (Object[])new Object[]{column.getName(), oldName, newSASColumnName, this.getName()});
            this.logMessage(Level.WARN, message);
            DataTable table = column.getTable();
            status.addWarning(ProcessStatus.generateLoggingName((CMetadata)table), message);
            column.setSASColumnName(newSASColumnName);
            if (!(table instanceof PhysicalTable) || !((lib = (pTable = (PhysicalTable)table).getTablePackage()) instanceof SASLibrary)) continue;
            AssociationList indexes = column.getIndexes();
            for (Index index : indexes) {
                if (index.getColumns().size() != 1 || !column.equals(index.getColumns().get(0))) continue;
                String indexOldName = index.getName();
                index.setName(newSASColumnName);
                String indexMessage = Message.format((String)RB.getStringResource("OMRPhysicalTable.SetIndexName.fmt.txt"), (Object[])new Object[]{indexOldName, index.getName(), this.getName()});
                this.logMessage(Level.WARN, indexMessage);
                status.addWarning(ProcessStatus.generateLoggingName((CMetadata)pTable), indexMessage);
            }
        }
    }

    @SASScope
    private class TableNameConstraint
    implements MetadataNameConstraint {
        OMRPhysicalTable _table;
        MetadataServerInterface _server;
        Filter _filter;
        RelationalSchema _queryLibrary;
        String _queryLibraryId;
        String _schemaType;

        TableNameConstraint(OMRPhysicalTable table, SASLibraryInterface library) throws ServiceException, RemoteException {
            this._table = table;
            try {
                Object libraryObj = library.getRepositoryEntity();
                if (libraryObj instanceof SASLibrary) {
                    Object obj;
                    SASLibrary jomaLibrary = (SASLibrary)libraryObj;
                    this._queryLibrary = jomaLibrary;
                    AssociationList packages = jomaLibrary.getUsingPackages();
                    if (packages != null && packages.size() == 1 && (obj = packages.get(0)) instanceof RelationalSchema) {
                        this._queryLibrary = (RelationalSchema)packages.get(0);
                    }
                    this._queryLibraryId = this._queryLibrary.getId();
                    this._schemaType = this._queryLibrary.getCMetadataType();
                    this._filter = new Filter();
                    this._filter.setType("PhysicalTable");
                    this._filter.setOMRFlags(16384);
                    this._server = (MetadataServerInterface)table.getRepository().getServer();
                }
            }
            catch (MdException me) {
                throw new ServiceException(me);
            }
        }

        @Override
        public boolean isNameValid(MetadataInterface object, String name) throws ServiceException, RemoteException {
            StringBuffer sb = new StringBuffer();
            sb.append("<XMLSelect search=\"*[@Name='");
            sb.append(XMLUtil.normalize(name));
            sb.append("'][TablePackage/");
            sb.append(this._schemaType);
            sb.append("[@Id='");
            sb.append(this._queryLibraryId);
            sb.append("']]\"/>");
            this._filter.setExplicitSearchString("omi", sb.toString());
            int count = this._server.getCountNoSecurity(this._filter, null);
            if (count == 0) {
                return true;
            }
            if (count > 1) {
                return false;
            }
            return object.getName().equals(name);
        }
    }
}

