/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Email;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Location;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdUtil;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Phone;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.EmailImpl;
import com.sas.metadata.remote.impl.IdentityImpl;
import com.sas.metadata.remote.impl.PersonImpl;
import com.sas.metadata.remote.impl.PersonImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.InternalLoginUserInfo;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.EmailInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.LocationInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRIdentity;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.PhoneNumberInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.publicobject.DetailsProcessor;
import com.sas.services.information.publicobject.ProcessorInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRPerson
extends OMRIdentity
implements PersonInterface,
Serializable {
    private static final long serialVersionUID = -5344110287400680774L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private InternalLoginUserInfo intrlLgnUsrInfo;
    private String intrlLgnPassword;
    private boolean intrlLgnDelete;

    public OMRPerson() throws RemoteException {
        super(OMRPerson.class);
        this.intrlLgnUsrInfo = null;
        this.intrlLgnPassword = null;
        this.intrlLgnDelete = false;
    }

    public OMRPerson(Person o) throws RemoteException {
        super((Identity)o, OMRPerson.class);
        this.intrlLgnUsrInfo = null;
        this.intrlLgnPassword = null;
        this.intrlLgnDelete = false;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPerson(PersonImpl o) throws RemoteException {
        super((IdentityImpl)o, OMRPerson.class);
        this.intrlLgnUsrInfo = null;
        this.intrlLgnPassword = null;
        this.intrlLgnDelete = false;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPerson(PersonImpl_Stub o) throws RemoteException {
        super((Identity)o, OMRPerson.class);
        this.intrlLgnUsrInfo = null;
        this.intrlLgnPassword = null;
        this.intrlLgnDelete = false;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPerson(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRPerson.class);
            this.intrlLgnUsrInfo = null;
            this.intrlLgnPassword = null;
            this.intrlLgnDelete = false;
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Person person = (Person)omirepository.createMetadata(name, "Person");
                person.setPublicType("User");
                person.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = person;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    person.delete();
                    throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
                }
            }
            catch (ServiceException t) {
                this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", (Throwable)((Object)t));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "User";
    }

    @Override
    public String getTitle() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        return person.getTitle();
    }

    @Override
    public void setTitle(String title) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Person person = (Person)this._repositoryObject;
        person.setTitle(title);
    }

    @Override
    public List getEmailAddresses() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        try {
            AssociationList emailList = person.getEmailAddresses(true);
            if (emailList != null) {
                ArrayList<String> list = new ArrayList<String>(emailList.size());
                for (Email nextAddress : emailList) {
                    list.add(nextAddress.getAddress());
                }
                return list;
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", ex);
        }
        return null;
    }

    @Override
    public void addEmailAddress(String address) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        try {
            MdObjectStore store = (MdObjectStore)person.getObjectStore();
            MdFactory factory = store.getFactory();
            Email em = (Email)factory.createComplexMetadataObject(store, null, person.getName() + ".email", "Email", person.getRepositoryID());
            em.setAddress(address);
            em.setEmailType("auto");
            AssociationList ass = person.getEmailAddresses();
            ass.add((Object)em);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", ex);
        }
    }

    @Override
    public void removeEmailAddress(String address) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        EmailImpl em = new EmailImpl();
        em.setAddress(address);
        try {
            AssociationList ass = person.getEmailAddresses();
            ass.remove((Object)em);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", ex);
        }
    }

    public List getEmails() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person role = (Person)this._repositoryObject;
        try {
            AssociationList emailList = role.getEmailAddresses();
            if (emailList.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(emailList.size());
            for (Email email : emailList) {
                results.add(this._repository.factoryProcess(email));
            }
            return results;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void addEmail(EmailInterface email) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        try {
            person.getEmailAddresses().add(email.getRepositoryEntity());
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", ex);
        }
    }

    @Override
    public void removeEmail(EmailInterface email) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        try {
            person.getEmailAddresses().remove(email.getRepositoryEntity());
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", ex);
        }
    }

    @Override
    public List getGroups() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        try {
            AssociationList groupList = person.getGroups(true);
            ArrayList<GroupInterface> list = new ArrayList<GroupInterface>(groupList.size());
            if (groupList != null) {
                Iterator e = groupList.iterator();
                while (e.hasNext()) {
                    GroupInterface ig = (GroupInterface)this._repository.factoryProcess(e.next());
                    list.add(ig);
                }
            }
            return list;
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", ex);
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", (Throwable)((Object)ex));
        }
        return null;
    }

    @Override
    public List getSubscribers() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = null;
        Person person = (Person)this._repositoryObject;
        try {
            AssociationList subscriberList = person.getSubscriberIdentities(true);
            results = new ArrayList<MetadataInterface>(subscriberList.size());
            for (Object o : subscriberList) {
                MetadataInterface mi = this._repository.factoryProcess(o);
                results.add(mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this._repository.refreshEntity(this);
        Person person = (Person)this._repositoryObject;
        try {
            AssociationList emails = person.getEmailAddresses(true);
            for (Email email : emails) {
                MdObjectStore store = (MdObjectStore)email.getObjectStore();
                store.refreshObjectFromServer((CMetadata)email, false, true);
            }
        }
        catch (MdException mex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", mex);
        }
    }

    @Override
    public void setRepository(RepositoryInterface repos) throws IllegalStateException, RemoteException {
        super.setRepository(repos);
    }

    @Override
    public void addLocation(LocationInterface location) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person role = (Person)this._repositoryObject;
        try {
            AssociationList locationList = role.getLocations();
            locationList.add(location.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void addPhoneNumber(PhoneNumberInterface phone) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person role = (Person)this._repositoryObject;
        try {
            AssociationList phoneList = role.getPhoneNumbers();
            phoneList.add(phone.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getLocations() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person role = (Person)this._repositoryObject;
        try {
            AssociationList locationList = role.getLocations();
            if (locationList.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(locationList.size());
            for (Location location : locationList) {
                results.add(this._repository.factoryProcess(location));
            }
            return results;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getPhoneNumbers() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person role = (Person)this._repositoryObject;
        try {
            AssociationList phoneList = role.getPhoneNumbers();
            if (phoneList.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(phoneList.size());
            for (Phone phone : phoneList) {
                results.add(this._repository.factoryProcess(phone));
            }
            return results;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeLocation(LocationInterface location) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person role = (Person)this._repositoryObject;
        try {
            AssociationList locationList = role.getLocations();
            locationList.remove(location.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removePhoneNumber(PhoneNumberInterface phone) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Person role = (Person)this._repositoryObject;
        try {
            AssociationList phoneList = role.getPhoneNumbers();
            phoneList.remove(phone.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setInternalAccountPassword(String password) throws ServiceException, RemoteException {
        try {
            this.intrlLgnPassword = SasPasswordString.encode((String)password);
            this.intrlLgnDelete = false;
        }
        catch (SasPasswordEncodingException spee) {
            throw new ServiceException(spee, spee.getMessage());
        }
    }

    @Override
    public void deleteInternalAccount() throws ServiceException, RemoteException {
        this.intrlLgnDelete = true;
    }

    @Override
    public InternalLoginUserInfo getInternalAccountOptions() throws ServiceException, RemoteException {
        if (this.intrlLgnUsrInfo == null) {
            MetadataServerInterface server = (MetadataServerInterface)this.getRepository().getServer();
            this.intrlLgnUsrInfo = server.getInternalLoginUserInfo(this.getName());
        }
        return this.intrlLgnUsrInfo;
    }

    @Override
    public void setInternalAccountOptions(InternalLoginUserInfo intrlLgnUsrInfo) throws ServiceException, RemoteException {
        if (!(intrlLgnUsrInfo instanceof InternalLoginUserInfo)) {
            throw new ServiceException("parameter is not an InternalLoginUserInfo");
        }
        this.intrlLgnUsrInfo = intrlLgnUsrInfo;
    }

    @Override
    public List<MetadataInterface> getCreatedObjects() throws ServiceException, RemoteException {
        return this.getCreatedOrModifiedObjects("Created By");
    }

    @Override
    public List<MetadataInterface> getModifiedObjects() throws ServiceException, RemoteException {
        return this.getCreatedOrModifiedObjects("Modified By");
    }

    private List<MetadataInterface> getCreatedOrModifiedObjects(String role) throws VersionIncompatibleException, RemoteException, ServiceException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        this.checkPulse(true);
        Person person = (Person)this._repositoryObject;
        try {
            ResponsibleParty responsibility = null;
            AssociationList responsibilities = person.getResponsibilities();
            for (ResponsibleParty rp : responsibilities) {
                if (!role.equalsIgnoreCase(rp.getRole())) continue;
                responsibility = rp;
                break;
            }
            if (responsibility != null) {
                AssociationList objects = responsibility.getObjects();
                for (Root object : objects) {
                    results.add(this._repository.factoryProcess(object));
                }
            }
            return results;
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws ServiceException, RemoteException {
        super.update();
        MetadataServerInterface server = (MetadataServerInterface)this.getRepository().getServer();
        Person person = (Person)this._repositoryObject;
        try {
            MdObjectStore store = (MdObjectStore)person.getObjectStore();
            MdFactory factory = store.getFactory();
            MdUtil util = factory.getUtil();
            if (this.intrlLgnDelete) {
                server.deleteInternalPassword(this.getName());
            } else {
                if (this.intrlLgnPassword != null && this.intrlLgnPassword.length() > 0) {
                    server.setInternalPassword(this.getName(), this.intrlLgnPassword);
                }
                if (this.intrlLgnUsrInfo != null) {
                    server.setInternalLoginUserOptions(this.getName(), this.intrlLgnUsrInfo.isDisabled(), this.intrlLgnUsrInfo.isBypassStrength(), this.intrlLgnUsrInfo.isBypassHistory(), this.intrlLgnUsrInfo.isUseStdPasswordExpirationDays(), this.intrlLgnUsrInfo.getPasswordExpirationDays(), this.intrlLgnUsrInfo.isBypassLockout(), this.intrlLgnUsrInfo.isBypassInactivitySuspension(), this.intrlLgnUsrInfo.isDoesAccountExpire(), this.intrlLgnUsrInfo.getAccountExpirationDate());
                }
            }
        }
        finally {
            this.intrlLgnDelete = false;
            this.intrlLgnPassword = null;
            this.intrlLgnUsrInfo = null;
        }
    }

    @Override
    public ProcessorInterface getProcessorInterface(String interfaceClassName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        ProcessorInterface returnValue = null;
        if ("com.sas.services.information.publicobject.DetailsProcessorInterface".equals(interfaceClassName)) {
            Object action = this._actionInterfaces.get(interfaceClassName);
            if (action != null && action instanceof ProcessorInterface) {
                returnValue = (ProcessorInterface)action;
            } else {
                returnValue = new UserDetailsProcessor(this);
                this.addProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface", returnValue);
            }
        } else {
            returnValue = super.getProcessorInterface(interfaceClassName);
        }
        return returnValue;
    }

    @SASScope
    protected class UserDetailsProcessor
    extends DetailsProcessor {
        public UserDetailsProcessor(PersonInterface publicObject) {
            super(publicObject);
        }

        @Override
        public String getDisplayName() throws ServiceException, RemoteException {
            return ((PersonInterface)this._publicObject).getEffectiveDisplayName();
        }
    }
}

