/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.DocumentImpl;
import com.sas.metadata.remote.impl.DocumentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.NoteInterface;
import com.sas.services.information.metadata.OMRDocument;
import com.sas.services.util.UpgradeInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRNote
extends OMRDocument
implements NoteInterface,
UpgradeInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRNote() throws RemoteException {
    }

    public OMRNote(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRNote(Document o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRNote(DocumentImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRNote(DocumentImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRNote(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            Document doc = (Document)omirepository.createMetadata(name, "Document");
            doc.setPublicType("Note");
            doc.setTextRole("Note");
            doc.setUsageVersion(CURRENT_VERSION.encode());
            doc.setURI("http://nothing");
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = doc;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                parent.addItem(this);
            }
            catch (ServiceException ex) {
                doc.delete();
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRDocument", (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        PrimaryType pt;
        String type;
        if (this._repositoryObject != null && (type = (pt = (PrimaryType)this._repositoryObject).getPublicType()) != null && type.length() > 0) {
            return type;
        }
        return "Note";
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        this.deleteTextStores();
        super.delete();
    }

    @Override
    public String getNoteText() throws ServiceException, RemoteException {
        String result = "";
        Document doc = (Document)this._repositoryObject;
        try {
            StringBuffer buf = new StringBuffer(1024);
            AssociationList noteList = doc.getNotes();
            for (TextStore ts : noteList) {
                buf.append(ts.getStoredText());
            }
            result = buf.toString();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public void setNoteText(String text) throws ServiceException, RemoteException {
        Document doc = (Document)this._repositoryObject;
        if (text == null || text.length() == 0) {
            this.deleteTextStores();
            return;
        }
        try {
            AssociationList noteList = doc.getNotes();
            if (noteList.size() == 1) {
                TextStore ts = (TextStore)noteList.get(0);
                ts.setStoredText(text);
            } else if (noteList.size() == 0) {
                TextStore ts = (TextStore)((OMIRepositoryInterface)this._repository).createMetadata("NoteText", "TextStore");
                ts.setStoredText(text);
                noteList.add(ts);
            } else {
                TextStore ts = (TextStore)noteList.get(0);
                ts.setStoredText(text);
                ArrayList list2 = new ArrayList(noteList);
                for (int i = 1; i < list2.size(); ++i) {
                    TextStore ts2 = (TextStore)list2.get(i);
                    ts2.delete();
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void deleteTextStores() throws ServiceException, RemoteException {
        Document doc = (Document)this._repositoryObject;
        try {
            ArrayList noteList = new ArrayList(doc.getNotes());
            for (TextStore ts : noteList) {
                ts.delete();
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), OMRNote.CURRENT_VERSION)) {
            throw new VersionIncompatibleException(this.getClass().getName(), OMRNote.CURRENT_VERSION, this.getUsageVersion());
        }
        jomaObject = (Document)this._repositoryObject;
        if (!jomaObject.getPublicType().equals("Note")) {
            jomaObject.setPublicType("Note");
        }
        if (jomaObject.getUsageVersion() < OMRNote.CURRENT_VERSION.encode()) {
            jomaObject.setUsageVersion(OMRNote.CURRENT_VERSION.encode());
        }
        repository = null;
        targetFolder = this.getParent();
        repository = targetFolder != null ? targetFolder.getRepository() : this._repository;
        if (targetFolder == null) {
            folderSet = false;
            docReposId = jomaObject.getFQID().substring(0, 8);
            try {
                tsList = jomaObject.getNotes();
            }
            catch (MdException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            if (tsList.size() > 0 && (ts = (TextStore)tsList.get(0)) != null) {
                try {
                    folderList = ts.getTrees();
                    if (folderList.size() > 0) {
                        tree = (Tree)folderList.get(0);
                        folder = (Folder)repository.factoryProcess(tree);
                        this.validateNameAndFolder(folder);
                        ts.getTrees().removeAllElements();
                        folderSet = true;
                    }
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
                if (!folderSet) {
                    try {
                        docObjectsList = jomaObject.getObjects();
                        for (k = 0; k < docObjectsList.size(); ++k) {
                            obj = (Root)docObjectsList.get(k);
                            objReposId = obj.getFQID().substring(0, 8);
                            if (!objReposId.equals(docReposId) || (parentFolderList = obj.getTrees()).size() <= 0 || !(folderReposId = (parentFolder = (Tree)parentFolderList.get(0)).getFQID().substring(0, 8)).equals(docReposId)) continue;
                            folder = (Folder)repository.factoryProcess(parentFolder);
                            this.validateNameAndFolder(folder);
                            folderSet = true;
                            break;
                        }
                    }
                    catch (MdException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                    if (!folderSet) {
                        notesFolder = null;
                        try {
                            notesFolder = FolderUtil.makeNotesFolder(this);
                            if (notesFolder == null) ** GOTO lbl60
                            notesFolder.moveMembersOnOverflow();
                            this.validateNameAndFolder(notesFolder);
                        }
                        catch (Exception e) {
                            throw new ServiceException(e, e.getMessage());
                        }
                    }
                }
            }
        } else {
            this.validateNameAndFolder(targetFolder);
        }
lbl60:
        // 4 sources

        try {
            jomaObject.getObjectStore().updatedMetadataAll();
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }
}

