/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.HostInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MultiHostDeployment;
import com.sas.services.information.metadata.ServerSubPropsHandler;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class OMRMultiHostDeployedObject
implements MultiHostDeployment {
    private static OMRMultiHostDeployedObject instance;
    private static SoftwareComponentInterface publicObject;
    private FolderInterface hostGroup;

    private OMRMultiHostDeployedObject() throws RemoteException, ServiceException {
        this.initHostGroup();
    }

    private void initHostGroup() throws RemoteException, ServiceException {
        List softwareTrees = publicObject.getSoftwareTrees();
        boolean present = false;
        if (softwareTrees != null) {
            present = this.initHostGroup(softwareTrees);
        }
        if (!present && ServerSubPropsHandler.isMultiHostDeployment(publicObject.getType())) {
            SoftwareComponent cmp = (SoftwareComponent)publicObject.getRepositoryEntity();
            try {
                AssociationList sTrees = cmp.getSoftwareTrees();
                OMIRepositoryInterface repos = (OMIRepositoryInterface)publicObject.getRepository();
                Tree tree = (Tree)repos.createMetadata("MachineGroup", "Tree");
                tree.setTreeType("MachineGroup");
                sTrees.add(tree);
                this.initHostGroup(publicObject.getSoftwareTrees());
            }
            catch (MdException exception) {
                throw new ServiceException(exception);
            }
        }
    }

    private boolean initHostGroup(List<FolderInterface> softwareTrees) throws RemoteException, ServiceException {
        boolean present = false;
        for (FolderInterface folder : softwareTrees) {
            if (!folder.getFolderType().equals("MachineGroup")) continue;
            this.hostGroup = folder;
            present = true;
            break;
        }
        return present;
    }

    public static MultiHostDeployment getInstance(SoftwareComponentInterface metadataObject) throws RemoteException, ServiceException {
        if (metadataObject == null) {
            throw new IllegalArgumentException("");
        }
        if (!metadataObject.equals(publicObject)) {
            publicObject = metadataObject;
            try {
                instance = new OMRMultiHostDeployedObject();
            }
            catch (ServiceException exception) {
                instance = null;
            }
        }
        return instance;
    }

    @Override
    public void addHost(HostInterface host) throws ServiceException, RemoteException {
        if (host != null && !this.isDeployedOnHost(host) && this.hostGroup != null) {
            this.hostGroup.addItem(host);
        }
    }

    @Override
    public HostInterface getAssociatedHost() throws ServiceException, RemoteException {
        HostInterface host = null;
        ServerComponent server = this.getReposServerComponent();
        if (server != null) {
            try {
                Machine machine = server.getAssociatedMachine();
                if (machine != null) {
                    host = (HostInterface)publicObject.getRepository().factoryProcess(machine);
                }
            }
            catch (MdException exception) {
                throw new ServiceException(exception);
            }
        }
        return host;
    }

    private ServerComponent getReposServerComponent() throws ServiceException, RemoteException {
        CMetadata component = (CMetadata)publicObject.getRepositoryEntity();
        ServerComponent server = null;
        Object host = null;
        if (component instanceof ServerComponent) {
            server = (ServerComponent)component;
        }
        return server;
    }

    @Override
    public List<HostInterface> getHosts() throws ServiceException, RemoteException {
        List items;
        ArrayList<HostInterface> hostGroups = null;
        if (this.hostGroup != null && (items = this.hostGroup.getChildren()) != null) {
            hostGroups = new ArrayList<HostInterface>(items.size());
            for (MetadataInterface item : items) {
                if (!(item instanceof HostInterface)) continue;
                hostGroups.add((HostInterface)item);
            }
        }
        return hostGroups;
    }

    @Override
    public PublicObjectInterface getPublicObject() throws ServiceException, RemoteException {
        return publicObject;
    }

    @Override
    public boolean isDeployedOnHost(HostInterface host) throws ServiceException, RemoteException {
        if (host == null) {
            return false;
        }
        List<HostInterface> hosts = this.getHosts();
        return hosts != null && hosts.contains(host);
    }

    @Override
    public void removeHost(HostInterface host) throws ServiceException, RemoteException {
        if (this.hostGroup != null) {
            this.hostGroup.removeItem(host);
        }
    }

    @Override
    public void setAssociatedMachine(HostInterface host) throws ServiceException, RemoteException {
        ServerComponent server = this.getReposServerComponent();
        if (server == null) {
            throw new ServiceException("");
        }
        server.setAssociatedMachine((Machine)host.getRepositoryEntity());
        try {
            server.updateMetadataAll();
        }
        catch (MdException mdException) {
            // empty catch block
        }
    }

    @Override
    public List<String> getAllHostsNames() throws ServiceException, RemoteException {
        List<HostInterface> hosts = this.getHosts();
        HashSet<String> hostNames = null;
        Object retHosts = null;
        if (hosts != null) {
            hostNames = new HashSet<String>(hosts.size() + 2);
            for (HostInterface host : hosts) {
                hostNames.add(host.getHostName());
            }
        }
        return null;
    }

    @Override
    public void addAll(List<HostInterface> host) throws ServiceException, RemoteException {
    }

    @Override
    public void removeAll() throws ServiceException, RemoteException {
        List<HostInterface> hosts = this.getHosts();
        if (hosts != null) {
            for (HostInterface host : hosts) {
                this.hostGroup.removeItem(host);
            }
        }
    }
}

