/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.impl.LogicalServerImpl;
import com.sas.metadata.remote.impl.LogicalServerImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.LogicalConnectServerInterface;
import com.sas.services.information.metadata.OMRLogicalServer;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;

@SASScope
public class OMRLogicalConnectServer
extends OMRLogicalServer
implements LogicalConnectServerInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRLogicalConnectServer() throws RemoteException {
    }

    public OMRLogicalConnectServer(LogicalServer o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogicalConnectServer(LogicalServerImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogicalConnectServer(LogicalServerImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogicalConnectServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                LogicalServer ls = (LogicalServer)omirepository.createMetadata(name, "LogicalServer");
                ls.setUsageVersion(CURRENT_VERSION.encode());
                ls.setClassIdentifier("028e4060-d545-11d5-880d-aa0004006d06");
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = ls;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    ls.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException((Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        LogicalServer server;
        if (this._repositoryObject != null && (server = (LogicalServer)this._repositoryObject).getPublicType() != null && server.getPublicType().length() > 0) {
            return server.getPublicType();
        }
        return "LogicalServer.Connect";
    }
}

