/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FtpServerInterface;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRFtpServer
extends OMRServerComponent
implements FtpServerInterface {
    private static final long serialVersionUID = -5796600201774531223L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRFtpServer() throws RemoteException {
        super(OMRFtpServer.class);
    }

    public OMRFtpServer(ServerComponentImpl o) throws RemoteException {
        super(o, OMRFtpServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRFtpServer(ServerComponentImpl_Stub o) throws RemoteException {
        super(o, OMRFtpServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRFtpServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRFtpServer.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            ServerComponent dc = (ServerComponent)omirepository.createMetadata(name, "ServerComponent");
            dc.setClassIdentifier("CBA26437-1577-4FF8-93F6-9B68B4DD8D2E");
            dc.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = dc;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                if (parent != null) {
                    parent.addItem(this);
                }
            }
            catch (Exception ex) {
                dc.delete();
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Server.Ftp";
    }

    @Override
    public String getUrl() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String result = "";
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getProperties();
            for (Property prop : ass) {
                String name = prop.getPropertyName();
                if (name == null) {
                    name = prop.getName();
                }
                if (!name.equalsIgnoreCase("URL")) continue;
                return prop.getDefaultValue();
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHttpServer", ex);
        }
        return result;
    }
}

