/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.KeyAssociationImpl;
import com.sas.metadata.remote.impl.KeyAssociationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.ForeignKeyInterface;
import com.sas.services.information.metadata.KeyAssociationInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalKeyInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRForeignKeyAssociation
extends Metadata
implements KeyAssociationInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRForeignKeyAssociation() throws RemoteException {
        this(OMRForeignKeyAssociation.class);
    }

    protected OMRForeignKeyAssociation(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRForeignKeyAssociation(KeyAssociation keyAssociation) throws RemoteException {
        this(keyAssociation, OMRForeignKeyAssociation.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRForeignKeyAssociation(KeyAssociation keyAssociation, Class theClass) throws RemoteException {
        super(keyAssociation, theClass);
    }

    public OMRForeignKeyAssociation(KeyAssociationImpl keyAssociation) throws RemoteException {
        this(keyAssociation, OMRForeignKeyAssociation.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRForeignKeyAssociation(KeyAssociationImpl keyAssociation, Class theClass) throws RemoteException {
        super(keyAssociation, theClass);
    }

    public OMRForeignKeyAssociation(KeyAssociationImpl_Stub keyAssociation) throws RemoteException {
        this(keyAssociation, OMRForeignKeyAssociation.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRForeignKeyAssociation(KeyAssociationImpl_Stub keyAssociation, Class theClass) throws RemoteException {
        super(keyAssociation, theClass);
    }

    public OMRForeignKeyAssociation(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRForeignKeyAssociation.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                KeyAssociation keyAssociation = (KeyAssociation)omirepository.createMetadata(name, "KeyAssociation");
                keyAssociation.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = keyAssociation;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    keyAssociation.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRForeignKeyAssociation", t);
            }
        }
    }

    @Override
    public ColumnInterface getForeignKeyColumn() throws ServiceException, RemoteException {
        return this.getRelationalColumn(RelationalKeyInterface.KeyType.FOREIGN);
    }

    @Override
    public ColumnInterface getUniqueKeyColumn() throws ServiceException, RemoteException {
        return this.getRelationalColumn(RelationalKeyInterface.KeyType.UNIQUE);
    }

    @Override
    public void setForeignKeyColumn(ColumnInterface column) throws ServiceException, RemoteException {
        this.setRelationalKeyColumn(column, RelationalKeyInterface.KeyType.FOREIGN);
    }

    @Override
    public void setUniqueKeyColumn(ColumnInterface column) throws ServiceException, RemoteException {
        this.setRelationalKeyColumn(column, RelationalKeyInterface.KeyType.UNIQUE);
    }

    @Override
    public ForeignKeyInterface getOwningForeignKey() throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        KeyAssociation keyAssociation = (KeyAssociation)this.getRepositoryEntity();
        try {
            mi = this._repository.factoryProcess(keyAssociation.getOwningForeignKey());
            if (mi instanceof ForeignKeyInterface) {
                return (ForeignKeyInterface)mi;
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return null;
    }

    private ColumnInterface getRelationalColumn(RelationalKeyInterface.KeyType keyType) throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        KeyAssociation keyAssociation = (KeyAssociation)this.getRepositoryEntity();
        try {
            switch (keyType) {
                case UNIQUE: {
                    mi = this._repository.factoryProcess(keyAssociation.getUniqueKeyColumn());
                    break;
                }
                case FOREIGN: {
                    mi = this._repository.factoryProcess(keyAssociation.getForeignKeyColumn());
                }
            }
            if (mi instanceof ColumnInterface) {
                return (ColumnInterface)mi;
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return null;
    }

    private void setRelationalKeyColumn(ColumnInterface column, RelationalKeyInterface.KeyType keyType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        KeyAssociation keyAssociation = (KeyAssociation)this.getRepositoryEntity();
        try {
            Column c = (Column)column.getRepositoryEntity();
            switch (keyType) {
                case UNIQUE: {
                    keyAssociation.setUniqueKeyColumn(c);
                    break;
                }
                case FOREIGN: {
                    keyAssociation.setForeignKeyColumn(c);
                }
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

