/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.ForeignKeyImpl;
import com.sas.metadata.remote.impl.ForeignKeyImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.ForeignKeyInterface;
import com.sas.services.information.metadata.KeyAssociationInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalKeyInterface;
import com.sas.services.information.metadata.SmartUtils;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRForeignKey
extends Metadata
implements ForeignKeyInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRForeignKey() throws RemoteException {
        this(OMRForeignKey.class);
    }

    protected OMRForeignKey(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRForeignKey(ForeignKey fkey) throws RemoteException {
        this(fkey, OMRForeignKey.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRForeignKey(ForeignKey fkey, Class theClass) throws RemoteException {
        super(fkey, theClass);
    }

    public OMRForeignKey(ForeignKeyImpl fkey) throws RemoteException {
        this(fkey, OMRForeignKey.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRForeignKey(ForeignKeyImpl fkey, Class theClass) throws RemoteException {
        super(fkey, theClass);
    }

    public OMRForeignKey(ForeignKeyImpl_Stub fkey) throws RemoteException {
        this(fkey, OMRForeignKey.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRForeignKey(ForeignKeyImpl_Stub fkey, Class theClass) throws RemoteException {
        super(fkey, theClass);
    }

    public OMRForeignKey(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRForeignKey.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ForeignKey fkey = (ForeignKey)omirepository.createMetadata(name, "ForeignKey");
                fkey.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = fkey;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    fkey.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRForeignKey", t);
            }
        }
    }

    @Override
    public void addAssociation(KeyAssociationInterface association) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ForeignKey fkey = (ForeignKey)this.getRepositoryEntity();
        try {
            SmartUtils.validateDuplicates(association.getName(), this.getAssociations());
            KeyAssociation keyAssociation = (KeyAssociation)association.getRepositoryEntity();
            fkey.getKeyedColumns().add((Object)keyAssociation.getForeignKeyColumn());
            fkey.getKeyAssociations().add((Object)keyAssociation);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public List<KeyAssociationInterface> getAssociations() throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        ArrayList<KeyAssociationInterface> listKeyAssociations = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ForeignKey fkey = (ForeignKey)this.getRepositoryEntity();
        try {
            AssociationList alKeyAssociation = fkey.getKeyAssociations();
            listKeyAssociations = new ArrayList<KeyAssociationInterface>(alKeyAssociation.size());
            Iterator it = alKeyAssociation.iterator();
            while (it.hasNext()) {
                mi = this._repository.factoryProcess(it.next());
                if (!(mi instanceof KeyAssociationInterface)) continue;
                listKeyAssociations.add((KeyAssociationInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listKeyAssociations;
    }

    @Override
    public void removeAssociation(KeyAssociationInterface association) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ForeignKey fkey = (ForeignKey)this.getRepositoryEntity();
        try {
            SmartUtils.validateRemoveObject(this.getAssociations());
            KeyAssociation keyAssociation = (KeyAssociation)association.getRepositoryEntity();
            fkey.getKeyedColumns().remove((Object)keyAssociation.getForeignKeyColumn());
            fkey.getKeyAssociations().remove((Object)keyAssociation);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public DataTableInterface getOwningTable() throws ServiceException, RemoteException {
        DataTableInterface dti = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ForeignKey fkey = (ForeignKey)this.getRepositoryEntity();
        try {
            DataTable dt = fkey.getTable();
            dti = (DataTableInterface)this._repository.factoryProcess(dt);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return dti;
    }

    @Override
    public RelationalKeyInterface getPartnerUniqueKey() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        RelationalKeyInterface partnerUniqueKey = null;
        ForeignKey fkey = (ForeignKey)this.getRepositoryEntity();
        try {
            partnerUniqueKey = (RelationalKeyInterface)this._repository.factoryProcess(fkey.getPartnerUniqueKey());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return partnerUniqueKey;
    }
}

