/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ExternalIdentity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.ExternalIdentityImpl;
import com.sas.metadata.remote.impl.ExternalIdentityImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ExternalIdentityInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRExternalIdentity
extends Metadata
implements ExternalIdentityInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(0, 0);

    protected OMRExternalIdentity(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRExternalIdentity() throws RemoteException {
        this(OMRExternalIdentity.class);
    }

    protected OMRExternalIdentity(ExternalIdentity o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRExternalIdentity(ExternalIdentity o) throws RemoteException {
        super(o, OMRExternalIdentity.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExternalIdentity(ExternalIdentityImpl o) throws RemoteException {
        super(o, OMRExternalIdentity.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExternalIdentity(ExternalIdentityImpl_Stub o) throws RemoteException {
        super(o, OMRExternalIdentity.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExternalIdentity(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRExternalIdentity.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ExternalIdentity extIdentity = (ExternalIdentity)omirepository.createMetadata(name, "ExternalIdentity");
                extIdentity.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = extIdentity;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    extIdentity.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRExternalIdentity", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getContext() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
        return extIdentity.getContext();
    }

    @Override
    public String getIdentifier() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
        return extIdentity.getIdentifier();
    }

    @Override
    public String getImportType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
        return extIdentity.getImportType();
    }

    @Override
    public void setContext(String context) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
        extIdentity.setContext(context);
    }

    @Override
    public void setIdentifier(String identifier) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
        extIdentity.setIdentifier(identifier);
    }

    @Override
    public void setImportType(String importType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
        extIdentity.setImportType(importType);
    }

    @Override
    public void setOwningObject(MetadataInterface owner) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
        extIdentity.setOwningObject((Root)owner.getRepositoryEntity());
    }

    @Override
    public MetadataInterface getOwningObject() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            ExternalIdentity extIdentity = (ExternalIdentity)this._repositoryObject;
            MetadataInterface mi = this._repository.factoryProcess(extIdentity.getOwningObject());
            return mi;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

