/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.DeployedDataPackageImpl;
import com.sas.metadata.remote.impl.DeployedDataPackageImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DeployedDataPackageInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRDeployedDataPackage
extends Metadata
implements DeployedDataPackageInterface {
    private static final long serialVersionUID = -2273953087768643365L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRDeployedDataPackage(Class c) throws RemoteException {
        super(c);
    }

    public OMRDeployedDataPackage() throws RemoteException {
        this(OMRDeployedDataPackage.class);
    }

    protected OMRDeployedDataPackage(DeployedDataPackage o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRDeployedDataPackage(DeployedDataPackage o) throws RemoteException {
        this(o, OMRDeployedDataPackage.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDeployedDataPackage(DeployedDataPackageImpl o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRDeployedDataPackage(DeployedDataPackageImpl o) throws RemoteException {
        this(o, OMRDeployedDataPackage.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDeployedDataPackage(DeployedDataPackageImpl_Stub o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRDeployedDataPackage(DeployedDataPackageImpl_Stub o) throws RemoteException {
        this(o, OMRDeployedDataPackage.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDeployedDataPackage(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRDeployedDataPackage.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                DeployedDataPackage deployedDataPackage = (DeployedDataPackage)omirepository.createMetadata(name, "DeployedDataPackage");
                deployedDataPackage.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = deployedDataPackage;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    deployedDataPackage.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDeployedDataPackage", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "DeployedDataPackage";
    }

    @Override
    public List getTableCollections() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        try {
            AssociationList list = ddp.getTableCollections();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public DeployedDataPackageInterface getAliasFor() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackageInterface result = null;
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        try {
            DeployedDataPackage alias = ddp.getAliasFor();
            if (alias == null) {
                return null;
            }
            result = (DeployedDataPackageInterface)this._repository.factoryProcess(alias);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void setAliasFor(DeployedDataPackageInterface aliasPackage) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        if (aliasPackage == null) {
            ddp.setAliasFor(null);
        } else {
            DeployedDataPackage alias = (DeployedDataPackage)aliasPackage.getRepositoryEntity();
            ddp.setAliasFor(alias);
        }
    }

    @Override
    public List getUsingPackages() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        try {
            AssociationList list = ddp.getUsingPackages();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void addUsingPackage(DeployedDataPackageInterface newPackage) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        DeployedDataPackage user = (DeployedDataPackage)newPackage.getRepositoryEntity();
        try {
            ddp.getUsingPackages().add((Object)user);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeUsingPackage(DeployedDataPackageInterface dataPackage) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        DeployedDataPackage user = (DeployedDataPackage)dataPackage.getRepositoryEntity();
        try {
            ddp.getUsingPackages().remove((Object)user);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public List getUsedByPackages() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        try {
            AssociationList list = ddp.getUsedByPackages();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void addUsedByPackage(DeployedDataPackageInterface newPackage) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        DeployedDataPackage user = (DeployedDataPackage)newPackage.getRepositoryEntity();
        try {
            ddp.getUsedByPackages().add((Object)user);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeUsedByPackage(DeployedDataPackageInterface dataPackage) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        DeployedDataPackage user = (DeployedDataPackage)dataPackage.getRepositoryEntity();
        try {
            ddp.getUsedByPackages().remove((Object)user);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public List getServers() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        try {
            AssociationList list = ddp.getDeployedComponents();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void addServer(ServerInterface server) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        DeployedComponent user = (DeployedComponent)server.getRepositoryEntity();
        try {
            ddp.getDeployedComponents().add((Object)user);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeServer(ServerInterface server) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedDataPackage ddp = (DeployedDataPackage)this._repositoryObject;
        DeployedComponent user = (DeployedComponent)server.getRepositoryEntity();
        try {
            ddp.getDeployedComponents().remove((Object)user);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }
}

