/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.impl.ClassifierImpl;
import com.sas.metadata.remote.impl.DataTableImpl;
import com.sas.metadata.remote.impl.DataTableImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnHierarchyInterface;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.DataTableRoleInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRClassifier;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalSchemaInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRDataTable
extends OMRClassifier
implements DataTableInterface {
    private static final long serialVersionUID = 9199560602609474494L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRDataTable(Class c) throws RemoteException {
        super(c);
    }

    public OMRDataTable() throws RemoteException {
        this(OMRDataTable.class);
    }

    protected OMRDataTable(DataTable o, Class c) throws RemoteException {
        super((Classifier)o, c);
    }

    public OMRDataTable(DataTable o) throws RemoteException {
        this(o, OMRDataTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDataTable(DataTableImpl o, Class c) throws RemoteException {
        super((ClassifierImpl)o, c);
    }

    public OMRDataTable(DataTableImpl o) throws RemoteException {
        this(o, OMRDataTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDataTable(DataTableImpl_Stub o, Class c) throws RemoteException {
        super((Classifier)o, c);
    }

    public OMRDataTable(DataTableImpl_Stub o) throws RemoteException {
        this(o, OMRDataTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDataTable(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRDataTable.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                DataTable dataTable = (DataTable)omirepository.createMetadata(name, "DataTable");
                dataTable.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = dataTable;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    dataTable.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDataTable", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "DataTable";
    }

    @Override
    public String getTableName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        return dt.getTableName();
    }

    @Override
    public void setTableName(String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        dt.setTableName(name);
    }

    @Override
    public double getNumRows() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        return dt.getNumRows();
    }

    @Override
    public void setNumRows(double rows) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        dt.setNumRows(rows);
    }

    @Override
    public List getColumns() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            AssociationList list = dt.getColumns();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void addColumn(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            Column c = (Column)column.getRepositoryEntity();
            dt.getColumns().add((Object)c);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void addColumnAt(ColumnInterface column, int index) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            Column c = (Column)column.getRepositoryEntity();
            dt.getColumns().add(index, (Object)c);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeColumn(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            Column c = (Column)column.getRepositoryEntity();
            dt.getColumns().remove((Object)c);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeColumn(int pos) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            dt.getColumns().remove(pos);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public RelationalSchemaInterface getSchema() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            RelationalSchema rs = dt.getTablePackage();
            if (rs == null) {
                return null;
            }
            RelationalSchemaInterface rsi = (RelationalSchemaInterface)this._repository.factoryProcess(rs);
            return rsi;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void setSchema(RelationalSchemaInterface schema) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DataTable dt = (DataTable)this._repositoryObject;
        RelationalSchema rs = (RelationalSchema)schema.getRepositoryEntity();
        dt.setTablePackage(rs);
    }

    @Override
    public void addRole(DataTableRoleInterface role) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            AssociationList roleList = dt.getRoles();
            Role newRole = (Role)role.getRepositoryEntity();
            roleList.add(newRole);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void addRole(String context, String objectRole) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTable dt = (DataTable)this._repositoryObject;
        OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
        Role role = (Role)omirepos.createMetadata("TableRole", "Role");
        role.setContext(context);
        role.setObjectRole(objectRole);
        try {
            AssociationList roleList = dt.getRoles();
            roleList.add(role);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getRoles() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTable dt = (DataTable)this._repositoryObject;
        ArrayList<MetadataInterface> result = null;
        try {
            AssociationList roleList = dt.getRoles();
            if (roleList.size() == 0) {
                result = Collections.EMPTY_LIST;
            } else {
                result = new ArrayList<MetadataInterface>(roleList.size());
                Iterator it = roleList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    result.add(mi);
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public void removeRole(DataTableRoleInterface role) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            AssociationList roleList = dt.getRoles();
            Role newRole = (Role)role.getRepositoryEntity();
            roleList.remove(newRole);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void addColumnHierarchy(ColumnHierarchyInterface columnHierarchy) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTable dt = (DataTable)this._repositoryObject;
        FeatureMap fm = (FeatureMap)columnHierarchy.getRepositoryEntity();
        try {
            AssociationList fmList = dt.getColumnHierarchies();
            fmList.add(fm);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    public List getColumnHierarchies() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTable dt = (DataTable)this._repositoryObject;
        ArrayList<MetadataInterface> result = null;
        try {
            AssociationList fmList = dt.getColumnHierarchies();
            if (fmList.size() == 0) {
                result = Collections.EMPTY_LIST;
            } else {
                result = new ArrayList<MetadataInterface>(fmList.size());
                Iterator it = fmList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    if (!mi.getType().equals("ColumnHierarchy")) continue;
                    result.add(mi);
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public void removeColumnHierarchy(ColumnHierarchyInterface columnHierarchy) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTable dt = (DataTable)this._repositoryObject;
        try {
            AssociationList fmList = dt.getColumnHierarchies();
            FeatureMap newFm = (FeatureMap)columnHierarchy.getRepositoryEntity();
            fmList.remove(newFm);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

