/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ConfiguredComponent;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.impl.ConfiguredComponentImpl;
import com.sas.metadata.remote.impl.ConfiguredComponentImpl_Stub;
import com.sas.metadata.remote.impl.DeployedComponentImpl;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ConfiguredComponentInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRServer;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRConfiguredComponent
extends OMRServer
implements ConfiguredComponentInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRConfiguredComponent() throws RemoteException {
        super(OMRConfiguredComponent.class);
    }

    public OMRConfiguredComponent(ConfiguredComponent o) throws RemoteException {
        super((DeployedComponent)o, OMRConfiguredComponent.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConfiguredComponent(ConfiguredComponentImpl o) throws RemoteException {
        super((DeployedComponentImpl)o, OMRConfiguredComponent.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConfiguredComponent(ConfiguredComponentImpl_Stub o) throws RemoteException {
        super((DeployedComponent)o, OMRConfiguredComponent.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConfiguredComponent(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRConfiguredComponent.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ConfiguredComponent socom = (ConfiguredComponent)omirepository.createMetadata(name, "ConfiguredComponent");
                socom.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = socom;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    socom.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", t);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "ConfiguredComponent";
    }
}

