/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.impl.TextStoreImpl;
import com.sas.metadata.remote.impl.TextStoreImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ConfigurationXMLTextStoreInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRTextStore;
import com.sas.services.information.metadata.configpersist.ConfigurationXMLPersistenceUtility;
import com.sas.services.information.metadata.configpersist.EnumerationItem;
import com.sas.services.information.metadata.configpersist.ParsedConfigurationXMLObject;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRConfigurationTextStore
extends OMRTextStore
implements ConfigurationXMLTextStoreInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final long serialVersionUID = 2765773259287091399L;
    private static final int EMPTY_LIST_INIT = 1;
    private static final int RANGE_MAP_INIT = 4;
    private boolean _dirty = false;
    private List _enumerationItems;
    private boolean _isOthersAllowedSet = false;
    private boolean _isOthersAllowed;
    private boolean _integerMinimumSet = false;
    private int _integerMinimum;
    private boolean _integerMaximumSet = false;
    private int _integerMaximum;
    private boolean _integerIncrementSet = false;
    private int _integerIncrement;
    private boolean _numericMinimumSet = false;
    private Number _numericMinimum;
    private boolean _numericMinimumExclusive;
    private boolean _numericMaximumSet = false;
    private Number _numericMaximum;
    private boolean _numericMaximumExclusive;
    private boolean _numericIncrementSet = false;
    private Number _numericIncrement;
    private boolean _stringLengthMinimumSet = false;
    private int _stringLengthMinimum;
    private boolean _stringLengthMaximumSet = false;
    private int _stringLengthMaximum;
    private boolean _parsed = false;

    public OMRConfigurationTextStore() throws RemoteException {
        super(OMRConfigurationTextStore.class);
    }

    public OMRConfigurationTextStore(TextStore t) throws RemoteException {
        super(t, OMRConfigurationTextStore.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConfigurationTextStore(TextStoreImpl t) throws RemoteException {
        super(t, OMRConfigurationTextStore.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConfigurationTextStore(TextStoreImpl_Stub t) throws RemoteException {
        super(t, OMRConfigurationTextStore.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConfigurationTextStore(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(repos, name, parent, OMRConfigurationTextStore.class);
        ((TextStore)this._repositoryObject).setUsageVersion(CURRENT_VERSION.encode());
        this._isCompatible = true;
        this._isReadCompatible = true;
        try {
            this.setTextRole("XML-sasconfigenum");
            this.setTextType("xml");
        }
        catch (ServiceException svcex) {
            this.logMessage(Level.WARN, svcex.getMessage(), "com.sas.services.information.metadata.OMRConfigurationTextStore", (Throwable)((Object)svcex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "ConfigurationXMLTextStore";
    }

    private void parse() throws ServiceException, RemoteException {
        String xml = this.getText();
        ParsedConfigurationXMLObject _parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(xml);
        if (_parsedObject != null) {
            Map srange;
            Map nrange;
            this._enumerationItems = _parsedObject.getEnumerationItems();
            Map irange = _parsedObject.getIntegerRange();
            if (irange != null) {
                Object o = irange.get("max");
                if (o != null && o instanceof Integer) {
                    this._integerMaximumSet = true;
                    this._integerMaximum = (Integer)o;
                }
                if ((o = irange.get("min")) != null && o instanceof Integer) {
                    this._integerMinimumSet = true;
                    this._integerMinimum = (Integer)o;
                }
                if ((o = irange.get("increment")) != null && o instanceof Integer) {
                    this._integerIncrementSet = true;
                    this._integerIncrement = (Integer)o;
                }
            }
            if (_parsedObject.isEnumerationOthersAllowedSet()) {
                this._isOthersAllowedSet = true;
                this._isOthersAllowed = _parsedObject.isEnumerationOthersAllowed();
            }
            if ((nrange = _parsedObject.getNumericRange()) != null) {
                Object o = nrange.get("max");
                if (o == null) {
                    o = nrange.get("maxExclusive");
                    if (o != null && o instanceof Number) {
                        this._numericMaximumExclusive = true;
                        this._numericMaximumSet = true;
                        this._numericMaximum = (Number)o;
                    }
                } else if (o instanceof Number) {
                    this._numericMaximumSet = true;
                    this._numericMaximum = (Number)o;
                }
                if ((o = nrange.get("min")) == null) {
                    o = nrange.get("minExclusive");
                    if (o != null && o instanceof Number) {
                        this._numericMinimumExclusive = true;
                        this._numericMinimumSet = true;
                        this._numericMinimum = (Number)o;
                    }
                } else if (o instanceof Number) {
                    this._numericMinimumSet = true;
                    this._numericMinimum = (Number)o;
                }
                if ((o = nrange.get("increment")) != null && o instanceof Number) {
                    this._numericIncrementSet = true;
                    this._numericIncrement = (Number)o;
                }
            }
            if ((srange = _parsedObject.getStringLengthRange()) != null) {
                Object o = srange.get("max");
                if (o != null && o instanceof Integer) {
                    this._stringLengthMaximumSet = true;
                    this._stringLengthMaximum = (Integer)o;
                }
                if ((o = srange.get("min")) != null && o instanceof Integer) {
                    this._stringLengthMinimumSet = true;
                    this._stringLengthMinimum = (Integer)o;
                }
            }
        }
        this._dirty = false;
        this._parsed = true;
    }

    @Override
    public List getEnumerationItems() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._enumerationItems;
    }

    @Override
    public List getEnumerationTextLabels() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(this._enumerationItems.size());
        for (EnumerationItem ei : this._enumerationItems) {
            String string = ei.getTextLabel();
            results.add(string);
        }
        return results;
    }

    @Override
    public List getEnumerationTextLabels(Locale locale) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(this._enumerationItems.size());
        for (EnumerationItem ei : this._enumerationItems) {
            String string = ei.getTextLabel(locale);
            results.add(string);
        }
        return results;
    }

    @Override
    public List getEnumerationValues() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>(this._enumerationItems.size());
        for (EnumerationItem ei : this._enumerationItems) {
            results.add(ei.getValue());
        }
        return null;
    }

    @Override
    public void setEnumerationData(List list) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        for (Object o : list) {
            if (o instanceof EnumerationItem) continue;
            throw new IllegalArgumentException();
        }
        this._enumerationItems = list;
        this._dirty = true;
    }

    @Override
    public void addEnumerationItem(EnumerationItem item) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            this._enumerationItems = new ArrayList(1);
        }
        this._enumerationItems.add(item);
        this._dirty = true;
    }

    @Override
    public void removeEnumerationItem(EnumerationItem item) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            return;
        }
        this._enumerationItems.remove(item);
        this._dirty = true;
    }

    @Override
    public Map getEnumerationValuesLabelsMap(Locale locale) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            return null;
        }
        HashMap<Object, String> map = new HashMap<Object, String>(this._enumerationItems.size());
        for (EnumerationItem ei : this._enumerationItems) {
            map.put(ei.getValue(), ei.getTextLabel(locale));
        }
        return map;
    }

    @Override
    public boolean hasUniqueTextLabels(Locale locale) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            return false;
        }
        for (EnumerationItem ei : this._enumerationItems) {
            String value = ei.getValue().toString();
            String label = ei.getTextLabel(locale);
            if (label.equals(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnumerationOthersAllowed() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            throw new IllegalStateException();
        }
        if (!this._isOthersAllowedSet) {
            throw new IllegalStateException();
        }
        return this._isOthersAllowed;
    }

    @Override
    public boolean isEnumerationOthersAllowedSet() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            throw new IllegalStateException();
        }
        return this._isOthersAllowedSet;
    }

    @Override
    public void setEnumerationOthersAllowed(boolean allowed) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._isOthersAllowedSet = true;
        this._isOthersAllowed = allowed;
    }

    @Override
    public Map getIntegerRange() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._enumerationItems == null) {
            return null;
        }
        if (!this._integerMinimumSet && !this._integerMaximumSet) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(4);
        if (this._integerMinimumSet) {
            map.put("min", this._integerMinimum);
        }
        if (this._integerMaximumSet) {
            map.put("max", this._integerMaximum);
        }
        if (this._integerIncrementSet) {
            map.put("increment", this._integerIncrement);
        }
        return map;
    }

    @Override
    public int getIntegerRangeIncrement() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._integerIncrementSet) {
            throw new IllegalStateException();
        }
        return this._integerIncrement;
    }

    @Override
    public int getIntegerRangeMaximum() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._integerMaximumSet) {
            throw new IllegalStateException();
        }
        return this._integerMaximum;
    }

    @Override
    public int getIntegerRangeMinimum() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._integerMinimumSet) {
            throw new IllegalStateException();
        }
        return this._integerMinimum;
    }

    @Override
    public boolean isIntegerRangeIncrementSet() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._integerIncrementSet;
    }

    @Override
    public boolean isIntegerRangeMaximumSet() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._integerMaximumSet;
    }

    @Override
    public boolean isIntegerRangeMinimumSet() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._integerMinimumSet;
    }

    @Override
    public void removeIntegerRange() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!(this._integerMinimumSet || this._integerMaximumSet || this._integerIncrementSet)) {
            return;
        }
        this._integerMinimumSet = false;
        this._integerMaximumSet = false;
        this._integerIncrementSet = false;
        this._dirty = true;
    }

    @Override
    public void setIntegerRange(int minimum, int maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._integerMinimumSet = true;
        this._integerMinimum = minimum;
        this._integerMaximumSet = true;
        this._integerMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void setIntegerRangeMinimum(int minimum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._integerMinimumSet = true;
        this._integerMinimum = minimum;
        this._dirty = true;
    }

    @Override
    public void setIntegerRangeMaximum(int maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._integerMaximumSet = true;
        this._integerMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void setIntegerRangeIncrement(int increment) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._integerIncrementSet = true;
        this._integerIncrement = increment;
        this._dirty = true;
    }

    @Override
    public void setIntegerRange(Map map) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._integerMinimumSet = false;
        this._integerMaximumSet = false;
        this._integerIncrementSet = false;
        Object o = map.get("max");
        if (o != null && o instanceof Integer) {
            this._integerMaximumSet = true;
            this._integerMaximum = (Integer)o;
        }
        if ((o = map.get("min")) != null && o instanceof Integer) {
            this._integerMinimumSet = true;
            this._integerMinimum = (Integer)o;
        }
        if ((o = map.get("increment")) != null && o instanceof Integer) {
            this._integerIncrementSet = true;
            this._integerIncrement = (Integer)o;
        }
    }

    @Override
    public Map getNumericRange() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._numericMinimumSet && !this._numericMaximumSet) {
            return null;
        }
        HashMap<String, Number> map = new HashMap<String, Number>(4);
        if (this._numericMinimumSet) {
            if (this._numericMinimumExclusive) {
                map.put("minExclusive", this._numericMinimum);
            } else {
                map.put("min", this._numericMinimum);
            }
        }
        if (this._numericMaximumSet) {
            if (this._numericMaximumExclusive) {
                map.put("maxExclusive", this._numericMaximum);
            } else {
                map.put("max", this._numericMaximum);
            }
        }
        if (this._numericIncrementSet) {
            map.put("increment", this._numericIncrement);
        }
        return map;
    }

    @Override
    public Number getNumericRangeIncrement() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._numericIncrementSet) {
            throw new IllegalStateException();
        }
        return this._numericIncrement;
    }

    @Override
    public Number getNumericRangeMaximum() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._numericMaximumSet) {
            throw new IllegalStateException();
        }
        return this._numericMaximum;
    }

    @Override
    public Number getNumericRangeMinimum() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._numericMinimumSet) {
            throw new IllegalStateException();
        }
        return this._numericMinimum;
    }

    @Override
    public boolean isNumericRangeIncrementSet() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._numericIncrementSet;
    }

    @Override
    public boolean isNumericRangeMaximumExclusive() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._numericMaximumExclusive;
    }

    @Override
    public boolean isNumericRangeMaximumSet() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._numericMaximumSet;
    }

    @Override
    public boolean isNumericRangeMinimumExclusive() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._numericMinimumExclusive;
    }

    @Override
    public boolean isNumericRangeMinimumSet() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return this._numericMinimumSet;
    }

    @Override
    public void removeNumericRangeMaximum() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._numericMaximumSet) {
            return;
        }
        this._numericMaximumSet = false;
        this._dirty = true;
    }

    @Override
    public void removeNumericRangeMinimum() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._numericMinimumSet) {
            return;
        }
        this._numericMinimumSet = false;
        this._dirty = true;
    }

    @Override
    public void removeNumericRange() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (this._numericMinimumSet || this._numericMaximumSet || this._numericIncrementSet) {
            this._numericMinimumSet = false;
            this._numericMaximumSet = false;
            this._numericIncrementSet = false;
            this._dirty = true;
        }
    }

    @Override
    public void setNumericRange(Number minimum, Number maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericMinimumSet = true;
        this._numericMinimumExclusive = false;
        this._numericMinimum = minimum;
        this._numericMaximumSet = true;
        this._numericMaximumExclusive = false;
        this._numericMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void setNumericRangeExclusive(Number minimum, Number maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericMinimumSet = true;
        this._numericMinimumExclusive = true;
        this._numericMinimum = minimum;
        this._numericMaximumSet = true;
        this._numericMaximumExclusive = true;
        this._numericMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void setNumericRangeMaximumExclusive(Number maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericMaximumSet = true;
        this._numericMaximumExclusive = true;
        this._numericMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void setNumericRangeMaximum(Number maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericMaximumSet = true;
        this._numericMaximumExclusive = false;
        this._numericMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void setNumericRangeMinimumExclusive(Number minimum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericMinimumSet = true;
        this._numericMinimumExclusive = true;
        this._numericMinimum = minimum;
        this._dirty = true;
    }

    @Override
    public void setNumericRangeMinimum(Number minimum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericMinimumSet = true;
        this._numericMinimumExclusive = false;
        this._numericMinimum = minimum;
        this._dirty = true;
    }

    @Override
    public void setNumericRangeIncrement(Number increment) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericIncrementSet = true;
        this._numericIncrement = increment;
        this._dirty = true;
    }

    @Override
    public void setNumericRange(Map map) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._numericMinimumSet = false;
        this._numericMaximumSet = false;
        this._numericIncrementSet = false;
        Object o = map.get("max");
        if (o != null && o instanceof Number) {
            this._numericMaximumSet = true;
            this._numericMaximumExclusive = false;
            this._numericMaximum = (Number)o;
        }
        if ((o = map.get("maxExclusive")) != null && o instanceof Number) {
            this._numericMaximumSet = true;
            this._numericMaximumExclusive = true;
            this._numericMaximum = (Number)o;
        }
        if ((o = map.get("min")) != null && o instanceof Number) {
            this._numericMinimumSet = true;
            this._numericMinimumExclusive = false;
            this._numericMinimum = (Number)o;
        }
        if ((o = map.get("minExclusive")) != null && o instanceof Number) {
            this._numericMinimumSet = true;
            this._numericMinimumExclusive = true;
            this._numericMinimum = (Number)o;
        }
        if ((o = map.get("increment")) != null && o instanceof Number) {
            this._numericIncrementSet = true;
            this._numericIncrement = (Number)o;
        }
    }

    @Override
    public Map getSelectionRange() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        return null;
    }

    @Override
    public void setSelectionRange(Map map) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
    }

    @Override
    public void setEnumerationOptions(Map map) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
    }

    @Override
    public Map getStringLengthRange() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._stringLengthMinimumSet && !this._stringLengthMaximumSet) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(4);
        if (this._stringLengthMinimumSet) {
            map.put("min", this._stringLengthMinimum);
        }
        if (this._stringLengthMaximumSet) {
            map.put("max", this._stringLengthMaximum);
        }
        return map;
    }

    @Override
    public void setStringLengthRange(Map map) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._stringLengthMinimumSet = false;
        this._stringLengthMaximumSet = false;
        Object o = map.get("min");
        if (o != null && o instanceof Integer) {
            this._stringLengthMinimumSet = true;
            this._stringLengthMinimum = (Integer)o;
        }
        if ((o = map.get("max")) != null && o instanceof Integer) {
            this._stringLengthMaximumSet = true;
            this._stringLengthMaximum = (Integer)o;
        }
        this._dirty = true;
    }

    @Override
    public int getStringLengthMaximum() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._stringLengthMaximumSet) {
            throw new IllegalStateException();
        }
        return this._stringLengthMaximum;
    }

    @Override
    public int getStringLengthMinimum() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        if (!this._stringLengthMinimumSet) {
            throw new IllegalStateException();
        }
        return this._stringLengthMinimum;
    }

    @Override
    public void setStringLengthMaximum(int maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._stringLengthMaximumSet = true;
        this._stringLengthMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void setStringLengthMimimum(int minimum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._stringLengthMinimumSet = true;
        this._stringLengthMinimum = minimum;
        this._dirty = true;
    }

    @Override
    public void setStringLengthRange(int minimum, int maximum) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this._parsed) {
            this.parse();
        }
        this._stringLengthMinimumSet = true;
        this._stringLengthMinimum = minimum;
        this._stringLengthMaximumSet = true;
        this._stringLengthMaximum = maximum;
        this._dirty = true;
    }

    @Override
    public void update() throws ServiceException, RemoteException {
        this.checkPulse(false);
        if (this._dirty && this._myState != 3) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            if (this._enumerationItems != null) {
                map.put("Enumeration", this._enumerationItems);
                if (this._isOthersAllowedSet) {
                    HashMap<String, Boolean> omap = new HashMap<String, Boolean>(1);
                    omap.put("isOthersAllowed", true);
                    map.put("EnumerationOptions", omap);
                }
            }
            if (this._integerMinimumSet || this._integerMaximumSet || this._integerIncrementSet) {
                HashMap<String, Integer> imap = new HashMap<String, Integer>(4);
                if (this._integerMinimumSet) {
                    imap.put("min", this._integerMinimum);
                }
                if (this._integerMaximumSet) {
                    imap.put("max", this._integerMaximum);
                }
                if (this._integerIncrementSet) {
                    imap.put("increment", this._integerIncrement);
                }
                map.put("IntegerRange", imap);
            }
            if (this._numericMinimumSet || this._numericMaximumSet || this._numericIncrementSet) {
                HashMap<String, Number> nmap = new HashMap<String, Number>(4);
                if (this._numericMinimumSet) {
                    if (this._numericMinimumExclusive) {
                        nmap.put("minExclusive", this._numericMinimum);
                    } else {
                        nmap.put("min", this._numericMinimum);
                    }
                }
                if (this._numericMaximumSet) {
                    if (this._numericMaximumExclusive) {
                        nmap.put("maxExclusive", this._numericMaximum);
                    } else {
                        nmap.put("max", this._numericMaximum);
                    }
                }
                if (this._numericIncrementSet) {
                    nmap.put("increment", this._numericIncrement);
                }
                map.put("NumericRange", nmap);
            }
            if (this._stringLengthMinimumSet || this._stringLengthMaximumSet) {
                HashMap<String, Integer> smap = new HashMap<String, Integer>(4);
                if (this._stringLengthMinimumSet) {
                    smap.put("min", this._stringLengthMinimum);
                }
                if (this._stringLengthMaximumSet) {
                    smap.put("max", this._stringLengthMaximum);
                }
                map.put("StringLengthRange", smap);
            }
            String xmlText = ConfigurationXMLPersistenceUtility.writeConfigurationXML(map);
            this.setText(xmlText);
        }
        super.update();
    }
}

