/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.Group;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.ITChannel;
import com.sas.metadata.remote.ITContentSubscriber;
import com.sas.metadata.remote.ITEventSubscriber;
import com.sas.metadata.remote.ITSubscriber;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.ITChannelImpl;
import com.sas.metadata.remote.impl.ITChannelImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepository;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.ContentSubscriberInterface;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.EmbeddedObjectInterface;
import com.sas.services.information.metadata.EventSubscriberInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.KeywordFilter;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.SubscriberInterface;
import com.sas.services.information.metadata.propertybag.PropertyBag;
import com.sas.services.information.metadata.propertybag.PropertyBagInterface;
import com.sas.services.information.metadata.propertybag.PropertyBagListValue;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.URIUtil;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRChannel
extends Metadata
implements ChannelInterface,
SubstitutionProperties,
LocalizableProperties,
EmbeddedObjectInterface {
    private static final long serialVersionUID = -4126161173757363361L;
    private static final String TRANSPORT_ARCHIVE = "archive";
    private static final String TRANSPORT_WEBDAV = "webdav";
    static final String DAVURLTYPE = "DavURLType";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final int EMPTY_LIST_INIT = 1;
    private boolean _refreshSubscribers = true;
    private boolean _refreshPackages = true;
    private boolean _refreshGroups = true;

    public OMRChannel() throws RemoteException {
        super(OMRChannel.class);
    }

    public OMRChannel(ITChannel o) throws RemoteException {
        super(o, OMRChannel.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRChannel(ITChannelImpl o) throws RemoteException {
        super(o, OMRChannel.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRChannel(ITChannelImpl_Stub o) throws RemoteException {
        super(o, OMRChannel.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRChannel(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRChannel.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        ITChannel itchannel = null;
        try {
            itchannel = (ITChannel)omirepository.createMetadata(name, "ITChannel");
            this._repositoryObject = itchannel;
            itchannel.setPublicType("Channel");
            itchannel.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                parent.addItem(this);
            }
        }
        catch (ServiceException ex) {
            if (itchannel != null) {
                itchannel.delete();
            }
            throw new IllegalArgumentException((Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Channel";
    }

    @Override
    public ContentDestination getArchivePath() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        ServerInterface si = null;
        String relPath = null;
        String basePath = null;
        DirectoryInterface dir = null;
        DirectoryInterface baseDir = null;
        try {
            Directory cd = null;
            AssociationList paths = chan.getArchivePaths();
            if (paths == null || paths.size() < 1) {
                return null;
            }
            cd = (Directory)paths.get(0);
            dir = (DirectoryInterface)this._repository.factoryProcess(cd);
            if (cd != null) {
                relPath = cd.getDirectoryName();
                Directory parentDir = cd.getParent();
                if (parentDir != null) {
                    ServerComponent sc;
                    baseDir = (DirectoryInterface)this._repository.factoryProcess(parentDir);
                    basePath = parentDir.getDirectoryName();
                    AssociationList servers = parentDir.getDeployedComponents();
                    if (servers != null && servers.size() > 0 && (sc = this.getServerComponent((List)servers, 2)) != null) {
                        si = (ServerInterface)this._repository.factoryProcess(sc);
                    }
                } else {
                    ServerComponent sc;
                    AssociationList servers = cd.getDeployedComponents();
                    if (servers != null && servers.size() > 0 && (sc = this.getServerComponent((List)servers, 2)) != null && (si = (ServerInterface)this._repository.factoryProcess(sc)) instanceof HttpServerInterface) {
                        baseDir = dir;
                        basePath = relPath;
                        relPath = null;
                    }
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex);
        }
        return new ContentDestination(dir, relPath, basePath, si, baseDir);
    }

    @Override
    public void setArchivePath(DirectoryInterface basePathDir, String relativePath) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            AssociationList paths = chan.getArchivePaths();
            if (relativePath == null || relativePath.length() == 0) {
                Directory dir = (Directory)basePathDir.getRepositoryEntity();
                paths.clear();
                paths.add((Object)dir);
            } else {
                MdObjectStore store = (MdObjectStore)chan.getObjectStore();
                MdFactory factory = store.getFactory();
                Directory relDir = (Directory)factory.createComplexMetadataObject(store, null, this.getName() + "RelativePath", "Directory", chan.getRepositoryID());
                relDir.setDirectoryName(relativePath);
                relDir.setIsRelative(1);
                relDir.setParent((Directory)basePathDir.getRepositoryEntity());
                paths.clear();
                paths.add((Object)relDir);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void setArchivePath(String path) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            AssociationList paths = chan.getArchivePaths();
            MdObjectStore store = (MdObjectStore)chan.getObjectStore();
            MdFactory factory = store.getFactory();
            Directory dir = (Directory)factory.createComplexMetadataObject(store, null, this.getName() + "Path", "Directory", chan.getRepositoryID());
            dir.setDirectoryName(path);
            paths.clear();
            paths.add((Object)dir);
        }
        catch (MdException ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void setArchivePath(ServerInterface server, String relativePath) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            AssociationList paths = chan.getArchivePaths();
            MdObjectStore store = (MdObjectStore)chan.getObjectStore();
            MdFactory factory = store.getFactory();
            Directory dir = (Directory)factory.createComplexMetadataObject(store, null, this.getName() + "RelativePath", "Directory", chan.getRepositoryID());
            dir.setDirectoryName(relativePath);
            AssociationList servers = dir.getDeployedComponents();
            ServerComponent sc = (ServerComponent)server.getRepositoryEntity();
            servers.add((Object)sc);
            dir.setDeployedComponents(servers);
            paths.clear();
            paths.add((Object)dir);
        }
        catch (MdException ex) {
            throw new ServiceException(ex);
        }
    }

    private List archiveList(Comparator compare) throws RemoteException {
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        ArrayList<MetadataInterface> list = null;
        try {
            AssociationList archiveList = null;
            if (this._refreshPackages) {
                archiveList = chan.getArchives(true);
                this._refreshPackages = false;
            } else {
                archiveList = chan.getArchives();
            }
            if (archiveList != null) {
                list = new ArrayList(archiveList.size());
                for (ArchiveFile arc : archiveList) {
                    MetadataInterface op = this._repository.factoryProcess(arc);
                    list.add(op);
                }
            }
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), (Throwable)((Object)ex));
            list = new ArrayList<MetadataInterface>(1);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
            list = new ArrayList(1);
        }
        if (compare != null) {
            Collections.sort(list, compare);
        }
        return list;
    }

    @Override
    public String getSubject() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITChannel chan = (ITChannel)this._repositoryObject;
        return chan.getSubject();
    }

    @Override
    public void setSubject(String subject) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        chan.setSubject(subject);
    }

    @Override
    public String getPresentationLanguage() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITChannel chan = (ITChannel)this._repositoryObject;
        return chan.getPresentationLanguage();
    }

    @Override
    public void setPresentationLanguage(String language) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        chan.setPresentationLanguage(language);
    }

    public void setDeliveryTransport(String transport) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        chan.setDefaultTransport(transport);
    }

    @Override
    public String getFrequency() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITChannel chan = (ITChannel)this._repositoryObject;
        return chan.getFrequency();
    }

    @Override
    public void setFrequency(String frequency) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        chan.setFrequency(frequency);
    }

    @Override
    public ContentDestination getContentDestination() throws ServiceException, RemoteException {
        block9: {
            if (!this._isReadCompatible) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            this.checkPulse(true);
            ITChannel chan = (ITChannel)this._repositoryObject;
            DirectoryInterface baseDir = null;
            DirectoryInterface dir = null;
            String relPath = null;
            String basePath = null;
            try {
                Directory cd = chan.getContentDestination();
                if (cd == null) break block9;
                Directory parentDir = cd.getParent();
                int transportType = 3;
                dir = (DirectoryInterface)this._repository.factoryProcess(cd);
                if (parentDir != null) {
                    baseDir = (DirectoryInterface)this._repository.factoryProcess(parentDir);
                    relPath = cd.getDirectoryName();
                    basePath = parentDir.getDirectoryName();
                    AssociationList servers = parentDir.getDeployedComponents();
                    if (servers != null && servers.size() > 0) {
                        ServerComponent sc = this.getServerComponent((List)servers, 3);
                        if (sc != null) {
                            ServerInterface si = (ServerInterface)this._repository.factoryProcess(sc);
                            ContentDestination result = new ContentDestination(dir, relPath, basePath, si, baseDir);
                            return result;
                        }
                        break block9;
                    }
                    ContentDestination result = new ContentDestination(dir, relPath, basePath, null, baseDir);
                    return result;
                }
                baseDir = dir;
                basePath = cd.getDirectoryName();
                AssociationList servers = cd.getDeployedComponents();
                if (servers != null && servers.size() > 0) {
                    ServerComponent sc = this.getServerComponent((List)servers, 3);
                    if (sc != null) {
                        ServerInterface si = (ServerInterface)this._repository.factoryProcess(sc);
                        ContentDestination result = new ContentDestination(dir, relPath, basePath, si, baseDir);
                        return result;
                    }
                    break block9;
                }
                ContentDestination result = new ContentDestination(dir, relPath, basePath, null, baseDir);
                return result;
            }
            catch (ServiceException ex) {
                this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), (Throwable)((Object)ex));
            }
            catch (MdException ex) {
                this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
            }
        }
        return null;
    }

    @Override
    public void setContentDestination(DirectoryInterface basePathDirectory, String relativePath) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        if (relativePath == null || relativePath.length() == 0) {
            Directory dir = (Directory)basePathDirectory.getRepositoryEntity();
            chan.setContentDestination(dir);
        } else {
            MdObjectStore store = (MdObjectStore)chan.getObjectStore();
            MdFactory factory = store.getFactory();
            Directory relDir = (Directory)factory.createComplexMetadataObject(store, null, this.getName() + "BasePath", "Directory", chan.getRepositoryID());
            relDir.setIsRelative(1);
            relDir.setDirectoryName(relativePath);
            relDir.setParent((Directory)basePathDirectory.getRepositoryEntity());
            chan.setContentDestination(relDir);
        }
    }

    @Override
    public List subscriberList(int subscriberType) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        return this.subscriberList(subscriberType, null);
    }

    @Override
    public List subscriberList(int subscriberType, Comparator compare) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        ArrayList<SubscriberInterface> list = null;
        try {
            AssociationList subscriberList = null;
            if (this._refreshSubscribers) {
                subscriberList = chan.getChannelSubscriptions(true);
                this._refreshSubscribers = false;
            } else {
                subscriberList = chan.getChannelSubscriptions();
            }
            if (subscriberList != null) {
                list = new ArrayList(subscriberList.size());
                Iterator e = subscriberList.iterator();
                if (subscriberType == 1) {
                    while (e.hasNext()) {
                        SubscriberInterface os = (SubscriberInterface)this._repository.factoryProcess(e.next());
                        if (!(os instanceof ContentSubscriberInterface)) continue;
                        list.add(os);
                    }
                } else if (subscriberType == 2) {
                    while (e.hasNext()) {
                        SubscriberInterface os = (SubscriberInterface)this._repository.factoryProcess(e.next());
                        if (!(os instanceof EventSubscriberInterface)) continue;
                        list.add(os);
                    }
                }
            }
        }
        catch (ServiceException ex) {
            list = new ArrayList<SubscriberInterface>(1);
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), (Throwable)((Object)ex));
        }
        catch (MdException ex) {
            list = new ArrayList(1);
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return list;
    }

    @Override
    public void addContentSubscriber(ContentSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            ITContentSubscriber cs = (ITContentSubscriber)subscriber.getRepositoryEntity();
            AssociationList ass = cs.getSubscribedChannels();
            ass.add((Object)chan);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
    }

    @Override
    public void addEventSubscriber(EventSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            ITEventSubscriber es = (ITEventSubscriber)subscriber.getRepositoryEntity();
            AssociationList ass = es.getSubscribedChannels();
            ass.add((Object)chan);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
    }

    public PropertyList getSubstitutionProperties() {
        PropertyList pl = new PropertyList();
        try {
            ContentDestination cd = this.getArchivePath();
            if (cd != null && cd.getDirectory() != null && cd.getServer() == null) {
                ServerInterface server;
                DirectoryInterface dir = cd.getDirectory();
                if (dir.getFilePath() != null) {
                    pl.addProperty("DirPath", dir.getFilePath());
                }
                if ((server = this.getIOMServer(dir)) != null) {
                    pl.addProperty("DirPath.ApplicationServer", server.getName());
                }
            }
        }
        catch (ServiceException ex) {
            this.logException((Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            this.logException(ex);
        }
        catch (MdException ex) {
            this.logException((Exception)((Object)ex));
        }
        return pl;
    }

    public void setSubstitutionProperties(PropertyMap map) {
        this.checkPulse(true);
        String dirPath = map.getProperty("DirPath");
        if (dirPath == null) {
            return;
        }
        try {
            ITChannel chan = (ITChannel)this._repositoryObject;
            Directory archivePath = (Directory)chan.getArchivePaths(true).get(0);
            archivePath.setDirectoryName(dirPath);
        }
        catch (MdException ex) {
            this.logException((Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            this.logException(ex);
        }
    }

    private ServerInterface getIOMServer(DirectoryInterface dir) throws MdException, RemoteException, ServiceException {
        ServerInterface server = null;
        for (Object o : dir.getServers()) {
            if (!(o instanceof LogicalServerInterface)) continue;
            LogicalServerInterface lsi = (LogicalServerInterface)o;
            List l = lsi.getServed();
            if (l.size() <= 0) break;
            server = (ServerInterface)l.get(0);
            break;
        }
        return server;
    }

    @Override
    public void removeContentSubscriber(ContentSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            ITContentSubscriber cs = (ITContentSubscriber)subscriber.getRepositoryEntity();
            AssociationList ass = cs.getSubscribedChannels();
            ass.remove((Object)chan);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
    }

    @Override
    public void removeEventSubscriber(EventSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            ITEventSubscriber es = (ITEventSubscriber)subscriber.getRepositoryEntity();
            AssociationList ass = es.getSubscribedChannels();
            ass.remove((Object)chan);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
    }

    @Override
    public boolean isGroupContentSubscription(ContentSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            ArrayList<String> list = null;
            AssociationList groupList = chan.getSubscriberGroups();
            if (groupList != null) {
                list = new ArrayList<String>(groupList.size());
                Iterator e = groupList.iterator();
                while (e.hasNext()) {
                    list.add(((Group)e.next()).getName());
                }
                PersonInterface person = subscriber.getPerson();
                Iterator it = person.getGroups().iterator();
                while (it.hasNext()) {
                    if (!list.contains(((GroupInterface)it.next()).getName())) continue;
                    return true;
                }
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return false;
    }

    @Override
    public boolean isGroupEventSubscription(EventSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            AssociationList groupList = chan.getSubscriberGroups();
            if (groupList != null) {
                ArrayList<String> list = new ArrayList<String>(groupList.size());
                Iterator e = groupList.iterator();
                while (e.hasNext()) {
                    list.add(((Group)e.next()).getName());
                }
                PersonInterface person = subscriber.getPerson();
                Iterator it = person.getGroups().iterator();
                while (it.hasNext()) {
                    if (!list.contains(((GroupInterface)it.next()).getName())) continue;
                    return true;
                }
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return false;
    }

    @Override
    public boolean isContentSubscription(ContentSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            String name = subscriber.getName();
            AssociationList ass = chan.getChannelSubscriptions();
            if (ass != null) {
                for (ITSubscriber nextSub : ass) {
                    if (!name.equalsIgnoreCase(nextSub.getName())) continue;
                    return true;
                }
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return false;
    }

    @Override
    public boolean isEventSubscription(EventSubscriberInterface subscriber) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            String name = subscriber.getName();
            AssociationList ass = chan.getChannelSubscriptions();
            if (ass != null) {
                for (ITSubscriber nextSub : ass) {
                    if (!name.equalsIgnoreCase(nextSub.getName())) continue;
                    return true;
                }
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return false;
    }

    @Override
    public List subscriberNameList(int subscriberType) throws RemoteException, ServiceException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        ArrayList<String> list = null;
        try {
            AssociationList subList = chan.getChannelSubscriptions();
            if (subList != null) {
                list = new ArrayList<String>(subList.size());
                Iterator e = subList.iterator();
                if (subscriberType == 1) {
                    while (e.hasNext()) {
                        ITSubscriber sub = (ITSubscriber)e.next();
                        SubscriberInterface os = (SubscriberInterface)this._repository.factoryProcess(sub);
                        if (!(os instanceof ContentSubscriberInterface)) continue;
                        list.add(sub.getName());
                    }
                } else if (subscriberType == 2) {
                    while (e.hasNext()) {
                        ITSubscriber sub = (ITSubscriber)e.next();
                        SubscriberInterface os = (SubscriberInterface)this._repository.factoryProcess(sub);
                        if (!(os instanceof EventSubscriberInterface)) continue;
                        list.add(sub.getName());
                    }
                }
            }
        }
        catch (MdException ex) {
            list = Collections.EMPTY_LIST;
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return list;
    }

    @Override
    public List subscriberGroupsList(int subscriberType) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        ArrayList<MetadataInterface> list = null;
        try {
            AssociationList groupList = null;
            if (this._refreshGroups) {
                this._refreshGroups = false;
                groupList = chan.getSubscriberGroups(true);
            } else {
                groupList = chan.getSubscriberGroups();
            }
            if (groupList != null) {
                list = new ArrayList(groupList.size());
                Iterator e = groupList.iterator();
                if (subscriberType == 1) {
                    block3: while (e.hasNext()) {
                        com.sas.metadata.remote.Group og = (com.sas.metadata.remote.Group)e.next();
                        AssociationList trees = og.getTrees();
                        for (Tree tree : trees) {
                            if (!tree.getName().equals("Content Subscribers")) continue;
                            MetadataInterface mi = this._repository.factoryProcess(og);
                            list.add(mi);
                            continue block3;
                        }
                    }
                } else if (subscriberType == 2) {
                    block5: while (e.hasNext()) {
                        com.sas.metadata.remote.Group og = (com.sas.metadata.remote.Group)e.next();
                        AssociationList trees = og.getTrees();
                        for (Tree tree : trees) {
                            if (!tree.getName().equals("Event Subscribers")) continue;
                            MetadataInterface mi = this._repository.factoryProcess(og);
                            list.add(mi);
                            continue block5;
                        }
                    }
                } else {
                    while (e.hasNext()) {
                        GroupInterface og = (GroupInterface)this._repository.factoryProcess(e.next());
                        list.add(og);
                    }
                }
            }
        }
        catch (ServiceException ex) {
            list = new ArrayList<MetadataInterface>(1);
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), (Throwable)((Object)ex));
        }
        catch (MdException ex) {
            list = new ArrayList(1);
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return list;
    }

    @Override
    public void addSubscriberGroup(GroupInterface group) throws RemoteException, ServiceException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            List memberList = group.members();
            for (MetadataInterface mi : memberList) {
                Object o = mi.getRepositoryEntity();
                if (o instanceof ITContentSubscriber || o instanceof ITEventSubscriber || o instanceof com.sas.metadata.remote.Group) continue;
                throw new ServiceException(RB.getStringResource("OMRChannel.mustbsubscriber.ex.txt"));
            }
            AssociationList ass = chan.getSubscriberGroups();
            ass.add(group.getRepositoryEntity());
            return;
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
            return;
        }
    }

    @Override
    public void removeSubscriberGroup(GroupInterface group) throws RemoteException, ServiceException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            AssociationList ass = chan.getSubscriberGroups();
            ass.remove(group.getRepositoryEntity());
            return;
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
            return;
        }
    }

    @Override
    public String getDavUrlType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String result = "";
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            AssociationList ass = chan.getProperties();
            for (Property prop : ass) {
                String name = prop.getPropertyName();
                if (name == null) {
                    name = prop.getName();
                }
                if (!name.equalsIgnoreCase(DAVURLTYPE)) continue;
                return prop.getDefaultValue();
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        return result;
    }

    @Override
    public void setDavUrlType(String type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITChannel chan = (ITChannel)this._repositoryObject;
        try {
            boolean found_property = false;
            AssociationList ass = chan.getProperties();
            for (Property prop : ass) {
                String name = prop.getPropertyName();
                if (name == null) {
                    name = prop.getName();
                }
                if (!name.equalsIgnoreCase(DAVURLTYPE)) continue;
                found_property = true;
                prop.setDefaultValue(type);
                return;
            }
            if (!found_property) {
                MdObjectStore store = (MdObjectStore)chan.getObjectStore();
                MdFactory factory = store.getFactory();
                Property prop = (Property)factory.createComplexMetadataObject(store, null, DAVURLTYPE, "Property", chan.getRepositoryID());
                prop.setName(DAVURLTYPE);
                prop.setPropertyName(DAVURLTYPE);
                prop.setDefaultValue(type);
                PropertyType propType = (PropertyType)factory.createComplexMetadataObject(store, null, "StringType", "PropertyType", chan.getRepositoryID());
                propType.setSQLType(12);
                prop.setOwningType(propType);
                ass.add((Object)prop);
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
    }

    @Override
    public List packageList() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        return this.packageList(null);
    }

    @Override
    public List packageList(Comparator compare) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        List returnList = null;
        ITChannel chan = (ITChannel)this._repositoryObject;
        String transport = chan.getDefaultTransport();
        if (transport == null || transport.equals("")) {
            returnList = new ArrayList(1);
        } else if (TRANSPORT_WEBDAV.equalsIgnoreCase(transport)) {
            returnList = this.davList(compare);
        } else if (TRANSPORT_ARCHIVE.equalsIgnoreCase(transport)) {
            returnList = this.archiveList(compare);
        } else {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.invTrans.ex.txt"), OMRChannel.class.getName(), null);
            returnList = new ArrayList(1);
        }
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    private List davList(Comparator compare) throws RemoteException {
        try {
            username = null;
            password = null;
            base = null;
            repos = null;
            returnList = null;
            domain = null;
            relPath = null;
            dItor = null;
            contentDest = this.getContentDestination();
            isHttps = false;
            if (contentDest == null) {
                return Collections.EMPTY_LIST;
            }
            server = (HttpServerInterface)contentDest.getServer();
            if (server.getApplicationProtocol().equalsIgnoreCase("https")) {
                isHttps = true;
            }
            base = contentDest.getBasePath();
            chUrl = contentDest.getPath();
            if (chUrl != null && !chUrl.equals("")) {
                base = URIUtil.addSegment(base, chUrl);
            }
            if ((uc = this._repository.getUserContext()) != null) {
                try {
                    _uri = new URI("dav", null, server.getHost(), server.getTcpPort(), base, null, null);
                    myUrl = _uri.toString();
                }
                catch (URISyntaxException use) {
                    myUrl = "dav://" + server.getHost() + ':' + server.getTcpPort() + base;
                }
                for (RepositoryInterface r : uc.getRepositories()) {
                    relPath = URIUtil.url1StartsWithUrl2(myUrl, r.getUrl());
                    if (relPath == null) continue;
                    repos = r;
                    break;
                }
            }
            filter = new PackageFilter();
            filter.setDAVScope(1);
            if (repos == null) {
                otp = false;
                authType = server.getAuthenticationType();
                if (authType != null && authType.equalsIgnoreCase("metadata")) {
                    otp = true;
                }
                if ((dit = server.getDomains().iterator()).hasNext()) {
                    domain = (String)dit.next();
                }
                if (!otp) {
                    if (domain != null) {
                        uc1 = uc;
                        domainString = domain;
                        action = new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return uc1.getIdentitiesByDomain(domainString, true, "");
                            }
                        };
                        try {
                            l = (List)AccessController.doPrivileged(action);
                            dItor = l.iterator();
                            if (!dItor.hasNext() || (identity = (UserIdentityInterface)dItor.next()) == null) ** GOTO lbl65
                            username = (String)identity.getPrincipal();
                            password = (String)identity.getCredential();
                        }
                        catch (PrivilegedActionException pae) {
                            t = pae.getCause();
                            if (t instanceof RemoteException) {
                                throw (RemoteException)t;
                            }
                            if (t instanceof SecurityException) {
                                throw (SecurityException)t;
                            }
                            throw new ServiceException(t);
                        }
                    }
                } else {
                    ui = uc.getAuthServer().generatePassword(null);
                    username = (String)ui.getPrincipal();
                    password = (String)ui.getCredential();
                }
lbl65:
                // 4 sources

                done = false;
                while (!done) {
                    try {
                        repos = new DAVRepository();
                        b = repos.connectWithProxy(server.getHost(), server.getTcpPort(), username, password, base, server.getProxyUrl(), isHttps);
                        if (!b) {
                            if (!otp) {
                                if (dItor != null && dItor.hasNext()) {
                                    identity = (UserIdentityInterface)dItor.next();
                                    if (identity == null) continue;
                                    username = (String)identity.getPrincipal();
                                    password = (String)identity.getCredential();
                                    continue;
                                }
                                this.logMessage(Level.WARN, RB.getStringResource("OMRChannel.davConnectFailed.txt"), OMRChannel.class.getName(), null);
                                return new ArrayList<E>(1);
                            }
                            this.logMessage(Level.WARN, RB.getStringResource("OMRChannel.davConnectFailed.txt"), OMRChannel.class.getName(), null);
                            return new ArrayList<E>(1);
                        }
                        repos.setUserContext(uc);
                        repos.setDomain(domain);
                        filter.setDAVBase("");
                        returnList = repos.search(filter);
                        uc.addRepository(repos);
                        done = true;
                    }
                    catch (ServiceException e) {
                        if (otp) {
                            throw e;
                        }
                        if (dItor != null && dItor.hasNext()) {
                            identity = (UserIdentityInterface)dItor.next();
                            if (identity == null) continue;
                            username = (String)identity.getPrincipal();
                            password = (String)identity.getCredential();
                            continue;
                        }
                        throw e;
                    }
                }
            } else {
                filter.setDAVBase(relPath);
                returnList = repos.search(filter);
            }
            if (compare != null) {
                Collections.sort(returnList, compare);
            }
            return returnList;
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), (Throwable)ex);
            return new ArrayList<E>(1);
        }
    }

    public int getDefaultTransport() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        int defaultTransport = 0;
        ITChannel chan = (ITChannel)this._repositoryObject;
        String def = chan.getDefaultTransport();
        defaultTransport = def == null || def.equals("") ? 0 : (TRANSPORT_ARCHIVE.equalsIgnoreCase(def) ? 2 : (TRANSPORT_WEBDAV.equalsIgnoreCase(def) ? 3 : 1));
        return defaultTransport;
    }

    @Override
    public int getDeliveryTransport() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        int defaultTransport = 0;
        ITChannel chan = (ITChannel)this._repositoryObject;
        String def = chan.getDefaultTransport();
        defaultTransport = def == null || def.equals("") ? 0 : (TRANSPORT_ARCHIVE.equalsIgnoreCase(def) ? 2 : (TRANSPORT_WEBDAV.equalsIgnoreCase(def) ? 3 : 1));
        return defaultTransport;
    }

    @Override
    public void setDeliveryTransport(int transport) throws ServiceException, RemoteException, IllegalArgumentException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String trans = null;
        if (transport == 0) {
            trans = "";
        } else if (transport == 3) {
            trans = TRANSPORT_WEBDAV;
        } else if (transport == 2) {
            trans = TRANSPORT_ARCHIVE;
        } else {
            throw new IllegalArgumentException(RB.getStringResource("OMRChannel.invalidTrans.ex.txt"));
        }
        ITChannel chan = (ITChannel)this._repositoryObject;
        chan.setDefaultTransport(trans);
    }

    @Override
    public String toString() {
        try {
            if (this.isDestroyed()) {
                return "Destroyed";
            }
            ITChannel chan = (ITChannel)this._repositoryObject;
            return "Channel: " + chan.getName();
        }
        catch (RemoteException rex) {
            return "Channel";
        }
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.reset();
        if (this._repositoryObject instanceof ITChannel) {
            ITChannel channel = (ITChannel)this._repositoryObject;
            MdObjectStore store = (MdObjectStore)channel.getObjectStore();
            if (store == null || store.isDisposed()) {
                this._repository.browseFetch("Channel+omi://host:port", null);
            }
            if (store != null) {
                try {
                    store.refreshObjectFromServer((CMetadata)channel, false, false);
                }
                catch (MdException mdex) {
                    throw new ServiceException(mdex);
                }
            }
            this._refreshPackages = true;
            try {
                channel.getArchivePaths(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRChannel.refreshArchivePaths.ex.txt"));
            }
            try {
                channel.getKeywords(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRChannel.refreshKeywords.ex.txt"));
            }
            try {
                channel.getProperties(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRChannel.refreshProperties.ex.txt"));
            }
            try {
                channel.getContentDestinations(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRChannel.refreshContentDestinations.ex.txt"));
            }
            this._refreshSubscribers = true;
            try {
                channel.getTrees(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRChannel.refreshTrees.ex.txt"));
            }
            this._refreshGroups = true;
        }
    }

    private final ServerComponent getServerComponent(List servers, int transportType) {
        ServerComponent serverComponent;
        block8: {
            serverComponent = null;
            try {
                if (servers == null || servers.size() <= 0) break block8;
                Object o = null;
                ServerComponent sc = null;
                Iterator iter = servers.iterator();
                String classId = null;
                boolean isHTTPServer = false;
                boolean isFTPServer = false;
                while (iter.hasNext()) {
                    o = iter.next();
                    if (o instanceof LogicalServer) {
                        try {
                            AssociationList components = ((LogicalServer)o).getUsingComponents();
                            if (components.size() <= 0) continue;
                            o = components.get(0);
                        }
                        catch (MdException mdex) {
                            throw new RuntimeException(mdex.getMessage(), mdex);
                        }
                    }
                    if (!(o instanceof ServerComponent)) continue;
                    sc = o;
                    classId = sc.getClassIdentifier();
                    isFTPServer = Strings.equal((String)"CBA26437-1577-4FF8-93F6-9B68B4DD8D2E", (String)classId, (boolean)false, (boolean)false);
                    boolean bl = isHTTPServer = !isFTPServer && Strings.equal((String)"DAC0D7F0-10DA-11D6-8816-AA0004006D06", (String)classId, (boolean)false, (boolean)false);
                    if (transportType == 2 && (isFTPServer || isHTTPServer)) {
                        serverComponent = sc;
                    } else {
                        if (transportType != 3 || !isHTTPServer) continue;
                        serverComponent = sc;
                    }
                    break;
                }
            }
            catch (RemoteException e) {
                serverComponent = null;
            }
        }
        return serverComponent;
    }

    @Override
    public boolean isPublishAuthorized() throws ServiceException, RemoteException {
        return this.isAuthorized("Write");
    }

    @Override
    public PropertyBagInterface getPropertyBag() throws ServiceException, RemoteException {
        PropertyBag spb;
        this.checkPulse(true);
        PropertyBag pb = (PropertyBag)super.getPropertyBag();
        PropertyBagListValue pblv = new PropertyBagListValue((Object)null, true);
        List subscribers = this.subscriberList(1);
        Iterator subIt = subscribers.iterator();
        while (subIt.hasNext()) {
            spb = (PropertyBag)((MetadataInterface)subIt.next()).getPropertyBag();
            pblv.add(spb);
        }
        pb.put("ContentSubscribers", pblv);
        pblv = new PropertyBagListValue((Object)null, true);
        subscribers = this.subscriberList(2);
        subIt = subscribers.iterator();
        while (subIt.hasNext()) {
            spb = (PropertyBag)((MetadataInterface)subIt.next()).getPropertyBag();
            pblv.add(spb);
        }
        return pb;
    }

    @Override
    public void updateFromBag(PropertyBagInterface propertyBag) throws ServiceException, RemoteException {
        this.checkPulse(true);
        PropertyBag theBag = (PropertyBag)propertyBag;
        PropertyBagListValue pblv = (PropertyBagListValue)theBag.getValue("ContentSubscribers");
        int valuesize = pblv.size();
        if (valuesize > 10000) {
            valuesize = 10000;
        }
        for (int i = 0; i < valuesize; ++i) {
            PropertyBag nextPb = (PropertyBag)pblv.get(i);
            MetadataInterface mi = nextPb.getSmartObject();
            mi.updateFromBag(nextPb);
        }
        if (pblv.isChanged()) {
            List subscribers = this.subscriberList(1);
            for (int i = 0; i < valuesize; ++i) {
                PropertyBag nextPb = (PropertyBag)pblv.get(i);
                MetadataInterface mi = nextPb.getSmartObject();
                if (subscribers.contains(mi)) continue;
                this.addContentSubscriber((ContentSubscriberInterface)mi);
            }
            int subscribersize = subscribers.size();
            for (int i = 0; i < subscribersize; ++i) {
                ContentSubscriberInterface csi = (ContentSubscriberInterface)subscribers.get(i);
                if (pblv.contains(csi)) continue;
                this.removeContentSubscriber(csi);
            }
        }
        super.updateFromBag(propertyBag);
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(false);
        ITChannel channel = (ITChannel)this._repositoryObject;
        try {
            int transport = this.getDefaultTransport();
            if (transport == 2) {
                Iterator it = this.packageList().iterator();
                while (it.hasNext()) {
                    try {
                        ((MetadataInterface)it.next()).delete();
                    }
                    catch (Throwable t) {
                        this.logMessage(Level.WARN, RB.getStringResource("OMRChannel.pkgDelete.fmt.txt"), this.getName(), t);
                    }
                }
                ContentDestination cd = this.getArchivePath();
                ServerInterface server = null;
                String relPath = null;
                if (cd != null) {
                    server = cd.getServer();
                    relPath = cd.getPath();
                }
                if (server == null || relPath != null) {
                    Iterator it2 = new ArrayList(channel.getArchivePaths()).iterator();
                    while (it2.hasNext()) {
                        this._repository.factoryProcess(it2.next()).delete();
                    }
                }
            } else if (transport == 3) {
                ContentDestination cd = this.getContentDestination();
                ServerInterface server = null;
                String relPath = null;
                if (cd != null) {
                    server = cd.getServer();
                    relPath = cd.getPath();
                }
                if (server != null && relPath != null) {
                    this._repository.factoryProcess(channel.getContentDestination()).delete();
                }
            }
        }
        catch (MdException mdex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.retrvErr.msg.txt"), OMRChannel.class.getName(), mdex);
        }
        super.delete();
    }

    private static final String getMetadataAccessExceptionMsg() {
        return RB.getStringResource("Metadata.accessexcept.msg.txt");
    }

    private void logException(Exception ex) {
        try {
            this.logThrowable(Level.WARN, OMRChannel.getMetadataAccessExceptionMsg(), OMRChannel.class.getName(), ex);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }

    @Override
    public MetadataInterface getEmbeddedObject(String subpath) throws ServiceException, RemoteException {
        String name = null;
        String type = null;
        int index = subpath.lastIndexOf(40);
        if (!subpath.endsWith(")")) {
            index = -1;
        }
        if (index > 0) {
            name = PathUrl.decodeString(subpath.substring(0, index));
            type = subpath.substring(index + 1, subpath.length() - 1);
            if (!"Package".equals(type)) {
                throw new ServiceException("Only a type of Package can be embedded in a Channel.");
            }
        } else {
            name = PathUrl.decodeString(subpath);
        }
        List archives = this.archiveList(null);
        for (MetadataInterface mi : archives) {
            if (!mi.getName().equals(name)) continue;
            return mi;
        }
        return null;
    }

    @SASScope
    private static class PackageFilter
    extends KeywordFilter {
        static final long serialVersionUID = 270614048776249134L;
        private ChannelInterface _channel;

        public PackageFilter() {
            this.setType("Package");
            this._channel = null;
        }

        public PackageFilter(String key, int relation, String value) {
            super(key, relation, value);
            this.setType("Package");
            this._channel = null;
        }

        @Override
        public String getOMRType() {
            return "ArchiveFile";
        }

        @Override
        public String getDAVType() {
            return "package|binarypackage";
        }

        public ChannelInterface getChannel() {
            return this._channel;
        }

        public void setChannel(ChannelInterface channel) {
            this._channel = channel;
        }

        @Override
        public String getXMLSelectString() {
            String name = this.getName();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<XMLSelect Search=\"*");
            boolean need_select = false;
            if (name != null) {
                buffer.append('[');
                if (name != null) {
                    buffer.append("@Name='" + name + '\'');
                }
                buffer.append(']');
                need_select = true;
            }
            if (this._channel != null) {
                block7: {
                    try {
                        Object o = this._channel.getRepositoryEntity();
                        if (!(o instanceof CMetadata)) break block7;
                        String channelName = null;
                        try {
                            channelName = this._channel.getName();
                        }
                        catch (RemoteException rex) {
                            channelName = "RemoteException";
                        }
                        buffer.append("[OwningChannel/ITChannel[@Name='" + channelName + "']]");
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                need_select = true;
            }
            buffer.append("\" />\n");
            return need_select ? buffer.toString() : "";
        }

        @Override
        public String getDAVBasicSearchString() {
            String name = this.getName();
            FilterComponent compy = this._component;
            FilterComponent nameComp = new FilterComponent();
            FilterComponent keywordComp = null;
            if (this._channel != null) {
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><d:searchrequest xmlns:d=\"DAV:\"><d:basicsearch/></d:searchrequest>";
            }
            if (name != null) {
                nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, name);
            }
            if (this._keywords.size() > 0) {
                keywordComp = new FilterComponent();
                for (String keyword : this._keywords) {
                    keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 1, keyword));
                    keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}description", 1, keyword));
                    keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}abstract", 1, keyword));
                }
                keywordComp.setAggregation(1);
            }
            if (keywordComp != null) {
                nameComp.addComponent(keywordComp);
                nameComp.setAggregation(0);
            }
            if (compy != null) {
                nameComp.addComponent(compy);
                nameComp.setAggregation(0);
            }
            this.setFilterComponent(nameComp);
            String result = super.getDAVBasicSearchString();
            this.setFilterComponent(compy);
            return result;
        }

        @Override
        public String getDAVSQLString() {
            String name = this.getName();
            FilterComponent compy = this._component;
            FilterComponent nameComp = new FilterComponent();
            FilterComponent keywordComp = null;
            if (this._channel != null) {
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql/></d:searchrequest>";
            }
            if (name != null) {
                nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, name);
            }
            if (this._keywords.size() > 0) {
                keywordComp = new FilterComponent();
                Iterator it = this._keywords.iterator();
                while (it.hasNext()) {
                    keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 0, (String)it.next()));
                }
                keywordComp.setAggregation(1);
            }
            if (keywordComp != null) {
                nameComp.addComponent(keywordComp);
                nameComp.setAggregation(0);
            }
            if (compy != null) {
                nameComp.addComponent(compy);
                nameComp.setAggregation(0);
            }
            this.setFilterComponent(nameComp);
            String result = super.getDAVSQLString();
            this.setFilterComponent(compy);
            return result;
        }
    }
}

