/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.impl.COMConnectionImpl;
import com.sas.metadata.remote.impl.COMConnectionImpl_Stub;
import com.sas.metadata.remote.impl.ConnectionImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.COMConnectionInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRConnection;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRCOMConnection
extends OMRConnection
implements COMConnectionInterface {
    private static final long serialVersionUID = -5695642293926275981L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRCOMConnection() throws RemoteException {
    }

    public OMRCOMConnection(COMConnection o) throws RemoteException {
        super((Connection)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRCOMConnection(COMConnectionImpl o) throws RemoteException {
        super((ConnectionImpl)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRCOMConnection(COMConnectionImpl_Stub o) throws RemoteException {
        super((Connection)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRCOMConnection(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                COMConnection connection = (COMConnection)omirepository.createMetadata(name, "COMConnection");
                connection.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = connection;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    connection.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", t);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "COMConnection";
    }

    @Override
    public String getHostName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        COMConnection conn = (COMConnection)this._repositoryObject;
        return conn.getHostName();
    }
}

