/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.PrototypeProperty;
import com.sas.metadata.remote.impl.AttributePropertyImpl;
import com.sas.metadata.remote.impl.AttributePropertyImpl_Stub;
import com.sas.metadata.remote.impl.PrototypePropertyImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.AttributePropertyInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdFilter;
import com.sas.services.information.metadata.OMRPrototypeProperty;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRAttributeProperty
extends OMRPrototypeProperty
implements AttributePropertyInterface {
    private static final long serialVersionUID = 644359914054058951L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRAttributeProperty(Class c) throws RemoteException {
        super(c);
    }

    public OMRAttributeProperty() throws RemoteException {
        super(OMRAttributeProperty.class);
    }

    protected OMRAttributeProperty(AttributeProperty o, Class c) throws RemoteException {
        super((PrototypeProperty)o, c);
    }

    public OMRAttributeProperty(AttributeProperty o) throws RemoteException {
        super((PrototypeProperty)o, OMRAttributeProperty.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRAttributeProperty(AttributePropertyImpl o, Class c) throws RemoteException {
        super((PrototypePropertyImpl)o, c);
    }

    public OMRAttributeProperty(AttributePropertyImpl o) throws RemoteException {
        super((PrototypePropertyImpl)o, OMRAttributeProperty.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRAttributeProperty(AttributePropertyImpl_Stub o, Class c) throws RemoteException {
        super((PrototypeProperty)o, c);
    }

    public OMRAttributeProperty(AttributePropertyImpl_Stub o) throws RemoteException {
        super((PrototypeProperty)o, OMRAttributeProperty.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAttributeProperty(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRAttributeProperty.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                AttributeProperty abstractProperty = (AttributeProperty)omirepository.createMetadata(name, "AttributeProperty");
                abstractProperty.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = abstractProperty;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    abstractProperty.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPhysicalTable", t);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "AttributeProperty";
    }

    @Override
    public String getPropertyRole() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        return ap.getPropertyRole();
    }

    @Override
    public void setPropertyRole(String role) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        ap.setPropertyRole(role);
    }

    @Override
    public String getPropertyName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        return ap.getPropertyName();
    }

    @Override
    public void setPropertyName(String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        ap.setPropertyName(name);
    }

    @Override
    public String getDefaultValue() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        return ap.getDefaultValue();
    }

    @Override
    public void setDefaultValue(String value) throws ServiceException, RemoteException {
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        ap.setDefaultValue(value);
    }

    @Override
    public int getSQLType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        try {
            PropertyType pt = ap.getOwningType();
            if (pt != null) {
                return pt.getSQLType();
            }
            return ap.getSQLType();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setSQLType(int type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AttributeProperty ap = (AttributeProperty)this._repositoryObject;
        boolean canDelete = true;
        try {
            PropertyType pt = ap.getOwningType();
            if (pt != null) {
                OMIRepositoryInterface ori = (OMIRepositoryInterface)this._repository;
                AssociationList groupList = pt.getGroups();
                if (groupList.size() > 0) {
                    canDelete = false;
                } else {
                    IdFilter filter = new IdFilter(pt.getFQID());
                    filter.setType(pt.getCMetadataType());
                    int count = ori.getCountNoSecurity(filter, "TypedAttProperties");
                    if (count > 1) {
                        canDelete = false;
                    } else {
                        count = ori.getCountNoSecurity(filter, "TypedProperties");
                        if (count > 0) {
                            canDelete = false;
                        }
                    }
                }
                if (canDelete) {
                    pt.setSQLType(type);
                } else {
                    ap.setSQLType(type);
                }
            } else {
                ap.setSQLType(type);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

