/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.services.information.Filter;
import com.sas.services.util.XMLUtil;
import java.util.ArrayList;
import java.util.Iterator;

public class KeywordFilter
extends Filter {
    private static final long serialVersionUID = 2868750798107630021L;
    private static final int KEYWORD_ARRAY_INIT = 6;
    private static final int SELECT_BUFFER_INIT = 256;
    protected ArrayList<String> _keywords = new ArrayList(6);

    public KeywordFilter() {
    }

    public KeywordFilter(String key, int relation, String value) {
        super(key, relation, value);
    }

    public void addKeyword(String keyword) {
        this._keywords.add(keyword);
    }

    public void removeKeyword(String keyword) {
        this._keywords.remove(keyword);
    }

    protected String getKeywordSelectString() {
        StringBuilder buffer = new StringBuilder(256);
        if (this._keywords.size() > 0) {
            buffer.append("[Keywords/*[");
            Iterator<String> it = this._keywords.iterator();
            boolean firstName = true;
            while (it.hasNext()) {
                if (!firstName) {
                    buffer.append(" OR ");
                }
                buffer.append("@Name='" + XMLUtil.normalize(it.next()) + '\'');
                firstName = false;
            }
            buffer.append(" ]]");
        }
        return buffer.toString();
    }

    @Override
    public String getXMLSelectString() {
        String superSelect = null;
        if (this._component != null || this.getName() != null) {
            superSelect = super.getXMLSelectString();
        }
        StringBuilder buffer = new StringBuilder(256);
        String keywordString = this.getKeywordSelectString();
        if (keywordString == null || keywordString.length() == 0) {
            return "";
        }
        if (superSelect != null) {
            int index = superSelect.lastIndexOf(93);
            buffer.append(superSelect.substring(0, index + 1));
        } else {
            buffer.append("<XMLSelect search=\"*");
        }
        buffer.append(keywordString);
        buffer.append("\" />\n");
        return buffer.toString();
    }
}

