/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class FilteredFolder
extends Folder
implements FilteredFolderInterface,
Serializable {
    static final long serialVersionUID = 4442293843479154250L;
    private static final int SUBFOLDER_ARRAY_INIT = 5;
    private static final int ITEM_ARRAY_INIT = 10;
    FilteredFolderInterface parent;
    FolderInterface realFolder;
    ArrayList subFolders = new ArrayList(5);
    ArrayList items = new ArrayList(10);

    public FilteredFolder(FilteredFolderInterface p, FolderInterface f) throws RemoteException {
        this(p, f, FilteredFolder.class);
    }

    protected FilteredFolder(FilteredFolderInterface p, FolderInterface f, Class theClass) throws RemoteException {
        super(theClass);
        this.parent = p;
        this.realFolder = f;
    }

    @Override
    public String getName() throws RemoteException {
        return this.realFolder.getName();
    }

    @Override
    public String getReposId() throws RemoteException {
        return this.realFolder.getReposId();
    }

    @Override
    public void addSubfolder(FolderInterface folder) throws ServiceException, RemoteException {
        if (!this.subFolders.contains(folder)) {
            this.subFolders.add(folder);
        }
    }

    @Override
    public void addLocalItem(MetadataInterface obj) throws RemoteException {
        if (!this.items.contains(obj)) {
            this.items.add(obj);
        }
    }

    @Override
    public FolderInterface getFolder() throws RemoteException {
        return this.realFolder;
    }

    @Override
    public String getType() throws RemoteException {
        return "FilteredFolder";
    }

    @Override
    public FolderInterface getParent() throws RemoteException {
        return this.parent;
    }

    @Override
    public List getItems() throws ServiceException, RemoteException {
        return new ArrayList(this.items);
    }

    public List getItems(String metadataType) throws ServiceException, RemoteException {
        return this.getItemsByType(metadataType);
    }

    @Override
    public List getItemsByType(String metadataType) throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(10);
        for (MetadataInterface mi : this.items) {
            if (!mi.getType().equalsIgnoreCase(metadataType)) continue;
            result.add(mi);
        }
        return result;
    }

    public List getItems(Class itemClass) throws ServiceException, RemoteException {
        return this.getItemsByClass(itemClass);
    }

    @Override
    public List getItemsByClass(Class itemClass) throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(10);
        for (MetadataInterface mi : this.items) {
            if (!mi.getClass().equals(itemClass)) continue;
            result.add(mi);
        }
        return result;
    }

    @Override
    public MetadataInterface getItem(String name) throws ServiceException, RemoteException {
        for (MetadataInterface mi : this.items) {
            if (!mi.getName().equals(name)) continue;
            return mi;
        }
        return null;
    }

    public MetadataInterface getItem(String name, String metadataType) throws ServiceException, RemoteException {
        return this.getItemByType(name, metadataType);
    }

    @Override
    public MetadataInterface getItemByType(String name, String metadataType) throws ServiceException, RemoteException {
        for (MetadataInterface mi : this.items) {
            if (!mi.getName().equals(name) || !mi.getType().equals(metadataType)) continue;
            return mi;
        }
        return null;
    }

    public MetadataInterface getItem(String name, Class itemClass) throws ServiceException, RemoteException {
        return this.getItemByClass(name, itemClass);
    }

    @Override
    public MetadataInterface getItemByClass(String name, Class itemClass) throws ServiceException, RemoteException {
        for (MetadataInterface mi : this.items) {
            if (!mi.getName().equals(name) || !mi.getClass().equals(itemClass)) continue;
            return mi;
        }
        return null;
    }

    @Override
    public List getSubfolders() throws ServiceException, RemoteException {
        return new ArrayList(this.subFolders);
    }

    @Override
    public FolderInterface getSubfolder(String name) throws ServiceException, RemoteException {
        for (FolderInterface fi : this.subFolders) {
            if (!fi.getName().equals(name)) continue;
            return fi;
        }
        return null;
    }
}

