/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.metadata.ContentInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVItemInterface;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Content
extends Metadata
implements ContentInterface {
    private static final long serialVersionUID = 6402775405511915920L;

    public Content() throws RemoteException {
        this(Content.class);
    }

    public Content(Object o) throws RemoteException {
        this(o, Content.class);
    }

    protected Content(Class subClass) throws RemoteException {
        super(subClass);
    }

    protected Content(Object o, Class subClass) throws RemoteException {
        super(o, subClass);
    }

    @Override
    public String getContentAsString() throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (!(d instanceof DAVItemInterface)) break;
                try {
                    int ptr;
                    InputStream contents = ((DAVItemInterface)d).getContents();
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    try {
                        int len;
                        while ((len = contents.read(buffer)) != -1) {
                            content.write(buffer, 0, len);
                        }
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    contents.close();
                    content.close();
                    String contentType = this.getContentType();
                    String charset = "ISO-8859-1";
                    if (contentType != null && (ptr = contentType.indexOf("charset=")) > 0) {
                        charset = contentType.substring(ptr + 8);
                    }
                    return content.toString(charset);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public InputStream getContentAsStream() throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (!(d instanceof DAVItemInterface)) break;
                return ((DAVItemInterface)d).getContents();
            }
        }
        return null;
    }

    @Override
    public byte[] getContentAsBytes() throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (!(d instanceof DAVItemInterface)) break;
                return ((DAVItemInterface)d).getContentsAsBytes();
            }
        }
        return null;
    }

    @Override
    public String getContentType() throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (!(d instanceof DAVItemInterface)) break;
                String contentType = ((DAVItemInterface)d).getContentType();
                if (contentType == null) {
                    contentType = "";
                }
                return contentType;
            }
        }
        return null;
    }

    @Override
    public void setContentType(String contentType) throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (!(d instanceof DAVItemInterface)) break;
                ((DAVItemInterface)d).setContentType(contentType);
                break;
            }
        }
    }

    @Override
    public void setContent(String content) throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int ptr;
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (!(d instanceof DAVItemInterface)) break;
                String contentType = this.getContentType();
                String charset = "ISO-8859-1";
                if (contentType != null && (ptr = contentType.indexOf("charset=")) > 0) {
                    charset = contentType.substring(ptr + 8);
                }
                try {
                    ((DAVItemInterface)d).setContents(content.getBytes(charset));
                }
                catch (UnsupportedEncodingException use) {
                    try {
                        ((DAVItemInterface)d).setContents(content.getBytes("ISO-8859-1"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                break;
            }
        }
    }

    @Override
    public void setContentFromStream(InputStream contentStream) throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (!(d instanceof DAVItemInterface)) break;
                ((DAVItemInterface)d).setContents(contentStream);
                break;
            }
        }
    }

    @Override
    public void setContentFromBytes(byte[] content) throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                if (d instanceof DAVItemInterface) {
                    ((DAVItemInterface)d).setContents(content);
                }
                this.setContentType("application/octet");
                break;
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Content";
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) throws RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                d.setAttribute(propertyName, propertyValue);
                break;
            }
        }
    }

    @Override
    public String getProperty(String propertyName) throws RemoteException {
        String property = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                property = d.getAttribute(propertyName);
                break;
            }
        }
        return property;
    }
}

